/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class HiveMetastoreExtension
implements BeforeAllCallback,
AfterAllCallback {
    private HiveMetaStoreClient metastoreClient;
    private TestHiveMetastore metastore;
    private final Map<String, String> hiveConfOverride;
    private final String databaseName;

    private HiveMetastoreExtension(String databaseName, Map<String, String> hiveConfOverride) {
        this.databaseName = databaseName;
        this.hiveConfOverride = hiveConfOverride;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.metastore = new TestHiveMetastore();
        HiveConf hiveConfWithOverrides = new HiveConf(TestHiveMetastore.class);
        if (this.hiveConfOverride != null) {
            for (Map.Entry<String, String> kv : this.hiveConfOverride.entrySet()) {
                hiveConfWithOverrides.set(kv.getKey(), kv.getValue());
            }
        }
        this.metastore.start(hiveConfWithOverrides);
        this.metastoreClient = new HiveMetaStoreClient(hiveConfWithOverrides);
        if (null != this.databaseName) {
            String dbPath = this.metastore.getDatabasePath(this.databaseName);
            Database db = new Database(this.databaseName, "description", dbPath, (Map)Maps.newHashMap());
            this.metastoreClient.createDatabase(db);
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (null != this.metastoreClient) {
            this.metastoreClient.close();
        }
        if (null != this.metastore) {
            this.metastore.stop();
        }
        this.metastoreClient = null;
        this.metastore = null;
    }

    public HiveMetaStoreClient metastoreClient() {
        return this.metastoreClient;
    }

    public HiveConf hiveConf() {
        return this.metastore.hiveConf();
    }

    public TestHiveMetastore metastore() {
        return this.metastore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String databaseName;
        private Map<String, String> config;

        public Builder withDatabase(String databaseToCreate) {
            this.databaseName = databaseToCreate;
            return this;
        }

        public Builder withConfig(Map<String, String> configToSet) {
            this.config = configToSet;
            return this;
        }

        public HiveMetastoreExtension build() {
            return new HiveMetastoreExtension(this.databaseName, this.config);
        }
    }
}

