/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveMetastoreTest;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TestHiveCatalog
extends HiveMetastoreTest {
    private static ImmutableMap meta = ImmutableMap.of((Object)"owner", (Object)"apache", (Object)"group", (Object)"iceberg", (Object)"comment", (Object)"iceberg  hiveCatalog test");
    @TempDir
    private Path temp;

    private Schema getTestSchema() {
        return new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableBuilder() throws Exception {
        Schema schema = this.getTestSchema();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.resolve("tbl").toString();
        try {
            Table table = catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).withLocation(location).withProperty("key1", "value1").withProperty("key2", "value2").create();
            Assertions.assertThat((String)table.location()).isEqualTo(location);
            Assertions.assertThat((List)table.schema().columns()).hasSize(2);
            Assertions.assertThat((List)table.spec().fields()).hasSize(1);
            Assertions.assertThat((Map)table.properties()).containsEntry((Object)"key1", (Object)"value1");
            Assertions.assertThat((Map)table.properties()).containsEntry((Object)"key2", (Object)"value2");
            Assertions.assertThat((Map)table.properties()).containsEntry((Object)"write.parquet.compression-codec", (Object)"zstd");
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithCaching() throws Exception {
        Schema schema = this.getTestSchema();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.resolve("tbl").toString();
        ImmutableMap properties = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        Catalog cachingCatalog = CachingCatalog.wrap((Catalog)catalog);
        try {
            Table table = cachingCatalog.createTable(tableIdent, schema, spec, location, (Map)properties);
            Assertions.assertThat((String)table.location()).isEqualTo(location);
            Assertions.assertThat((List)table.schema().columns()).hasSize(2);
            Assertions.assertThat((List)table.spec().fields()).hasSize(1);
            Assertions.assertThat((Map)table.properties()).containsEntry((Object)"key1", (Object)"value1");
            Assertions.assertThat((Map)table.properties()).containsEntry((Object)"key2", (Object)"value2");
            Assertions.assertThat((Map)table.properties()).containsEntry((Object)"write.parquet.compression-codec", (Object)"zstd");
        }
        finally {
            cachingCatalog.dropTable(tableIdent);
        }
    }

    @Test
    public void testInitialize() {
        Assertions.assertThatNoException().isThrownBy(() -> {
            HiveCatalog catalog = new HiveCatalog();
            catalog.initialize("hive", (Map)Maps.newHashMap());
        });
    }

    @Test
    public void testToStringWithoutSetConf() {
        Assertions.assertThatNoException().isThrownBy(() -> {
            HiveCatalog catalog = new HiveCatalog();
            catalog.toString();
        });
    }

    @Test
    public void testInitializeCatalogWithProperties() {
        HashMap properties = Maps.newHashMap();
        properties.put("uri", "thrift://examplehost:9083");
        properties.put("warehouse", "/user/hive/testwarehouse");
        HiveCatalog catalog = new HiveCatalog();
        catalog.initialize("hive", (Map)properties);
        Assertions.assertThat((String)catalog.getConf().get("hive.metastore.uris")).isEqualTo("thrift://examplehost:9083");
        Assertions.assertThat((String)catalog.getConf().get("hive.metastore.warehouse.dir")).isEqualTo("/user/hive/testwarehouse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableTxnBuilder() throws Exception {
        Schema schema = this.getTestSchema();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.resolve("tbl").toString();
        try {
            Transaction txn = catalog.buildTable(tableIdent, schema).withLocation(location).createTransaction();
            txn.commitTransaction();
            Table table = catalog.loadTable(tableIdent);
            Assertions.assertThat((String)table.location()).isEqualTo(location);
            Assertions.assertThat((List)table.schema().columns()).hasSize(2);
            Assertions.assertThat((boolean)table.spec().isUnpartitioned()).isTrue();
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testReplaceTxnBuilder(int formatVersion) {
        Schema schema = this.getTestSchema();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.resolve("tbl").toString();
        try {
            Transaction createTxn = catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).withLocation(location).withProperty("key1", "value1").withProperty("format-version", String.valueOf(formatVersion)).createOrReplaceTransaction();
            createTxn.commitTransaction();
            Table table = catalog.loadTable(tableIdent);
            Assertions.assertThat((List)table.spec().fields()).hasSize(1);
            String newLocation = this.temp.resolve("tbl-2").toString();
            Transaction replaceTxn = catalog.buildTable(tableIdent, schema).withProperty("key2", "value2").withLocation(newLocation).replaceTransaction();
            replaceTxn.commitTransaction();
            table = catalog.loadTable(tableIdent);
            Assertions.assertThat((String)table.location()).isEqualTo(newLocation);
            Assertions.assertThat((Object)table.currentSnapshot()).isNull();
            if (formatVersion == 1) {
                PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)table.schema()).alwaysNull("data", "data_bucket").withSpecId(1).build();
                ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Table should have a spec with one void field", new Object[0])).isEqualTo((Object)v1Expected);
            } else {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table spec must be unpartitioned", new Object[0])).isTrue();
            }
            Assertions.assertThat((Map)table.properties()).containsEntry((Object)"key1", (Object)"value1");
            Assertions.assertThat((Map)table.properties()).containsEntry((Object)"key2", (Object)"value2");
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    @Test
    public void testCreateTableWithOwner() throws Exception {
        this.createTableAndVerifyOwner("hivedb", "tbl_specified_owner", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.table.owner", (Object)"some_owner"), "some_owner");
        this.createTableAndVerifyOwner("hivedb", "tbl_default_owner", (Map<String, String>)ImmutableMap.of(), UserGroupInformation.getCurrentUser().getShortUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableAndVerifyOwner(String db, String tbl, Map<String, String> properties, String owner) throws IOException, TException {
        Schema schema = this.getTestSchema();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{db, tbl});
        String location = this.temp.resolve(tbl).toString();
        try {
            Table table = catalog.createTable(tableIdent, schema, spec, location, properties);
            org.apache.hadoop.hive.metastore.api.Table hmsTable = metastoreClient.getTable(db, tbl);
            Assertions.assertThat((String)hmsTable.getOwner()).isEqualTo(owner);
            Map hmsTableParams = hmsTable.getParameters();
            Assertions.assertThat((Map)hmsTableParams).doesNotContainKey((Object)"hive.metastore.table.owner");
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableDefaultSortOrder() throws Exception {
        Schema schema = this.getTestSchema();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            Table table = catalog.createTable(tableIdent, schema, spec);
            ((AbstractIntegerAssert)Assertions.assertThat((int)table.sortOrder().orderId()).as("Order ID must match", new Object[0])).isEqualTo(0);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.sortOrder().isUnsorted()).as("Order must unsorted", new Object[0])).isTrue();
            ((MapAssert)Assertions.assertThat(this.hmsTableParameters()).as("Must not have default sort order in catalog", new Object[0])).doesNotContainKey((Object)"default-sort-order");
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableCustomSortOrder() throws Exception {
        Schema schema = this.getTestSchema();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("id", NullOrder.NULLS_FIRST)).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            Table table = catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).withSortOrder(order).create();
            SortOrder sortOrder = table.sortOrder();
            ((AbstractIntegerAssert)Assertions.assertThat((int)sortOrder.orderId()).as("Order ID must match", new Object[0])).isEqualTo(1);
            ((ListAssert)Assertions.assertThat((List)sortOrder.fields()).as("Order must have 1 field", new Object[0])).hasSize(1);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((SortField)sortOrder.fields().get(0)).direction()).as("Direction must match ", new Object[0])).isEqualTo((Object)SortDirection.ASC);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((SortField)sortOrder.fields().get(0)).nullOrder()).as("Null order must match ", new Object[0])).isEqualTo((Object)NullOrder.NULLS_FIRST);
            Transform transform = Transforms.identity((Type)Types.IntegerType.get());
            ((ObjectAssert)Assertions.assertThat((Object)((SortField)sortOrder.fields().get(0)).transform()).as("Transform must match", new Object[0])).isEqualTo((Object)transform);
            Assertions.assertThat(this.hmsTableParameters()).containsEntry((Object)"default-sort-order", (Object)SortOrderParser.toJson((SortOrder)table.sortOrder()));
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    @Test
    public void testCreateNamespace() throws Exception {
        Namespace namespace1 = Namespace.of((String[])new String[]{"noLocation"});
        catalog.createNamespace(namespace1, (Map)meta);
        Database database1 = metastoreClient.getDatabase(namespace1.toString());
        Assertions.assertThat((Map)database1.getParameters()).containsEntry((Object)"owner", (Object)"apache");
        Assertions.assertThat((Map)database1.getParameters()).containsEntry((Object)"group", (Object)"iceberg");
        ((AbstractStringAssert)Assertions.assertThat((String)this.defaultUri(namespace1)).as("There no same location for db and namespace", new Object[0])).isEqualTo(database1.getLocationUri());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.createNamespace(namespace1)).isInstanceOf(AlreadyExistsException.class)).hasMessage("Namespace '" + namespace1 + "' already exists!");
        String hiveLocalDir = this.temp.toFile().toURI().toString();
        hiveLocalDir = hiveLocalDir.substring(0, hiveLocalDir.length() - 1);
        ImmutableMap newMeta = ImmutableMap.builder().putAll((Map)meta).put((Object)"location", (Object)hiveLocalDir).buildOrThrow();
        Namespace namespace2 = Namespace.of((String[])new String[]{"haveLocation"});
        catalog.createNamespace(namespace2, (Map)newMeta);
        Database database2 = metastoreClient.getDatabase(namespace2.toString());
        ((AbstractStringAssert)Assertions.assertThat((String)hiveLocalDir).as("There no same location for db and namespace", new Object[0])).isEqualTo(database2.getLocationUri());
    }

    @Test
    public void testCreateNamespaceWithOwnership() throws Exception {
        this.createNamespaceAndVerifyOwnership("default_ownership_1", (Map<String, String>)ImmutableMap.of(), UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER);
        this.createNamespaceAndVerifyOwnership("default_ownership_2", (Map<String, String>)ImmutableMap.of((Object)"non_owner_prop1", (Object)"value1", (Object)"non_owner_prop2", (Object)"value2"), UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER);
        this.createNamespaceAndVerifyOwnership("individual_ownership_1", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"apache", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.USER.name()), "apache", PrincipalType.USER);
        this.createNamespaceAndVerifyOwnership("individual_ownership_2", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"someone"), "someone", PrincipalType.USER);
        this.createNamespaceAndVerifyOwnership("group_ownership", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"iceberg", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), "iceberg", PrincipalType.GROUP);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createNamespaceAndVerifyOwnership("create_with_owner_type_alone", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner-type", (Object)PrincipalType.USER.name()), "no_post_create_expectation_due_to_exception_thrown", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Create namespace setting %s without setting %s is not allowed", "hive.metastore.database.owner-type", "hive.metastore.database.owner"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createNamespaceAndVerifyOwnership("create_with_invalid_owner_type", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"iceberg", (Object)"hive.metastore.database.owner-type", (Object)"invalidOwnerType"), "no_post_create_expectation_due_to_exception_thrown", null)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("No enum constant " + PrincipalType.class.getCanonicalName());
    }

    private void createNamespaceAndVerifyOwnership(String name, Map<String, String> prop, String expectedOwner, PrincipalType expectedOwnerType) throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{name});
        catalog.createNamespace(namespace, prop);
        Database db = metastoreClient.getDatabase(namespace.toString());
        Assertions.assertThat((String)db.getOwnerName()).isEqualTo(expectedOwner);
        Assertions.assertThat((Comparable)db.getOwnerType()).isEqualTo((Object)expectedOwnerType);
    }

    @Test
    public void testListNamespace() throws TException {
        Namespace namespace1 = Namespace.of((String[])new String[]{"dbname1"});
        catalog.createNamespace(namespace1, (Map)meta);
        List namespaces = catalog.listNamespaces(namespace1);
        ((ListAssert)Assertions.assertThat((List)namespaces).as("Hive db not hive the namespace 'dbname1'", new Object[0])).isEmpty();
        Namespace namespace2 = Namespace.of((String[])new String[]{"dbname2"});
        catalog.createNamespace(namespace2, (Map)meta);
        namespaces = catalog.listNamespaces();
        ((ListAssert)Assertions.assertThat((List)namespaces).as("Hive db not hive the namespace 'dbname2'", new Object[0])).contains((Object[])new Namespace[]{namespace2});
    }

    @Test
    public void testLoadNamespaceMeta() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_load"});
        catalog.createNamespace(namespace, (Map)meta);
        Map nameMata = catalog.loadNamespaceMetadata(namespace);
        Assertions.assertThat((Map)nameMata).containsEntry((Object)"owner", (Object)"apache");
        Assertions.assertThat((Map)nameMata).containsEntry((Object)"group", (Object)"iceberg");
        ((AbstractStringAssert)Assertions.assertThat((String)catalog.convertToDatabase(namespace, (Map)meta).getLocationUri()).as("There no same location for db and namespace", new Object[0])).isEqualTo((String)nameMata.get("location"));
    }

    @Test
    public void testNamespaceExists() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_exists"});
        catalog.createNamespace(namespace, (Map)meta);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(namespace)).as("Should true to namespace exist", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.namespaceExists(Namespace.of((String[])new String[]{"db2", "db2", "ns2"}))).as("Should false to namespace doesn't exist", new Object[0])).isFalse();
    }

    @Test
    public void testSetNamespaceProperties() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_set"});
        catalog.createNamespace(namespace, (Map)meta);
        catalog.setProperties(namespace, (Map)ImmutableMap.of((Object)"owner", (Object)"alter_apache", (Object)"test", (Object)"test", (Object)"location", (Object)"file:/data/tmp", (Object)"comment", (Object)"iceberg test"));
        Database database = metastoreClient.getDatabase(namespace.level(0));
        Assertions.assertThat((Map)database.getParameters()).containsEntry((Object)"owner", (Object)"alter_apache");
        Assertions.assertThat((Map)database.getParameters()).containsEntry((Object)"test", (Object)"test");
        Assertions.assertThat((Map)database.getParameters()).containsEntry((Object)"group", (Object)"iceberg");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.setProperties(Namespace.of((String[])new String[]{"db2", "db2", "ns2"}), (Map)ImmutableMap.of())).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: db2.db2.ns2");
    }

    @Test
    public void testSetNamespaceOwnership() throws TException {
        this.setNamespaceOwnershipAndVerify("set_individual_ownership_on_default_owner", (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_individual_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.USER.name()), System.getProperty("user.name"), PrincipalType.USER, "some_individual_owner", PrincipalType.USER);
        this.setNamespaceOwnershipAndVerify("set_group_ownership_on_default_owner", (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), System.getProperty("user.name"), PrincipalType.USER, "some_group_owner", PrincipalType.GROUP);
        this.setNamespaceOwnershipAndVerify("change_individual_to_group_ownership", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_owner"), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), "some_owner", PrincipalType.USER, "some_group_owner", PrincipalType.GROUP);
        this.setNamespaceOwnershipAndVerify("change_group_to_individual_ownership", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_individual_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.USER.name()), "some_group_owner", PrincipalType.GROUP, "some_individual_owner", PrincipalType.USER);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.setNamespaceOwnershipAndVerify("set_owner_without_setting_owner_type", (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_individual_owner"), System.getProperty("user.name"), PrincipalType.USER, "no_post_setting_expectation_due_to_exception_thrown", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Setting %s and %s has to be performed together or not at all", "hive.metastore.database.owner-type", "hive.metastore.database.owner"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.setNamespaceOwnershipAndVerify("set_owner_type_without_setting_owner", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_owner"), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), "some_owner", PrincipalType.USER, "no_post_setting_expectation_due_to_exception_thrown", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Setting %s and %s has to be performed together or not at all", "hive.metastore.database.owner-type", "hive.metastore.database.owner"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.setNamespaceOwnershipAndVerify("set_invalid_owner_type", (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"iceberg", (Object)"hive.metastore.database.owner-type", (Object)"invalidOwnerType"), System.getProperty("user.name"), PrincipalType.USER, "no_post_setting_expectation_due_to_exception_thrown", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("No enum constant org.apache.hadoop.hive.metastore.api.PrincipalType.invalidOwnerType");
    }

    @Test
    public void testSetNamespaceOwnershipNoop() throws TException, IOException {
        this.setNamespaceOwnershipAndVerify("set_ownership_noop_1", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_individual_owner"), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_individual_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.USER.name()), "some_individual_owner", PrincipalType.USER, "some_individual_owner", PrincipalType.USER);
        this.setNamespaceOwnershipAndVerify("set_ownership_noop_2", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), "some_group_owner", PrincipalType.GROUP, "some_group_owner", PrincipalType.GROUP);
        this.setNamespaceOwnershipAndVerify("set_ownership_noop_3", (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER, UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER);
        this.setNamespaceOwnershipAndVerify("set_ownership_noop_4", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), (Map<String, String>)ImmutableMap.of((Object)"unrelated_prop_1", (Object)"value_1", (Object)"unrelated_prop_2", (Object)"value_2"), "some_group_owner", PrincipalType.GROUP, "some_group_owner", PrincipalType.GROUP);
    }

    private void setNamespaceOwnershipAndVerify(String name, Map<String, String> propToCreate, Map<String, String> propToSet, String expectedOwnerPostCreate, PrincipalType expectedOwnerTypePostCreate, String expectedOwnerPostSet, PrincipalType expectedOwnerTypePostSet) throws TException {
        this.createNamespaceAndVerifyOwnership(name, propToCreate, expectedOwnerPostCreate, expectedOwnerTypePostCreate);
        catalog.setProperties(Namespace.of((String[])new String[]{name}), propToSet);
        Database database = metastoreClient.getDatabase(name);
        Assertions.assertThat((String)database.getOwnerName()).isEqualTo(expectedOwnerPostSet);
        Assertions.assertThat((Comparable)database.getOwnerType()).isEqualTo((Object)expectedOwnerTypePostSet);
    }

    @Test
    public void testRemoveNamespaceProperties() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_remove"});
        catalog.createNamespace(namespace, (Map)meta);
        catalog.removeProperties(namespace, (Set)ImmutableSet.of((Object)"comment", (Object)"owner"));
        Database database = metastoreClient.getDatabase(namespace.level(0));
        Assertions.assertThat((Map)database.getParameters()).doesNotContainKey((Object)"owner");
        Assertions.assertThat((Map)database.getParameters()).containsEntry((Object)"group", (Object)"iceberg");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.removeProperties(Namespace.of((String[])new String[]{"db2", "db2", "ns2"}), (Set)ImmutableSet.of((Object)"comment", (Object)"owner"))).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: db2.db2.ns2");
    }

    @Test
    public void testRemoveNamespaceOwnership() throws TException, IOException {
        this.removeNamespaceOwnershipAndVerify("remove_individual_ownership", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_owner"), (Set<String>)ImmutableSet.of((Object)"hive.metastore.database.owner", (Object)"hive.metastore.database.owner-type"), "some_owner", PrincipalType.USER, UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER);
        this.removeNamespaceOwnershipAndVerify("remove_group_ownership", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), (Set<String>)ImmutableSet.of((Object)"hive.metastore.database.owner", (Object)"hive.metastore.database.owner-type"), "some_group_owner", PrincipalType.GROUP, UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER);
        this.removeNamespaceOwnershipAndVerify("remove_ownership_on_default_noop_1", (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of((Object)"hive.metastore.database.owner", (Object)"hive.metastore.database.owner-type"), UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER, UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER);
        this.removeNamespaceOwnershipAndVerify("remove_ownership_on_default_noop_2", (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER, UserGroupInformation.getCurrentUser().getShortUserName(), PrincipalType.USER);
        this.removeNamespaceOwnershipAndVerify("remove_ownership_noop_1", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_owner"), (Set<String>)ImmutableSet.of(), "some_owner", PrincipalType.USER, "some_owner", PrincipalType.USER);
        this.removeNamespaceOwnershipAndVerify("remove_ownership_noop_2", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), (Set<String>)ImmutableSet.of(), "some_group_owner", PrincipalType.GROUP, "some_group_owner", PrincipalType.GROUP);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.removeNamespaceOwnershipAndVerify("remove_owner_without_removing_owner_type", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_individual_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.USER.name()), (Set<String>)ImmutableSet.of((Object)"hive.metastore.database.owner"), "some_individual_owner", PrincipalType.USER, "no_post_remove_expectation_due_to_exception_thrown", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Removing %s and %s has to be performed together or not at all", "hive.metastore.database.owner-type", "hive.metastore.database.owner"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.removeNamespaceOwnershipAndVerify("remove_owner_type_without_removing_owner", (Map<String, String>)ImmutableMap.of((Object)"hive.metastore.database.owner", (Object)"some_group_owner", (Object)"hive.metastore.database.owner-type", (Object)PrincipalType.GROUP.name()), (Set<String>)ImmutableSet.of((Object)"hive.metastore.database.owner-type"), "some_group_owner", PrincipalType.GROUP, "no_post_remove_expectation_due_to_exception_thrown", null)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Removing %s and %s has to be performed together or not at all", "hive.metastore.database.owner-type", "hive.metastore.database.owner"));
    }

    private void removeNamespaceOwnershipAndVerify(String name, Map<String, String> propToCreate, Set<String> propToRemove, String expectedOwnerPostCreate, PrincipalType expectedOwnerTypePostCreate, String expectedOwnerPostRemove, PrincipalType expectedOwnerTypePostRemove) throws TException {
        this.createNamespaceAndVerifyOwnership(name, propToCreate, expectedOwnerPostCreate, expectedOwnerTypePostCreate);
        catalog.removeProperties(Namespace.of((String[])new String[]{name}), propToRemove);
        Database database = metastoreClient.getDatabase(name);
        Assertions.assertThat((String)database.getOwnerName()).isEqualTo(expectedOwnerPostRemove);
        Assertions.assertThat((Comparable)database.getOwnerType()).isEqualTo((Object)expectedOwnerTypePostRemove);
    }

    @Test
    public void testDropNamespace() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_drop"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)"table");
        Schema schema = this.getTestSchema();
        catalog.createNamespace(namespace, (Map)meta);
        catalog.createTable(identifier, schema);
        Map nameMata = catalog.loadNamespaceMetadata(namespace);
        Assertions.assertThat((Map)nameMata).containsEntry((Object)"owner", (Object)"apache");
        Assertions.assertThat((Map)nameMata).containsEntry((Object)"group", (Object)"iceberg");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.dropNamespace(namespace)).isInstanceOf(NamespaceNotEmptyException.class)).hasMessage("Namespace dbname_drop is not empty. One or more tables exist.");
        Assertions.assertThat((boolean)catalog.dropTable(identifier, true)).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.dropNamespace(namespace)).as("Should fail to drop namespace if it is not empty", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.dropNamespace(Namespace.of((String[])new String[]{"db.ns1"}))).as("Should fail to drop when namespace doesn't exist", new Object[0])).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.loadNamespaceMetadata(namespace)).isInstanceOf(NoSuchNamespaceException.class)).hasMessage("Namespace does not exist: dbname_drop");
    }

    @Test
    public void testDropTableWithoutMetadataFile() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        Schema tableSchema = this.getTestSchema();
        catalog.createTable(identifier, tableSchema);
        String metadataFileLocation = catalog.newTableOps(identifier).current().metadataFileLocation();
        TableOperations ops = catalog.newTableOps(identifier);
        ops.io().deleteFile(metadataFileLocation);
        Assertions.assertThat((boolean)catalog.dropTable(identifier)).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.loadTable(identifier)).isInstanceOf(NoSuchTableException.class)).hasMessageContaining("Table does not exist:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableName() {
        Schema schema = this.getTestSchema();
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).create();
            Table table = catalog.loadTable(tableIdent);
            ((AbstractStringAssert)Assertions.assertThat((String)table.name()).as("Name must match", new Object[0])).isEqualTo("hive.hivedb.tbl");
            TableIdentifier snapshotsTableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl", "snapshots"});
            Table snapshotsTable = catalog.loadTable(snapshotsTableIdent);
            ((AbstractStringAssert)Assertions.assertThat((String)snapshotsTable.name()).as("Name must match", new Object[0])).isEqualTo("hive.hivedb.tbl.snapshots");
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    private String defaultUri(Namespace namespace) throws TException {
        return metastoreClient.getConfigValue("hive.metastore.warehouse.dir", "") + "/" + namespace.level(0) + ".db";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUUIDinTableProperties() throws Exception {
        Schema schema = this.getTestSchema();
        TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.resolve("tbl").toString();
        try {
            catalog.buildTable(tableIdentifier, schema).withLocation(location).create();
            Assertions.assertThat(this.hmsTableParameters()).containsKey((Object)"uuid");
        }
        finally {
            catalog.dropTable(tableIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotStatsTableProperties() throws Exception {
        Schema schema = this.getTestSchema();
        TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.resolve("tbl").toString();
        try {
            catalog.buildTable(tableIdentifier, schema).withLocation(location).create();
            Map<String, String> parameters = this.hmsTableParameters();
            Assertions.assertThat(parameters).containsEntry((Object)"snapshot-count", (Object)"0");
            ((MapAssert)((MapAssert)Assertions.assertThat(parameters).doesNotContainKey((Object)"current-snapshot-summary")).doesNotContainKey((Object)"current-snapshot-id")).doesNotContainKey((Object)"current-snapshot-timestamp-ms");
            Table icebergTable = catalog.loadTable(tableIdentifier);
            String fileName = UUID.randomUUID().toString();
            DataFile file = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(FileFormat.PARQUET.addExtension(fileName)).withRecordCount(2L).withFileSizeInBytes(0L).build();
            icebergTable.newFastAppend().appendFile(file).commit();
            parameters = this.hmsTableParameters();
            Assertions.assertThat(parameters).containsEntry((Object)"snapshot-count", (Object)"1");
            String summary = JsonUtil.mapper().writeValueAsString((Object)icebergTable.currentSnapshot().summary());
            Assertions.assertThat(parameters).containsEntry((Object)"current-snapshot-summary", (Object)summary);
            long snapshotId = icebergTable.currentSnapshot().snapshotId();
            Assertions.assertThat(parameters).containsEntry((Object)"current-snapshot-id", (Object)String.valueOf(snapshotId));
            Assertions.assertThat(parameters).containsEntry((Object)"current-snapshot-timestamp-ms", (Object)String.valueOf(icebergTable.currentSnapshot().timestampMillis()));
        }
        finally {
            catalog.dropTable(tableIdentifier);
        }
    }

    @Test
    public void testSetSnapshotSummary() throws Exception {
        Configuration conf = new Configuration();
        conf.set("iceberg.hive.table-property-max-size", "4000");
        HiveTableOperations ops = new HiveTableOperations(conf, null, null, catalog.name(), "hivedb", "tbl");
        Snapshot snapshot = (Snapshot)Mockito.mock(Snapshot.class);
        HashMap summary = Maps.newHashMap();
        Mockito.when((Object)snapshot.summary()).thenReturn((Object)summary);
        for (int i = 0; i < 100; ++i) {
            summary.put(String.valueOf(i), "value");
        }
        Assertions.assertThat((int)JsonUtil.mapper().writeValueAsString((Object)summary).length()).isLessThan(4000);
        HashMap parameters = Maps.newHashMap();
        ops.setSnapshotSummary((Map)parameters, snapshot);
        ((MapAssert)Assertions.assertThat((Map)parameters).as("The snapshot summary must be in parameters", new Object[0])).hasSize(1);
        for (int i = 0; i < 1000; ++i) {
            summary.put(String.valueOf(i), "value");
        }
        long summarySize = JsonUtil.mapper().writeValueAsString((Object)summary).length();
        Assertions.assertThat((long)summarySize).isGreaterThan(4000L).isLessThan(32672L);
        parameters.remove("current-snapshot-summary");
        ops.setSnapshotSummary((Map)parameters, snapshot);
        ((MapAssert)Assertions.assertThat((Map)parameters).as("The snapshot summary must not be in parameters due to the size limit", new Object[0])).isEmpty();
    }

    @Test
    public void testNotExposeTableProperties() {
        Configuration conf = new Configuration();
        conf.set("iceberg.hive.table-property-max-size", "0");
        HiveTableOperations ops = new HiveTableOperations(conf, null, null, catalog.name(), "hivedb", "tbl");
        TableMetadata metadata = (TableMetadata)Mockito.mock(TableMetadata.class);
        HashMap parameters = Maps.newHashMap();
        parameters.put("current-snapshot-summary", "summary");
        parameters.put("current-snapshot-id", "snapshotId");
        parameters.put("current-snapshot-timestamp-ms", "timestamp");
        parameters.put("current-schema", "schema");
        parameters.put("default-partition-spec", "partitionSpec");
        parameters.put("default-sort-order", "sortOrder");
        ops.setSnapshotStats(metadata, (Map)parameters);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)parameters).doesNotContainKey((Object)"current-snapshot-summary")).doesNotContainKey((Object)"current-snapshot-id")).doesNotContainKey((Object)"current-snapshot-timestamp-ms");
        ops.setSchema(metadata, (Map)parameters);
        Assertions.assertThat((Map)parameters).doesNotContainKey((Object)"current-schema");
        ops.setPartitionSpec(metadata, (Map)parameters);
        Assertions.assertThat((Map)parameters).doesNotContainKey((Object)"default-partition-spec");
        ops.setSortOrder(metadata, (Map)parameters);
        Assertions.assertThat((Map)parameters).doesNotContainKey((Object)"default-sort-order");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetDefaultPartitionSpec() throws Exception {
        Schema schema = this.getTestSchema();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            Table table = catalog.buildTable(tableIdent, schema).create();
            ((MapAssert)Assertions.assertThat(this.hmsTableParameters()).as("Must not have default partition spec", new Object[0])).doesNotContainKey((Object)"default-partition-spec");
            table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
            Assertions.assertThat(this.hmsTableParameters()).containsEntry((Object)"default-partition-spec", (Object)PartitionSpecParser.toJson((PartitionSpec)table.spec()));
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetCurrentSchema() throws Exception {
        Schema schema = this.getTestSchema();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            Table table = catalog.buildTable(tableIdent, schema).create();
            Assertions.assertThat(this.hmsTableParameters()).containsEntry((Object)"current-schema", (Object)SchemaParser.toJson((Schema)table.schema()));
            UpdateSchema updateSchema = table.updateSchema();
            for (int i = 0; i < 600; ++i) {
                updateSchema.addColumn("new_col_" + i, (Type)Types.StringType.get());
            }
            updateSchema.commit();
            Assertions.assertThat((int)SchemaParser.toJson((Schema)table.schema()).length()).isGreaterThan(32672);
            Assertions.assertThat(this.hmsTableParameters()).doesNotContainKey((Object)"current-schema");
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    private Map<String, String> hmsTableParameters() throws TException {
        org.apache.hadoop.hive.metastore.api.Table hmsTable = metastoreClient.getTable("hivedb", "tbl");
        return hmsTable.getParameters();
    }

    @Test
    public void testConstructorWarehousePathWithEndSlash() {
        HiveCatalog catalogWithSlash = new HiveCatalog();
        String wareHousePath = "s3://bucket/db/tbl";
        catalogWithSlash.initialize("hive_catalog", (Map)ImmutableMap.of((Object)"warehouse", (Object)(wareHousePath + "/")));
        ((AbstractStringAssert)Assertions.assertThat((String)catalogWithSlash.getConf().get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname)).as("Should have trailing slash stripped", new Object[0])).isEqualTo(wareHousePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTablePropsDefinedAtCatalogLevel() {
        Schema schema = this.getTestSchema();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        ImmutableMap catalogProps = ImmutableMap.of((Object)"table-default.key1", (Object)"catalog-default-key1", (Object)"table-default.key2", (Object)"catalog-default-key2", (Object)"table-default.key3", (Object)"catalog-default-key3", (Object)"table-override.key3", (Object)"catalog-override-key3", (Object)"table-override.key4", (Object)"catalog-override-key4");
        Catalog hiveCatalog = CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)catalogProps, (Object)hiveConf);
        try {
            Table table = hiveCatalog.buildTable(tableIdent, schema).withProperty("key2", "table-key2").withProperty("key3", "table-key3").withProperty("key5", "table-key5").create();
            ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table defaults set for the catalog must be added to the table properties.", new Object[0])).containsEntry((Object)"key1", (Object)"catalog-default-key1");
            ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table property must override table default properties set at catalog level.", new Object[0])).containsEntry((Object)"key2", (Object)"table-key2");
            ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table property override set at catalog level must override table default properties set at catalog level and table property specified.", new Object[0])).containsEntry((Object)"key3", (Object)"catalog-override-key3");
            ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table override not in table props or defaults should be added to table properties", new Object[0])).containsEntry((Object)"key4", (Object)"catalog-override-key4");
            ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table properties without any catalog level default or override should be added to table properties.", new Object[0])).containsEntry((Object)"key5", (Object)"table-key5");
        }
        finally {
            hiveCatalog.dropTable(tableIdent);
        }
    }

    @Test
    public void testDatabaseLocationWithSlashInWarehouseDir() {
        Configuration conf = new Configuration();
        conf.set("hive.metastore.warehouse.dir", "s3://bucket/");
        HiveCatalog catalog = new HiveCatalog();
        catalog.setConf(conf);
        Database database = catalog.convertToDatabase(Namespace.of((String[])new String[]{"database"}), (Map)ImmutableMap.of());
        Assertions.assertThat((String)database.getLocationUri()).isEqualTo("s3://bucket/database.db");
    }

    @Test
    public void testRegisterTable() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"hivedb", "t1"});
        catalog.createTable(identifier, this.getTestSchema());
        Table registeringTable = catalog.loadTable(identifier);
        catalog.dropTable(identifier, false);
        TableOperations ops = ((HasTableOperations)registeringTable).operations();
        String metadataLocation = ((HiveTableOperations)ops).currentMetadataLocation();
        Table registeredTable = catalog.registerTable(identifier, metadataLocation);
        Assertions.assertThat((Object)registeredTable).isNotNull();
        TestHelpers.assertSerializedAndLoadedMetadata((Table)registeringTable, (Table)registeredTable);
        String expectedMetadataLocation = ((HasTableOperations)registeredTable).operations().current().metadataFileLocation();
        Assertions.assertThat((String)metadataLocation).isEqualTo(expectedMetadataLocation);
        Assertions.assertThat((Object)catalog.loadTable(identifier)).isNotNull();
        Assertions.assertThat((boolean)catalog.dropTable(identifier)).isTrue();
    }

    @Test
    public void testRegisterExistingTable() {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"hivedb", "t1"});
        catalog.createTable(identifier, this.getTestSchema());
        Table registeringTable = catalog.loadTable(identifier);
        TableOperations ops = ((HasTableOperations)registeringTable).operations();
        String metadataLocation = ((HiveTableOperations)ops).currentMetadataLocation();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.registerTable(identifier, metadataLocation)).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: hivedb.t1");
        Assertions.assertThat((boolean)catalog.dropTable(identifier, true)).isTrue();
    }
}

