/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.hive.HiveTableBaseTest;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.util.Tasks;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveTableConcurrency
extends HiveTableBaseTest {
    @Test
    public synchronized void testConcurrentFastAppends() {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        String fileName = UUID.randomUUID().toString();
        DataFile file = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(FileFormat.PARQUET.addExtension(fileName)).withRecordCount(2L).withFileSizeInBytes(0L).build();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(2)));
        AtomicInteger barrier = new AtomicInteger(0);
        Tasks.range((int)2).stopOnFailure().throwFailureWhenFinished().executeWith(executorService).run(index -> {
            for (int numCommittedFiles = 0; numCommittedFiles < 10; ++numCommittedFiles) {
                while (barrier.get() < numCommittedFiles * 2) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                icebergTable.newFastAppend().appendFile(file).commit();
                barrier.incrementAndGet();
            }
        });
        icebergTable.refresh();
        Assert.assertEquals((long)20L, (long)icebergTable.currentSnapshot().allManifests(icebergTable.io()).size());
    }

    @Test
    public synchronized void testConcurrentConnections() throws InterruptedException {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        icebergTable.updateProperties().set("commit.retry.num-retries", "20").set("commit.retry.min-wait-ms", "25").set("commit.retry.max-wait-ms", "25").commit();
        String fileName = UUID.randomUUID().toString();
        DataFile file = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(FileFormat.PARQUET.addExtension(fileName)).withRecordCount(2L).withFileSizeInBytes(0L).build();
        ExecutorService executorService = MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newFixedThreadPool(7)));
        for (int i = 0; i < 7; ++i) {
            executorService.submit(() -> icebergTable.newAppend().appendFile(file).commit());
        }
        executorService.shutdown();
        Assert.assertTrue((String)"Timeout", (boolean)executorService.awaitTermination(3L, TimeUnit.MINUTES));
        Assert.assertEquals((long)7L, (long)Iterables.size((Iterable)icebergTable.snapshots()));
    }
}

