/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.Schema;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveSchemaUtil {
    private static final Schema SIMPLE_ICEBERG_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"customer_id", (Type)Types.LongType.get(), (String)"customer comment"), Types.NestedField.optional((int)1, (String)"first_name", (Type)Types.StringType.get(), (String)"first name comment")});
    private static final Schema COMPLEX_ICEBERG_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"id", (Type)Types.LongType.get(), (String)""), Types.NestedField.optional((int)1, (String)"name", (Type)Types.StringType.get(), (String)""), Types.NestedField.optional((int)2, (String)"employee_info", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"employer", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"address", (Type)Types.StringType.get())}), (String)""), Types.NestedField.optional((int)6, (String)"places_lived", (Type)Types.ListType.ofOptional((int)10, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)7, (String)"street", (Type)Types.StringType.get()), Types.NestedField.optional((int)8, (String)"city", (Type)Types.StringType.get()), Types.NestedField.optional((int)9, (String)"country", (Type)Types.StringType.get())})), (String)""), Types.NestedField.optional((int)11, (String)"memorable_moments", (Type)Types.MapType.ofOptional((int)15, (int)16, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)12, (String)"year", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)13, (String)"place", (Type)Types.StringType.get()), Types.NestedField.optional((int)14, (String)"details", (Type)Types.StringType.get())})), (String)""), Types.NestedField.optional((int)17, (String)"current_address", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"street_address", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)19, (String)"street_number", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)20, (String)"street_name", (Type)Types.StringType.get()), Types.NestedField.optional((int)21, (String)"street_type", (Type)Types.StringType.get())})), Types.NestedField.optional((int)22, (String)"country", (Type)Types.StringType.get()), Types.NestedField.optional((int)23, (String)"postal_code", (Type)Types.StringType.get())}), (String)"")});
    private static final List<FieldSchema> SIMPLE_HIVE_SCHEMA = ImmutableList.of((Object)new FieldSchema("customer_id", "bigint", "customer comment"), (Object)new FieldSchema("first_name", "string", "first name comment"));
    private static final List<FieldSchema> COMPLEX_HIVE_SCHEMA = ImmutableList.of((Object)new FieldSchema("id", "bigint", ""), (Object)new FieldSchema("name", "string", ""), (Object)new FieldSchema("employee_info", "struct<employer:string,id:bigint,address:string>", ""), (Object)new FieldSchema("places_lived", "array<struct<street:string,city:string,country:string>>", ""), (Object)new FieldSchema("memorable_moments", "map<string,struct<year:int,place:string,details:string>>", ""), (Object)new FieldSchema("current_address", "struct<street_address:struct<street_number:int,street_name:string,street_type:string>,country:string,postal_code:string>", ""));

    @Test
    public void testSimpleSchemaConvertToIcebergSchema() {
        Assert.assertEquals((Object)SIMPLE_ICEBERG_SCHEMA.asStruct(), (Object)HiveSchemaUtil.convert(SIMPLE_HIVE_SCHEMA).asStruct());
    }

    @Test
    public void testSimpleSchemaConvertToIcebergSchemaFromNameAndTypeLists() {
        List names = SIMPLE_HIVE_SCHEMA.stream().map(field -> field.getName()).collect(Collectors.toList());
        List types = SIMPLE_HIVE_SCHEMA.stream().map(field -> TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType())).collect(Collectors.toList());
        List comments = SIMPLE_HIVE_SCHEMA.stream().map(FieldSchema::getComment).collect(Collectors.toList());
        Assert.assertEquals((Object)SIMPLE_ICEBERG_SCHEMA.asStruct(), (Object)HiveSchemaUtil.convert(names, types, comments).asStruct());
    }

    @Test
    public void testComplexSchemaConvertToIcebergSchema() {
        Assert.assertEquals((Object)COMPLEX_ICEBERG_SCHEMA.asStruct(), (Object)HiveSchemaUtil.convert(COMPLEX_HIVE_SCHEMA).asStruct());
    }

    @Test
    public void testSchemaConvertToIcebergSchemaForEveryPrimitiveType() {
        Schema schemaWithEveryType = HiveSchemaUtil.convert(this.getSupportedFieldSchemas());
        Assert.assertEquals((Object)this.getSchemaWithSupportedTypes().asStruct(), (Object)schemaWithEveryType.asStruct());
    }

    @Test
    public void testNotSupportedTypes() {
        for (FieldSchema notSupportedField : this.getNotSupportedFieldSchemas()) {
            AssertHelpers.assertThrows((String)"should throw exception", IllegalArgumentException.class, (String)"Unsupported Hive type", () -> HiveSchemaUtil.convert((List)Lists.newArrayList(Arrays.asList(notSupportedField))));
        }
    }

    @Test
    public void testSimpleSchemaConvertToHiveSchema() {
        Assert.assertEquals(SIMPLE_HIVE_SCHEMA, (Object)HiveSchemaUtil.convert((Schema)SIMPLE_ICEBERG_SCHEMA));
    }

    @Test
    public void testComplexSchemaConvertToHiveSchema() {
        Assert.assertEquals(COMPLEX_HIVE_SCHEMA, (Object)HiveSchemaUtil.convert((Schema)COMPLEX_ICEBERG_SCHEMA));
    }

    @Test
    public void testSimpleTypeAndTypeInfoConvert() {
        List<FieldSchema> fieldSchemas = this.getSupportedFieldSchemas();
        List nestedFields = this.getSchemaWithSupportedTypes().columns();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            this.checkConvert(TypeInfoUtils.getTypeInfoFromTypeString((String)fieldSchemas.get(i).getType()), ((Types.NestedField)nestedFields.get(i)).type());
        }
    }

    @Test
    public void testComplexTypeAndTypeInfoConvert() {
        for (int i = 0; i < COMPLEX_HIVE_SCHEMA.size(); ++i) {
            this.checkConvert(TypeInfoUtils.getTypeInfoFromTypeString((String)COMPLEX_HIVE_SCHEMA.get(i).getType()), ((Types.NestedField)COMPLEX_ICEBERG_SCHEMA.columns().get(i)).type());
        }
    }

    @Test
    public void testConversionWithoutLastComment() {
        Schema expected = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"customer_id", (Type)Types.LongType.get(), (String)"customer comment"), Types.NestedField.optional((int)1, (String)"first_name", (Type)Types.StringType.get(), null)});
        Schema schema = HiveSchemaUtil.convert(Arrays.asList("customer_id", "first_name"), Arrays.asList(TypeInfoUtils.getTypeInfoFromTypeString((String)"bigint"), TypeInfoUtils.getTypeInfoFromTypeString((String)"string")), Arrays.asList("customer comment"));
        Assert.assertEquals((Object)expected.asStruct(), (Object)schema.asStruct());
    }

    protected List<FieldSchema> getSupportedFieldSchemas() {
        ArrayList fields = Lists.newArrayListWithCapacity((int)10);
        fields.add(new FieldSchema("c_float", "float", "float comment"));
        fields.add(new FieldSchema("c_double", "double", "double comment"));
        fields.add(new FieldSchema("c_boolean", "boolean", "boolean comment"));
        fields.add(new FieldSchema("c_int", "int", "int comment"));
        fields.add(new FieldSchema("c_long", "bigint", "long comment"));
        fields.add(new FieldSchema("c_binary", "binary", null));
        fields.add(new FieldSchema("c_string", "string", null));
        fields.add(new FieldSchema("c_timestamp", "timestamp", null));
        fields.add(new FieldSchema("c_date", "date", null));
        fields.add(new FieldSchema("c_decimal", "decimal(38,10)", null));
        return fields;
    }

    protected List<FieldSchema> getNotSupportedFieldSchemas() {
        ArrayList fields = Lists.newArrayListWithCapacity((int)6);
        fields.add(new FieldSchema("c_byte", "tinyint", ""));
        fields.add(new FieldSchema("c_short", "smallint", ""));
        fields.add(new FieldSchema("c_char", "char(5)", ""));
        fields.add(new FieldSchema("c_varchar", "varchar(5)", ""));
        fields.add(new FieldSchema("c_interval_date", "interval_year_month", ""));
        fields.add(new FieldSchema("c_interval_time", "interval_day_time", ""));
        return fields;
    }

    protected Schema getSchemaWithSupportedTypes() {
        return new Schema(new Types.NestedField[]{Types.NestedField.optional((int)0, (String)"c_float", (Type)Types.FloatType.get(), (String)"float comment"), Types.NestedField.optional((int)1, (String)"c_double", (Type)Types.DoubleType.get(), (String)"double comment"), Types.NestedField.optional((int)2, (String)"c_boolean", (Type)Types.BooleanType.get(), (String)"boolean comment"), Types.NestedField.optional((int)3, (String)"c_int", (Type)Types.IntegerType.get(), (String)"int comment"), Types.NestedField.optional((int)4, (String)"c_long", (Type)Types.LongType.get(), (String)"long comment"), Types.NestedField.optional((int)5, (String)"c_binary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)6, (String)"c_string", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"c_timestamp", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)8, (String)"c_date", (Type)Types.DateType.get()), Types.NestedField.optional((int)9, (String)"c_decimal", (Type)Types.DecimalType.of((int)38, (int)10))});
    }

    private void checkConvert(TypeInfo typeInfo, Type type) {
        Assert.assertEquals((Object)typeInfo, (Object)HiveSchemaUtil.convert((Type)type));
        this.assertEquals(type, HiveSchemaUtil.convert((TypeInfo)typeInfo));
    }

    private void assertEquals(Type expected, Type actual) {
        if (actual.isPrimitiveType()) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else {
            List expectedFields = ((Type.NestedType)expected).fields();
            List actualFields = ((Type.NestedType)actual).fields();
            for (int i = 0; i < expectedFields.size(); ++i) {
                this.assertEquals(((Types.NestedField)expectedFields.get(i)).type(), ((Types.NestedField)actualFields.get(i)).type());
                Assert.assertEquals((Object)((Types.NestedField)expectedFields.get(i)).name(), (Object)((Types.NestedField)actualFields.get(i)).name());
            }
        }
    }
}

