/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.ScriptRunner;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.junit.Assert;

public class TestHiveMetastore {
    private static final String DEFAULT_DATABASE_NAME = "default";
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final DynConstructors.Ctor<HiveMetaStore.HMSHandler> HMS_HANDLER_CTOR = DynConstructors.builder().impl(HiveMetaStore.HMSHandler.class, new Class[]{String.class, Configuration.class}).impl(HiveMetaStore.HMSHandler.class, new Class[]{String.class, HiveConf.class}).build();
    private static final DynMethods.StaticMethod GET_BASE_HMS_HANDLER = DynMethods.builder((String)"getProxy").impl(RetryingHMSHandler.class, new Class[]{Configuration.class, IHMSHandler.class, Boolean.TYPE}).impl(RetryingHMSHandler.class, new Class[]{HiveConf.class, IHMSHandler.class, Boolean.TYPE}).buildStatic();
    private static final DynMethods.StaticMethod METASTORE_THREADS_SHUTDOWN = DynMethods.builder((String)"shutdown").impl("org.apache.hadoop.hive.metastore.ThreadPool", new Class[0]).orNoop().buildStatic();
    private static final File HIVE_LOCAL_DIR;
    private static final String DERBY_PATH;
    private HiveConf hiveConf;
    private ExecutorService executorService;
    private TServer server;
    private HiveMetaStore.HMSHandler baseHandler;
    private HiveClientPool clientPool;

    public void start() {
        this.start(new HiveConf(new Configuration(), TestHiveMetastore.class), 5);
    }

    public void start(HiveConf conf) {
        this.start(conf, 5);
    }

    public void start(HiveConf conf, int poolSize) {
        try {
            TServerSocket socket = new TServerSocket(0);
            int port = socket.getServerSocket().getLocalPort();
            this.initConf(conf, port);
            this.hiveConf = conf;
            this.server = this.newThriftServer(socket, poolSize, this.hiveConf);
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.submit(() -> this.server.serve());
            System.setProperty(HiveConf.ConfVars.METASTOREURIS.varname, this.hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
            this.clientPool = new HiveClientPool(1, (Configuration)this.hiveConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot start TestHiveMetastore", e);
        }
    }

    public void stop() throws Exception {
        this.reset();
        if (this.clientPool != null) {
            this.clientPool.close();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.baseHandler != null) {
            this.baseHandler.shutdown();
        }
        METASTORE_THREADS_SHUTDOWN.invoke(new Object[0]);
    }

    public HiveConf hiveConf() {
        return this.hiveConf;
    }

    public String getDatabasePath(String dbName) {
        File dbDir = new File(HIVE_LOCAL_DIR, dbName + ".db");
        return dbDir.getPath();
    }

    public void reset() throws Exception {
        if (this.clientPool != null) {
            for (String dbName : (List)this.clientPool.run(client -> client.getAllDatabases())) {
                for (String tblName : (List)this.clientPool.run(client -> client.getAllTables(dbName))) {
                    this.clientPool.run(client -> {
                        client.dropTable(dbName, tblName, true, true, true);
                        return null;
                    });
                }
                if (DEFAULT_DATABASE_NAME.equals(dbName)) continue;
                this.clientPool.run(client -> {
                    client.dropDatabase(dbName, true, true, true);
                    return null;
                });
            }
        }
        Path warehouseRoot = new Path(HIVE_LOCAL_DIR.getAbsolutePath());
        FileSystem fs = Util.getFs((Path)warehouseRoot, (Configuration)this.hiveConf);
        for (FileStatus fileStatus : fs.listStatus(warehouseRoot)) {
            if (fileStatus.getPath().getName().equals("derby.log") || fileStatus.getPath().getName().equals("metastore_db")) continue;
            fs.delete(fileStatus.getPath(), true);
        }
    }

    public Table getTable(String dbName, String tableName) throws TException, InterruptedException {
        return (Table)this.clientPool.run(client -> client.getTable(dbName, tableName));
    }

    public Table getTable(TableIdentifier identifier) throws TException, InterruptedException {
        return this.getTable(identifier.namespace().toString(), identifier.name());
    }

    private TServer newThriftServer(TServerSocket socket, int poolSize, HiveConf conf) throws Exception {
        HiveConf serverConf = new HiveConf(conf);
        serverConf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:" + DERBY_PATH + ";create=true");
        this.baseHandler = (HiveMetaStore.HMSHandler)HMS_HANDLER_CTOR.newInstance(new Object[]{"new db based metaserver", serverConf});
        IHMSHandler handler = (IHMSHandler)GET_BASE_HMS_HANDLER.invoke(new Object[]{serverConf, this.baseHandler, false});
        TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)socket).processor((TProcessor)new TSetIpAddressProcessor((ThriftHiveMetastore.Iface)handler))).transportFactory(new TTransportFactory())).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(poolSize).maxWorkerThreads(poolSize);
        return new TThreadPoolServer(args);
    }

    private void initConf(HiveConf conf, int port) {
        conf.set(HiveConf.ConfVars.METASTOREURIS.varname, "thrift://localhost:" + port);
        conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, "file:" + HIVE_LOCAL_DIR.getAbsolutePath());
        conf.set(HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname, "false");
        conf.set(HiveConf.ConfVars.METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES.varname, "false");
        conf.set("iceberg.hive.client-pool-size", "2");
    }

    private static void setupMetastoreDB(String dbURL) throws SQLException, IOException {
        Connection connection = DriverManager.getConnection(dbURL);
        ScriptRunner scriptRunner = new ScriptRunner(connection, true, true);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("hive-schema-3.1.0.derby.sql");
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            scriptRunner.runScript(reader);
        }
    }

    static {
        try {
            HIVE_LOCAL_DIR = Files.createTempDirectory("hive", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"))).toFile();
            DERBY_PATH = new File(HIVE_LOCAL_DIR, "metastore_db").getPath();
            File derbyLogFile = new File(HIVE_LOCAL_DIR, "derby.log");
            System.setProperty("derby.stream.error.file", derbyLogFile.getAbsolutePath());
            TestHiveMetastore.setupMetastoreDB("jdbc:derby:" + DERBY_PATH + ";create=true");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                Path localDirPath = new Path(HIVE_LOCAL_DIR.getAbsolutePath());
                FileSystem fs = Util.getFs((Path)localDirPath, (Configuration)new Configuration());
                String errMsg = "Failed to delete " + localDirPath;
                try {
                    Assert.assertTrue((String)errMsg, (boolean)fs.delete(localDirPath, true));
                }
                catch (IOException e) {
                    throw new RuntimeException(errMsg, e);
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to setup local dir for hive metastore", e);
        }
    }
}

