/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hive.HiveMetastoreTest;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Before;

public class HiveTableBaseTest
extends HiveMetastoreTest {
    static final String TABLE_NAME = "tbl";
    static final TableIdentifier TABLE_IDENTIFIER = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
    static final Schema schema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())}).fields());
    static final Schema altered = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get())}).fields());
    private static final PartitionSpec partitionSpec = PartitionSpec.builderFor((Schema)schema).identity("id").build();
    private Path tableLocation;

    @Before
    public void createTestTable() {
        this.tableLocation = new Path(catalog.createTable(TABLE_IDENTIFIER, schema, partitionSpec).location());
    }

    @After
    public void dropTestTable() throws Exception {
        this.tableLocation.getFileSystem((Configuration)hiveConf).delete(this.tableLocation, true);
        catalog.dropTable(TABLE_IDENTIFIER, false);
    }

    private static String getTableBasePath(String tableName) {
        String databasePath = metastore.getDatabasePath("hivedb");
        return Paths.get(databasePath, tableName).toAbsolutePath().toString();
    }

    protected static Path getTableLocationPath(String tableName) {
        return new Path("file", null, Paths.get(HiveTableBaseTest.getTableBasePath(tableName), new String[0]).toString());
    }

    protected static String getTableLocation(String tableName) {
        return HiveTableBaseTest.getTableLocationPath(tableName).toString();
    }

    protected static String metadataLocation(String tableName) {
        return Paths.get(HiveTableBaseTest.getTableBasePath(tableName), "metadata").toString();
    }

    private static List<String> metadataFiles(String tableName) {
        return Arrays.stream(new File(HiveTableBaseTest.metadataLocation(tableName)).listFiles()).map(File::getAbsolutePath).collect(Collectors.toList());
    }

    protected static List<String> metadataVersionFiles(String tableName) {
        return HiveTableBaseTest.filterByExtension(tableName, TableMetadataParser.getFileExtension((TableMetadataParser.Codec)TableMetadataParser.Codec.NONE));
    }

    protected static List<String> manifestFiles(String tableName) {
        return HiveTableBaseTest.filterByExtension(tableName, ".avro");
    }

    private static List<String> filterByExtension(String tableName, String extension) {
        return HiveTableBaseTest.metadataFiles(tableName).stream().filter(f -> f.endsWith(extension)).collect(Collectors.toList());
    }
}

