/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hive.HiveMetastoreTest;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HiveCreateReplaceTableTest
extends HiveMetastoreTest {
    private static final String TABLE_NAME = "tbl";
    private static final TableIdentifier TABLE_IDENTIFIER = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private String tableLocation;

    @Before
    public void createTableLocation() throws IOException {
        this.tableLocation = this.temp.newFolder("hive-").getPath();
    }

    @After
    public void cleanup() {
        catalog.dropTable(TABLE_IDENTIFIER);
    }

    @Test
    public void testCreateTableTxn() {
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        txn.updateProperties().set("prop", "value").commit();
        Assert.assertFalse((boolean)catalog.tableExists(TABLE_IDENTIFIER));
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        Assert.assertEquals((String)"Table props should match", (Object)"value", table.properties().get("prop"));
    }

    @Test
    public void testCreateTableTxnTableCreatedConcurrently() {
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC);
        Assert.assertTrue((String)"Table should be created", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        AssertHelpers.assertThrows((String)"Create table txn should fail", AlreadyExistsException.class, (String)"Table already exists: hivedb.tbl", () -> ((Transaction)txn).commitTransaction());
    }

    @Test
    public void testCreateTableTxnAndAppend() {
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        AppendFiles append = txn.newAppend();
        DataFile dataFile = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(0L).withRecordCount(1L).build();
        append.appendFile(dataFile);
        append.commit();
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        Snapshot snapshot = table.currentSnapshot();
        Assert.assertTrue((String)"Table should have one manifest file", (snapshot.allManifests(table.io()).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateTableTxnTableAlreadyExists() {
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC);
        Assert.assertTrue((String)"Table should be created", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        AssertHelpers.assertThrows((String)"Should not be possible to start a new create table txn", AlreadyExistsException.class, (String)"Table already exists: hivedb.tbl", () -> catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap()));
    }

    @Test
    public void testReplaceTableTxn() {
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, false);
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)table.schema()).alwaysNull("id", "id").withSpecId(1).build();
        Assert.assertEquals((String)"Table should have a spec with one void field", (Object)v1Expected, (Object)table.spec());
    }

    @Test
    public void testReplaceTableTxnTableNotExists() {
        AssertHelpers.assertThrows((String)"Should not be possible to start a new replace table txn", NoSuchTableException.class, (String)"Table does not exist: hivedb.tbl", () -> catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, false));
    }

    @Test
    public void testReplaceTableTxnTableDeletedConcurrently() {
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, false);
        catalog.dropTable(TABLE_IDENTIFIER);
        txn.updateProperties().set("prop", "value").commit();
        AssertHelpers.assertThrows((String)"Replace table txn should fail", NoSuchTableException.class, (String)"No such table: hivedb.tbl", () -> ((Transaction)txn).commitTransaction());
    }

    @Test
    public void testReplaceTableTxnTableModifiedConcurrently() {
        Table table = catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, false);
        table.updateProperties().set("another-prop", "another-value").commit();
        txn.updateProperties().set("prop", "value").commit();
        txn.commitTransaction();
        table = catalog.loadTable(TABLE_IDENTIFIER);
        Assert.assertNull((String)"Table props should be updated", table.properties().get("another-prop"));
        Assert.assertEquals((String)"Table props should match", (Object)"value", table.properties().get("prop"));
    }

    @Test
    public void testCreateOrReplaceTableTxnTableNotExists() {
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, true);
        txn.updateProperties().set("prop", "value").commit();
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        Assert.assertEquals((String)"Table props should match", (Object)"value", table.properties().get("prop"));
    }

    @Test
    public void testCreateOrReplaceTableTxnTableExists() {
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, true);
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)table.schema()).alwaysNull("id", "id").withSpecId(1).build();
        Assert.assertEquals((String)"Table should have a spec with one void field", (Object)v1Expected, (Object)table.spec());
    }

    @Test
    public void testCreateOrReplaceTableTxnTableDeletedConcurrently() {
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC);
        Assert.assertTrue((String)"Table should be created", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, PartitionSpec.unpartitioned(), this.tableLocation, (Map)Maps.newHashMap(), true);
        txn.updateProperties().set("prop", "value").commit();
        catalog.dropTable(TABLE_IDENTIFIER);
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        Assert.assertEquals((String)"Table props should match", (Object)"value", table.properties().get("prop"));
    }

    @Test
    public void testCreateOrReplaceTableTxnTableCreatedConcurrently() {
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, PartitionSpec.unpartitioned(), this.tableLocation, (Map)Maps.newHashMap(), true);
        txn.updateProperties().set("prop", "value").commit();
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC);
        Assert.assertTrue((String)"Table should be created", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        Assert.assertEquals((String)"Partition spec should match", (Object)PartitionSpec.unpartitioned(), (Object)table.spec());
        Assert.assertEquals((String)"Table props should match", (Object)"value", table.properties().get("prop"));
    }

    @Test
    public void testCreateTableTxnWithGlobalTableLocation() {
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Transaction txn = catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, "file:///" + this.tableLocation, (Map)Maps.newHashMap());
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        DataFile dataFile = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(0L).withRecordCount(1L).build();
        table.newAppend().appendFile(dataFile).commit();
        Assert.assertEquals((String)"Write should succeed", (long)1L, (long)Iterables.size((Iterable)table.snapshots()));
    }
}

