/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;

public interface ContentFile<F> {
    public Long pos();

    public int specId();

    public FileContent content();

    public CharSequence path();

    public FileFormat format();

    public StructLike partition();

    public long recordCount();

    public long fileSizeInBytes();

    public Map<Integer, Long> columnSizes();

    public Map<Integer, Long> valueCounts();

    public Map<Integer, Long> nullValueCounts();

    public Map<Integer, Long> nanValueCounts();

    public Map<Integer, ByteBuffer> lowerBounds();

    public Map<Integer, ByteBuffer> upperBounds();

    public ByteBuffer keyMetadata();

    public List<Long> splitOffsets();

    public List<Integer> equalityFieldIds();

    default public Integer sortOrderId() {
        return null;
    }

    public F copy();

    public F copyWithoutStats();

    default public F copy(boolean withStats) {
        return withStats ? this.copy() : this.copyWithoutStats();
    }
}

