/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hugegraph.driver.SchemaManager;
import org.apache.hugegraph.structure.constant.EdgeLabelType;
import org.apache.hugegraph.structure.constant.Frequency;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.schema.SchemaBuilder;
import org.apache.hugegraph.structure.schema.SchemaLabel;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;

public class EdgeLabel
extends SchemaLabel {
    @JsonProperty(value="edgelabel_type")
    private EdgeLabelType edgeLabelType = EdgeLabelType.NORMAL;
    @JsonProperty(value="parent_label")
    private String parentLabel;
    @JsonProperty(value="frequency")
    private Frequency frequency = Frequency.DEFAULT;
    @JsonProperty(value="source_label")
    private String sourceLabel = null;
    @JsonProperty(value="target_label")
    private String targetLabel = null;
    @JsonProperty(value="links")
    private Set<Map<String, String>> links = new HashSet<Map<String, String>>();
    @JsonProperty(value="sort_keys")
    private List<String> sortKeys = new CopyOnWriteArrayList<String>();
    @JsonProperty(value="ttl")
    private long ttl = 0L;
    @JsonProperty(value="ttl_start_time")
    private String ttlStartTime = null;

    @JsonCreator
    public EdgeLabel(@JsonProperty(value="name") String name) {
        super(name);
    }

    @Override
    public String type() {
        return HugeType.EDGE_LABEL.string();
    }

    public boolean parent() {
        return this.edgeLabelType.parent();
    }

    public boolean sub() {
        return this.edgeLabelType.sub();
    }

    public String parentLabel() {
        return this.parentLabel;
    }

    public EdgeLabelType edgeLabelType() {
        return this.edgeLabelType;
    }

    public Frequency frequency() {
        return this.frequency;
    }

    public String sourceLabel() {
        E.checkState((this.links.size() == 1 ? 1 : 0) != 0, (String)"Only edge label has single vertex label pair can call sourceLabelName(), but current edge label got %s", (Object[])new Object[]{this.links.size()});
        return this.links.iterator().next().keySet().iterator().next();
    }

    public String targetLabel() {
        E.checkState((this.links.size() == 1 ? 1 : 0) != 0, (String)"Only edge label has single vertex label pair can call targetLabelName(), but current edge label got %s", (Object[])new Object[]{this.links.size()});
        return this.links.iterator().next().values().iterator().next();
    }

    public Set<Map<String, String>> links() {
        return this.links;
    }

    public boolean linkedVertexLabel(String vertexLabel) {
        if (this.edgeLabelType.parent() || this.links == null || this.links.isEmpty()) {
            return false;
        }
        for (Map<String, String> pair : this.links) {
            for (String str : pair.keySet()) {
                if (!str.equals(vertexLabel) && !pair.get(str).equals(vertexLabel)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> sortKeys() {
        return this.sortKeys;
    }

    public long ttl() {
        return this.ttl;
    }

    public String ttlStartTime() {
        return this.ttlStartTime;
    }

    @Override
    public String toString() {
        return String.format("{name=%s, sourceLabel=%s, targetLabel=%s, edgeLabel_type=%s, parent_label=%s, links=%s, sortKeys=%s, indexLabels=%s, nullableKeys=%s, properties=%s, ttl=%s, ttlStartTime=%s, status=%s}", new Object[]{this.name, this.sourceLabel(), this.targetLabel(), this.edgeLabelType, this.parentLabel, this.links, this.sortKeys, this.indexLabels, this.nullableKeys, this.properties, this.ttl, this.ttlStartTime, this.status});
    }

    public EdgeLabelV53 switchV53() {
        return new EdgeLabelV53(this);
    }

    public static class EdgeLabelV53
    extends SchemaLabel {
        @JsonProperty(value="frequency")
        private Frequency frequency;
        @JsonProperty(value="source_label")
        private String sourceLabel;
        @JsonProperty(value="target_label")
        private String targetLabel;
        @JsonProperty(value="sort_keys")
        private List<String> sortKeys;

        @JsonCreator
        public EdgeLabelV53(@JsonProperty(value="name") String name) {
            super(name);
            this.frequency = Frequency.DEFAULT;
            this.sortKeys = new CopyOnWriteArrayList<String>();
        }

        private EdgeLabelV53(EdgeLabel edgeLabel) {
            super(edgeLabel.name);
            this.frequency = edgeLabel.frequency;
            this.sortKeys = edgeLabel.sortKeys;
            this.sourceLabel = edgeLabel.sourceLabel();
            this.targetLabel = edgeLabel.targetLabel();
            this.id = edgeLabel.id();
            this.properties = edgeLabel.properties();
            this.userdata = edgeLabel.userdata();
            this.checkExist = edgeLabel.checkExist();
            this.nullableKeys = edgeLabel.nullableKeys;
            this.enableLabelIndex = edgeLabel.enableLabelIndex;
        }

        public Frequency frequency() {
            return this.frequency;
        }

        public List<String> sortKeys() {
            return this.sortKeys;
        }

        public String sourceLabel() {
            return this.sourceLabel;
        }

        public String targetLabel() {
            return this.targetLabel;
        }

        @Override
        public String toString() {
            return String.format("{name=%s, sourceLabel=%s, targetLabel=%s, sortKeys=%s, nullableKeys=%s, properties=%s}", this.name, this.sourceLabel, this.targetLabel, this.sortKeys, this.nullableKeys, this.properties);
        }

        @Override
        public String type() {
            return HugeType.EDGE_LABEL.string();
        }
    }

    public static class BuilderImpl
    implements Builder {
        private final EdgeLabel edgeLabel;
        private final SchemaManager manager;

        public BuilderImpl(String name, SchemaManager manager) {
            this.edgeLabel = new EdgeLabel(name);
            this.manager = manager;
        }

        @Override
        public EdgeLabel build() {
            return this.edgeLabel;
        }

        @Override
        public EdgeLabel create() {
            return this.manager.addEdgeLabel(this.edgeLabel);
        }

        @Override
        public EdgeLabel append() {
            return this.manager.appendEdgeLabel(this.edgeLabel);
        }

        @Override
        public EdgeLabel eliminate() {
            return this.manager.eliminateEdgeLabel(this.edgeLabel);
        }

        @Override
        public void remove() {
            this.manager.removeEdgeLabel(this.edgeLabel.name);
        }

        @Override
        public Builder properties(String ... properties) {
            this.edgeLabel.properties.addAll(Arrays.asList(properties));
            return this;
        }

        @Override
        public Builder sortKeys(String ... keys) {
            E.checkArgument((boolean)this.edgeLabel.sortKeys.isEmpty(), (String)"Not allowed to assign sort keys multi times", (Object[])new Object[0]);
            List<String> sortKeys = Arrays.asList(keys);
            E.checkArgument((boolean)CollectionUtil.allUnique(sortKeys), (String)"Invalid sort keys %s, which contains some duplicate properties", (Object[])new Object[]{sortKeys});
            this.edgeLabel.sortKeys.addAll(sortKeys);
            return this;
        }

        @Override
        public Builder nullableKeys(String ... keys) {
            this.edgeLabel.nullableKeys.addAll(Arrays.asList(keys));
            return this;
        }

        @Override
        public Builder link(String sourceLabel, String targetLabel) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(sourceLabel, targetLabel);
            this.edgeLabel.links.add(map);
            return this;
        }

        @Override
        public Builder asBase() {
            this.edgeLabel.edgeLabelType = EdgeLabelType.PARENT;
            return this;
        }

        @Override
        public Builder withBase(String parentLabel) {
            this.edgeLabel.edgeLabelType = EdgeLabelType.SUB;
            this.edgeLabel.parentLabel = parentLabel;
            return this;
        }

        @Override
        public Builder sourceLabel(String label) {
            E.checkArgument((boolean)this.edgeLabel.links.isEmpty(), (String)"Not allowed add source label to an edge label which already has links", (Object[])new Object[0]);
            if (this.edgeLabel.targetLabel != null) {
                this.link(label, this.edgeLabel.targetLabel);
                this.edgeLabel.targetLabel = null;
            } else {
                this.edgeLabel.sourceLabel = label;
            }
            return this;
        }

        @Override
        public Builder targetLabel(String label) {
            E.checkArgument((boolean)this.edgeLabel.links.isEmpty(), (String)"Not allowed add source label to an edge label which already has links", (Object[])new Object[0]);
            if (this.edgeLabel.sourceLabel != null) {
                this.link(this.edgeLabel.sourceLabel, label);
                this.edgeLabel.sourceLabel = null;
            } else {
                this.edgeLabel.targetLabel = label;
            }
            return this;
        }

        @Override
        public Builder frequency(Frequency frequency) {
            this.checkFrequency();
            this.edgeLabel.frequency = frequency;
            return this;
        }

        @Override
        public Builder singleTime() {
            this.checkFrequency();
            this.edgeLabel.frequency = Frequency.SINGLE;
            return this;
        }

        @Override
        public Builder multiTimes() {
            this.checkFrequency();
            this.edgeLabel.frequency = Frequency.MULTIPLE;
            return this;
        }

        @Override
        public Builder ttl(long ttl) {
            E.checkArgument((ttl >= 0L ? 1 : 0) != 0, (String)"The ttl must >= 0, but got: %s", (Object[])new Object[]{ttl});
            this.edgeLabel.ttl = ttl;
            return this;
        }

        @Override
        public Builder ttlStartTime(String ttlStartTime) {
            this.edgeLabel.ttlStartTime = ttlStartTime;
            return this;
        }

        @Override
        public Builder enableLabelIndex(boolean enable) {
            this.edgeLabel.enableLabelIndex = enable;
            return this;
        }

        @Override
        public Builder userdata(String key, Object val) {
            E.checkArgumentNotNull((Object)key, (String)"The user data key can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)val, (String)"The user data value can't be null", (Object[])new Object[0]);
            this.edgeLabel.userdata.put(key, val);
            return this;
        }

        @Override
        public Builder ifNotExist() {
            this.edgeLabel.checkExist = false;
            return this;
        }

        private void checkFrequency() {
            E.checkArgument((this.edgeLabel.frequency == Frequency.DEFAULT ? 1 : 0) != 0, (String)"Not allowed to change frequency for edge label '%s'", (Object[])new Object[]{this.edgeLabel.name});
        }
    }

    public static interface Builder
    extends SchemaBuilder<EdgeLabel> {
        public Builder properties(String ... var1);

        public Builder sortKeys(String ... var1);

        public Builder nullableKeys(String ... var1);

        public Builder link(String var1, String var2);

        public Builder asBase();

        public Builder withBase(String var1);

        public Builder sourceLabel(String var1);

        public Builder targetLabel(String var1);

        public Builder frequency(Frequency var1);

        public Builder singleTime();

        public Builder multiTimes();

        public Builder ttl(long var1);

        public Builder ttlStartTime(String var1);

        public Builder enableLabelIndex(boolean var1);

        public Builder userdata(String var1, Object var2);

        public Builder ifNotExist();
    }
}

