/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.logging.log4j.util.Strings;

public class EdgeExistenceAPI
extends TraversersAPI {
    public EdgeExistenceAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "edgeexist";
    }

    public List<Edge> get(Object sourceId, Object targetId, String edgeLabel, String sortValues, int limit) {
        this.client.checkApiVersion("0.70", "count");
        String source = GraphAPI.formatVertexId(sourceId, false);
        String target = GraphAPI.formatVertexId(targetId, false);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("target", target);
        params.put("label", edgeLabel);
        if (!Strings.isEmpty((CharSequence)sortValues)) {
            params.put("sort_values", sortValues);
        }
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList("edges", Edge.class);
    }
}

