/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.JavaHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.JavaHoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieJavaCopyOnWriteTable;
import org.apache.hudi.table.HoodieJavaMergeOnReadTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;

public abstract class HoodieJavaTable<T>
extends HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    private volatile boolean isMetadataTableExists = false;

    protected HoodieJavaTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    public static <T> HoodieJavaTable<T> create(HoodieWriteConfig config, HoodieEngineContext context) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getStorageConf().newInstance()).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(true).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(config.getTimelineLayoutVersion()))).build();
        return HoodieJavaTable.create(config, context, metaClient);
    }

    public static <T> HoodieJavaTable<T> create(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        switch (metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                return new HoodieJavaCopyOnWriteTable(config, context, metaClient);
            }
            case MERGE_ON_READ: {
                return new HoodieJavaMergeOnReadTable(config, context, metaClient);
            }
        }
        throw new HoodieException("Unsupported table type :" + metaClient.getTableType());
    }

    public static HoodieWriteMetadata<List<WriteStatus>> convertMetadata(HoodieWriteMetadata<HoodieData<WriteStatus>> metadata) {
        return metadata.clone((Object)((HoodieData)metadata.getWriteStatuses()).collectAsList());
    }

    protected HoodieIndex getIndex(HoodieWriteConfig config, HoodieEngineContext context) {
        return JavaHoodieIndexFactory.createIndex(config);
    }

    protected Option<HoodieTableMetadataWriter> getMetadataWriter(String triggeringInstantTimestamp, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy) {
        block4: {
            if (this.config.isMetadataTableEnabled() || this.metaClient.getTableConfig().isMetadataTableAvailable()) {
                HoodieTableMetadataWriter metadataWriter = JavaHoodieBackedTableMetadataWriter.create(this.context.getStorageConf(), this.config, failedWritesCleaningPolicy, this.context, (Option<String>)Option.of((Object)triggeringInstantTimestamp));
                this.deleteMetadataIndexIfNecessary();
                try {
                    if (this.isMetadataTableExists || this.metaClient.getStorage().exists(HoodieTableMetadata.getMetadataTableBasePath((StoragePath)this.metaClient.getBasePathV2()))) {
                        this.isMetadataTableExists = true;
                        return Option.of((Object)metadataWriter);
                    }
                    break block4;
                }
                catch (IOException e) {
                    throw new HoodieMetadataException("Checking existence of metadata table failed", (Exception)e);
                }
            }
            this.maybeDeleteMetadataTable();
        }
        return Option.empty();
    }
}

