/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compress;

import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.compress.HoodieDecompressor;
import org.apache.hudi.io.compress.airlift.HoodieAirliftGzipDecompressor;
import org.apache.hudi.io.compress.builtin.HoodieNoneDecompressor;

public class HoodieDecompressorFactory {
    public static HoodieDecompressor getDecompressor(CompressionCodec compressionCodec) {
        switch (compressionCodec) {
            case NONE: {
                return new HoodieNoneDecompressor();
            }
            case GZIP: {
                return new HoodieAirliftGzipDecompressor();
            }
        }
        throw new IllegalArgumentException("The decompression is not supported for compression codec: " + (Object)((Object)compressionCodec));
    }
}

