/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.PathWithBootstrapFileStatus;
import org.apache.hudi.hadoop.realtime.HoodieVirtualKeyInfo;

public class HoodieRealtimePath
extends Path {
    private final boolean belongsToIncrementalQuery;
    private final List<HoodieLogFile> deltaLogFiles;
    private final String maxCommitTime;
    private final String basePath;
    private final Option<HoodieVirtualKeyInfo> virtualKeyInfo;
    private PathWithBootstrapFileStatus pathWithBootstrapFileStatus;

    public HoodieRealtimePath(Path parent, String child, String basePath, List<HoodieLogFile> deltaLogFiles, String maxCommitTime, boolean belongsToIncrementalQuery, Option<HoodieVirtualKeyInfo> virtualKeyInfo) {
        super(parent, child);
        this.basePath = basePath;
        this.deltaLogFiles = deltaLogFiles;
        this.maxCommitTime = maxCommitTime;
        this.belongsToIncrementalQuery = belongsToIncrementalQuery;
        this.virtualKeyInfo = virtualKeyInfo;
    }

    public List<HoodieLogFile> getDeltaLogFiles() {
        return this.deltaLogFiles;
    }

    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean getBelongsToIncrementalQuery() {
        return this.belongsToIncrementalQuery;
    }

    public boolean isSplitable() {
        return !this.toString().isEmpty();
    }

    public PathWithBootstrapFileStatus getPathWithBootstrapFileStatus() {
        return this.pathWithBootstrapFileStatus;
    }

    public void setPathWithBootstrapFileStatus(PathWithBootstrapFileStatus pathWithBootstrapFileStatus) {
        this.pathWithBootstrapFileStatus = pathWithBootstrapFileStatus;
    }

    public boolean includeBootstrapFilePath() {
        return this.pathWithBootstrapFileStatus != null;
    }

    public Option<HoodieVirtualKeyInfo> getVirtualKeyInfo() {
        return this.virtualKeyInfo;
    }
}

