/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;

public class SchemeAwareFSDataInputStream
extends FSDataInputStream {
    private final boolean isGCSFileSystem;

    public SchemeAwareFSDataInputStream(InputStream in, boolean isGCSFileSystem) {
        super(in);
        this.isGCSFileSystem = isGCSFileSystem;
    }

    public void seek(long desired) throws IOException {
        try {
            super.seek(desired);
        }
        catch (EOFException e) {
            if (this.isGCSFileSystem) {
                super.seek(desired - 1L);
            }
            throw e;
        }
    }
}

