/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.metadata.BaseTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataMergedLogRecordReader;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieBackedTableMetadata
extends BaseTableMetadata {
    private static final Logger LOG = LogManager.getLogger(HoodieBackedTableMetadata.class);
    private static final Schema METADATA_RECORD_SCHEMA = HoodieMetadataRecord.getClassSchema();
    private String metadataBasePath;
    private HoodieTableMetaClient metadataMetaClient;
    private HoodieTableConfig metadataTableConfig;
    private final boolean reuse;
    private Map<Pair<String, String>, Pair<HoodieFileReader, HoodieMetadataMergedLogRecordReader>> partitionReaders = new ConcurrentHashMap<Pair<String, String>, Pair<HoodieFileReader, HoodieMetadataMergedLogRecordReader>>();

    public HoodieBackedTableMetadata(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapDirectory) {
        this(engineContext, metadataConfig, datasetBasePath, spillableMapDirectory, false);
    }

    public HoodieBackedTableMetadata(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapDirectory, boolean reuse) {
        super(engineContext, metadataConfig, datasetBasePath, spillableMapDirectory);
        this.reuse = reuse;
        this.initIfNeeded();
    }

    private void initIfNeeded() {
        this.metadataBasePath = HoodieTableMetadata.getMetadataTableBasePath(this.dataBasePath);
        if (!this.isMetadataTableEnabled) {
            if (!HoodieTableMetadata.isMetadataTable(this.metadataBasePath)) {
                LOG.info((Object)"Metadata table is disabled.");
            }
        } else if (this.metadataMetaClient == null) {
            try {
                this.metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf.get()).setBasePath(this.metadataBasePath).build();
                this.metadataTableConfig = this.metadataMetaClient.getTableConfig();
                this.isBloomFilterIndexEnabled = this.metadataConfig.isBloomFilterIndexEnabled();
                this.isColumnStatsIndexEnabled = this.metadataConfig.isColumnStatsIndexEnabled();
            }
            catch (TableNotFoundException e) {
                LOG.warn((Object)("Metadata table was not found at path " + this.metadataBasePath));
                this.isMetadataTableEnabled = false;
                this.metadataMetaClient = null;
                this.metadataTableConfig = null;
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to initialize metadata table at path " + this.metadataBasePath), (Throwable)e);
                this.isMetadataTableEnabled = false;
                this.metadataMetaClient = null;
                this.metadataTableConfig = null;
            }
        }
    }

    @Override
    protected Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKey(String key, String partitionName) {
        List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> recordsByKeys = this.getRecordsByKeys(Collections.singletonList(key), partitionName);
        return recordsByKeys.size() == 0 ? Option.empty() : recordsByKeys.get(0).getValue();
    }

    @Override
    public HoodieData<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> keyPrefixes, String partitionName) {
        ArrayList<String> sortedkeyPrefixes = new ArrayList<String>(keyPrefixes);
        Collections.sort(sortedkeyPrefixes);
        List<FileSlice> partitionFileSlices = HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices(this.metadataMetaClient, partitionName);
        return this.engineContext.parallelize(partitionFileSlices).flatMap(fileSlice -> {
            Pair<HoodieFileReader, HoodieMetadataMergedLogRecordReader> readers = this.openReaders(partitionName, (FileSlice)fileSlice);
            try {
                ArrayList<Long> timings = new ArrayList<Long>();
                HoodieFileReader baseFileReader = readers.getKey();
                HoodieMetadataMergedLogRecordReader logRecordScanner = readers.getRight();
                if (baseFileReader == null && logRecordScanner == null) {
                    Iterator iterator = Collections.emptyIterator();
                    return iterator;
                }
                boolean fullKeys = false;
                Map<String, Option<HoodieRecord<HoodieMetadataPayload>>> logRecords = this.readLogRecords(logRecordScanner, sortedkeyPrefixes, fullKeys, timings);
                List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> mergedRecords = this.readFromBaseAndMergeWithLogRecords(baseFileReader, sortedkeyPrefixes, fullKeys, logRecords, timings, partitionName);
                LOG.debug((Object)String.format("Metadata read for %s keys took [baseFileRead, logMerge] %s ms", sortedkeyPrefixes.size(), timings));
                Iterator<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> iterator = mergedRecords.iterator();
                return iterator;
            }
            catch (IOException ioe) {
                throw new HoodieIOException("Error merging records from metadata table for  " + sortedkeyPrefixes.size() + " key : ", ioe);
            }
            finally {
                this.closeReader(readers);
            }
        }).map(keyRecordPair -> ((Option)keyRecordPair.getValue()).orElse(null)).filter(Objects::nonNull);
    }

    @Override
    public List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> getRecordsByKeys(List<String> keys, String partitionName) {
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        Map<Pair<String, FileSlice>, List<String>> partitionFileSliceToKeysMap = this.getPartitionFileSliceToKeysMapping(partitionName, sortedKeys);
        ArrayList<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> result = new ArrayList<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>>();
        AtomicInteger fileSlicesKeysCount = new AtomicInteger();
        partitionFileSliceToKeysMap.forEach((partitionFileSlicePair, fileSliceKeys) -> {
            Pair<HoodieFileReader, HoodieMetadataMergedLogRecordReader> readers = this.getOrCreateReaders(partitionName, (FileSlice)partitionFileSlicePair.getRight());
            try {
                ArrayList<Long> timings = new ArrayList<Long>();
                HoodieFileReader baseFileReader = readers.getKey();
                HoodieMetadataMergedLogRecordReader logRecordScanner = readers.getRight();
                if (baseFileReader == null && logRecordScanner == null) {
                    return;
                }
                boolean fullKeys = true;
                Map<String, Option<HoodieRecord<HoodieMetadataPayload>>> logRecords = this.readLogRecords(logRecordScanner, (List<String>)fileSliceKeys, fullKeys, (List<Long>)timings);
                result.addAll(this.readFromBaseAndMergeWithLogRecords(baseFileReader, (List<String>)fileSliceKeys, fullKeys, logRecords, (List<Long>)timings, partitionName));
                LOG.debug((Object)String.format("Metadata read for %s keys took [baseFileRead, logMerge] %s ms", fileSliceKeys.size(), timings));
                fileSlicesKeysCount.addAndGet(fileSliceKeys.size());
            }
            catch (IOException ioe) {
                throw new HoodieIOException("Error merging records from metadata table for  " + sortedKeys.size() + " key : ", ioe);
            }
            finally {
                if (!this.reuse) {
                    this.close(Pair.of(partitionFileSlicePair.getLeft(), ((FileSlice)partitionFileSlicePair.getRight()).getFileId()));
                }
            }
        });
        return result;
    }

    private Map<String, Option<HoodieRecord<HoodieMetadataPayload>>> readLogRecords(HoodieMetadataMergedLogRecordReader logRecordScanner, List<String> keys, boolean fullKey, List<Long> timings) {
        HoodieTimer timer = new HoodieTimer().startTimer();
        timer.startTimer();
        if (logRecordScanner == null) {
            timings.add(timer.endTimer());
            return Collections.emptyMap();
        }
        String partitionName = logRecordScanner.getPartitionName().get();
        HashMap<String, Option<HoodieRecord<HoodieMetadataPayload>>> logRecords = new HashMap<String, Option<HoodieRecord<HoodieMetadataPayload>>>();
        if (this.isFullScanAllowedForPartition(partitionName)) {
            ValidationUtils.checkArgument(fullKey, "If full-scan is required, only full keys could be used!");
            for (String key : keys) {
                logRecords.put(key, logRecordScanner.getRecordByKey(key).get(0).getValue());
            }
        } else {
            List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> logRecordsList = fullKey ? logRecordScanner.getRecordsByKeys(keys) : logRecordScanner.getRecordsByKeyPrefixes(keys).stream().map(record -> Pair.of(record.getRecordKey(), Option.of(record))).collect(Collectors.toList());
            for (Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>> entry : logRecordsList) {
                logRecords.put(entry.getKey(), entry.getValue());
            }
        }
        timings.add(timer.endTimer());
        return logRecords;
    }

    private List<Pair<String, Option<HoodieRecord<HoodieMetadataPayload>>>> readFromBaseAndMergeWithLogRecords(HoodieFileReader baseFileReader, List<String> keys, boolean fullKeys, Map<String, Option<HoodieRecord<HoodieMetadataPayload>>> logRecords, List<Long> timings, String partitionName) throws IOException {
        HoodieTimer timer = new HoodieTimer().startTimer();
        timer.startTimer();
        if (baseFileReader == null) {
            timings.add(timer.endTimer());
            if (fullKeys) {
                return keys.stream().map(key -> Pair.of(key, logRecords.getOrDefault(key, Option.empty()))).collect(Collectors.toList());
            }
            return logRecords.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        }
        ArrayList result = new ArrayList();
        HoodieTimer readTimer = new HoodieTimer();
        readTimer.startTimer();
        Map<String, HoodieRecord<HoodieMetadataPayload>> records = this.fetchBaseFileRecordsByKeys(baseFileReader, keys, fullKeys, partitionName);
        this.metrics.ifPresent(m -> m.updateMetrics("basefile_read", readTimer.endTimer()));
        for (Option<HoodieRecord<HoodieMetadataPayload>> logRecordOpt : logRecords.values()) {
            if (!logRecordOpt.isPresent()) continue;
            HoodieRecord<HoodieMetadataPayload> logRecord = logRecordOpt.get();
            records.merge(logRecord.getRecordKey(), logRecord, (oldRecord, newRecord) -> new HoodieAvroRecord<HoodieMetadataPayload>(oldRecord.getKey(), ((HoodieMetadataPayload)newRecord.getData()).preCombine((HoodieMetadataPayload)oldRecord.getData())));
        }
        timings.add(timer.endTimer());
        if (fullKeys) {
            return keys.stream().map(key -> Pair.of(key, Option.ofNullable(records.get(key)))).collect(Collectors.toList());
        }
        return records.values().stream().map(record -> Pair.of(record.getRecordKey(), Option.of(record))).collect(Collectors.toList());
    }

    private Map<String, HoodieRecord<HoodieMetadataPayload>> fetchBaseFileRecordsByKeys(HoodieFileReader<GenericRecord> baseFileReader, List<String> keys, boolean fullKeys, String partitionName) throws IOException {
        ClosableIterator<GenericRecord> records = fullKeys ? baseFileReader.getRecordsByKeysIterator(keys) : baseFileReader.getRecordsByKeyPrefixIterator(keys);
        return CollectionUtils.toStream(records).map(record -> Pair.of((String)record.get("key"), this.composeRecord((GenericRecord)record, partitionName))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private HoodieRecord<HoodieMetadataPayload> composeRecord(GenericRecord avroRecord, String partitionName) {
        if (this.metadataTableConfig.populateMetaFields()) {
            return (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload(avroRecord, this.metadataTableConfig.getPayloadClass(), this.metadataTableConfig.getPreCombineField(), false);
        }
        return (HoodieRecord)SpillableMapUtils.convertToHoodieRecordPayload(avroRecord, this.metadataTableConfig.getPayloadClass(), this.metadataTableConfig.getPreCombineField(), Pair.of(this.metadataTableConfig.getRecordKeyFieldProp(), this.metadataTableConfig.getPartitionFieldProp()), false, Option.of(partitionName));
    }

    private Map<Pair<String, FileSlice>, List<String>> getPartitionFileSliceToKeysMapping(String partitionName, List<String> keys) {
        List<FileSlice> latestFileSlices = HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices(this.metadataMetaClient, partitionName);
        HashMap<Pair<String, FileSlice>, List<String>> partitionFileSliceToKeysMap = new HashMap<Pair<String, FileSlice>, List<String>>();
        for (String key : keys) {
            if (CollectionUtils.isNullOrEmpty(latestFileSlices)) continue;
            FileSlice slice = latestFileSlices.get(HoodieTableMetadataUtil.mapRecordKeyToFileGroupIndex(key, latestFileSlices.size()));
            Pair<String, FileSlice> partitionNameFileSlicePair = Pair.of(partitionName, slice);
            partitionFileSliceToKeysMap.computeIfAbsent(partitionNameFileSlicePair, k -> new ArrayList()).add(key);
        }
        return partitionFileSliceToKeysMap;
    }

    private Pair<HoodieFileReader, HoodieMetadataMergedLogRecordReader> getOrCreateReaders(String partitionName, FileSlice slice) {
        return this.partitionReaders.computeIfAbsent(Pair.of(partitionName, slice.getFileId()), k -> this.openReaders(partitionName, slice));
    }

    private Pair<HoodieFileReader, HoodieMetadataMergedLogRecordReader> openReaders(String partitionName, FileSlice slice) {
        try {
            HoodieTimer timer = new HoodieTimer().startTimer();
            Pair<HoodieFileReader, Long> baseFileReaderOpenTimePair = this.getBaseFileReader(slice, timer);
            HoodieFileReader baseFileReader = baseFileReaderOpenTimePair.getKey();
            long baseFileOpenMs = baseFileReaderOpenTimePair.getValue();
            List<HoodieLogFile> logFiles = slice.getLogFiles().collect(Collectors.toList());
            Pair<HoodieMetadataMergedLogRecordReader, Long> logRecordScannerOpenTimePair = this.getLogRecordScanner(logFiles, partitionName);
            HoodieMetadataMergedLogRecordReader logRecordScanner = logRecordScannerOpenTimePair.getKey();
            long logScannerOpenMs = logRecordScannerOpenTimePair.getValue();
            this.metrics.ifPresent(metrics -> metrics.updateMetrics("scan", baseFileOpenMs + logScannerOpenMs));
            return Pair.of(baseFileReader, logRecordScanner);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error opening readers for metadata table partition " + partitionName, e);
        }
    }

    private Pair<HoodieFileReader, Long> getBaseFileReader(FileSlice slice, HoodieTimer timer) throws IOException {
        Long baseFileOpenMs;
        HoodieFileReader baseFileReader = null;
        Option<HoodieBaseFile> basefile = slice.getBaseFile();
        if (basefile.isPresent()) {
            String basefilePath = basefile.get().getPath();
            baseFileReader = HoodieFileReaderFactory.getFileReader(this.hadoopConf.get(), new Path(basefilePath));
            baseFileOpenMs = timer.endTimer();
            LOG.info((Object)String.format("Opened metadata base file from %s at instant %s in %d ms", basefilePath, basefile.get().getCommitTime(), baseFileOpenMs));
        } else {
            baseFileOpenMs = 0L;
            timer.endTimer();
        }
        return Pair.of(baseFileReader, baseFileOpenMs);
    }

    private Set<String> getValidInstantTimestamps() {
        HoodieActiveTimeline datasetTimeline = this.dataMetaClient.getActiveTimeline();
        Set<String> validInstantTimestamps = datasetTimeline.filterCompletedInstants().getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toSet());
        String earliestInstantTime = validInstantTimestamps.isEmpty() ? "00000000000000" : (String)Collections.min(validInstantTimestamps);
        datasetTimeline.getRollbackAndRestoreTimeline().filterCompletedInstants().getInstants().filter(instant -> HoodieTimeline.compareTimestamps(instant.getTimestamp(), HoodieTimeline.GREATER_THAN, earliestInstantTime)).forEach(instant -> validInstantTimestamps.addAll(this.getRollbackedCommits((HoodieInstant)instant, datasetTimeline)));
        validInstantTimestamps.add("00000000000000");
        return validInstantTimestamps;
    }

    public Pair<HoodieMetadataMergedLogRecordReader, Long> getLogRecordScanner(List<HoodieLogFile> logFiles, String partitionName) {
        return this.getLogRecordScanner(logFiles, partitionName, Option.empty());
    }

    public Pair<HoodieMetadataMergedLogRecordReader, Long> getLogRecordScanner(List<HoodieLogFile> logFiles, String partitionName, Option<Boolean> allowFullScanOverride) {
        HoodieTimer timer = new HoodieTimer().startTimer();
        List sortedLogFilePaths = logFiles.stream().sorted(HoodieLogFile.getLogFileComparator()).map(o -> o.getPath().toString()).collect(Collectors.toList());
        Set<String> validInstantTimestamps = this.getValidInstantTimestamps();
        Option<HoodieInstant> latestMetadataInstant = this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant();
        String latestMetadataInstantTime = latestMetadataInstant.map(HoodieInstant::getTimestamp).orElse("00000000000000");
        boolean allowFullScan = allowFullScanOverride.orElseGet(() -> this.isFullScanAllowedForPartition(partitionName));
        Schema schema = HoodieAvroUtils.addMetadataFields(HoodieMetadataRecord.getClassSchema());
        HoodieCommonConfig commonConfig = HoodieCommonConfig.newBuilder().fromProperties(this.metadataConfig.getProps()).build();
        HoodieMetadataMergedLogRecordReader logRecordScanner = ((HoodieMetadataMergedLogRecordReader.Builder)HoodieMetadataMergedLogRecordReader.newBuilder().withFileSystem(this.metadataMetaClient.getFs()).withBasePath(this.metadataBasePath).withLogFilePaths(sortedLogFilePaths)).withReaderSchema(schema).withLatestInstantTime(latestMetadataInstantTime).withMaxMemorySizeInBytes(0x40000000L).withBufferSize(0xA00000).withSpillableMapBasePath(this.spillableMapDirectory).withDiskMapType(commonConfig.getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(commonConfig.isBitCaskDiskMapCompressionEnabled()).withLogBlockTimestamps(validInstantTimestamps).allowFullScan(allowFullScan).withPartition(partitionName).build();
        Long logScannerOpenMs = timer.endTimer();
        LOG.info((Object)String.format("Opened %d metadata log files (dataset instant=%s, metadata instant=%s) in %d ms", sortedLogFilePaths.size(), this.getLatestDataInstantTime(), latestMetadataInstantTime, logScannerOpenMs));
        return Pair.of(logRecordScanner, logScannerOpenMs);
    }

    private boolean isFullScanAllowedForPartition(String partitionName) {
        switch (partitionName) {
            case "files": {
                return this.metadataConfig.allowFullScan();
            }
        }
        return false;
    }

    private List<String> getRollbackedCommits(HoodieInstant instant, HoodieActiveTimeline timeline) {
        try {
            if (instant.getAction().equals("rollback")) {
                HoodieRollbackMetadata rollbackMetadata = TimelineMetadataUtils.deserializeHoodieRollbackMetadata(timeline.getInstantDetails(instant).get());
                return rollbackMetadata.getCommitsRollback();
            }
            LinkedList<String> rollbackedCommits = new LinkedList<String>();
            if (instant.getAction().equals("restore")) {
                HoodieRestoreMetadata restoreMetadata = TimelineMetadataUtils.deserializeHoodieRestoreMetadata(timeline.getInstantDetails(instant).get());
                restoreMetadata.getHoodieRestoreMetadata().values().forEach(rms -> rms.forEach(rm -> rollbackedCommits.addAll(rm.getCommitsRollback())));
            }
            return rollbackedCommits;
        }
        catch (IOException e) {
            throw new HoodieMetadataException("Error retrieving rollback commits for instant " + instant, e);
        }
    }

    @Override
    public void close() {
        this.closePartitionReaders();
    }

    private synchronized void close(Pair<String, String> partitionFileSlicePair) {
        Pair<HoodieFileReader, HoodieMetadataMergedLogRecordReader> readers = this.partitionReaders.remove(partitionFileSlicePair);
        this.closeReader(readers);
    }

    private void closePartitionReaders() {
        for (Pair<String, String> partitionFileSlicePair : this.partitionReaders.keySet()) {
            this.close(partitionFileSlicePair);
        }
        this.partitionReaders.clear();
    }

    private void closeReader(Pair<HoodieFileReader, HoodieMetadataMergedLogRecordReader> readers) {
        if (readers != null) {
            try {
                if (readers.getKey() != null) {
                    readers.getKey().close();
                }
                if (readers.getValue() != null) {
                    readers.getValue().close();
                }
            }
            catch (Exception e) {
                throw new HoodieException("Error closing resources during metadata table merge", e);
            }
        }
    }

    public boolean enabled() {
        return this.isMetadataTableEnabled;
    }

    public SerializableConfiguration getHadoopConf() {
        return this.hadoopConf;
    }

    public HoodieTableMetaClient getMetadataMetaClient() {
        return this.metadataMetaClient;
    }

    public Map<String, String> stats() {
        return this.metrics.map(m -> m.getStats(true, this.metadataMetaClient, (HoodieTableMetadata)this)).orElse(new HashMap());
    }

    @Override
    public Option<String> getSyncedInstantTime() {
        Option<HoodieInstant> latestInstant;
        if (this.metadataMetaClient != null && (latestInstant = this.metadataMetaClient.getActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().lastInstant()).isPresent()) {
            return Option.of(latestInstant.get().getTimestamp());
        }
        return Option.empty();
    }

    @Override
    public Option<String> getLatestCompactionTime() {
        Option<HoodieInstant> latestCompaction;
        if (this.metadataMetaClient != null && (latestCompaction = this.metadataMetaClient.getActiveTimeline().getCommitTimeline().filterCompletedInstants().lastInstant()).isPresent()) {
            return Option.of(latestCompaction.get().getTimestamp());
        }
        return Option.empty();
    }

    @Override
    public void reset() {
        this.initIfNeeded();
        this.dataMetaClient.reloadActiveTimeline();
        if (this.metadataMetaClient != null) {
            this.metadataMetaClient.reloadActiveTimeline();
        }
        this.closePartitionReaders();
    }
}

