/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.Serializable;
import org.apache.hudi.common.util.collection.ImmutableTriple;
import org.apache.hudi.common.util.collection.Pair;

public abstract class Triple<L, M, R>
implements Comparable<Triple<L, M, R>>,
Serializable {
    private static final long serialVersionUID = 1L;

    public static <L, M, R> Triple<L, M, R> of(L left, M middle, R right) {
        return new ImmutableTriple<L, M, R>(left, middle, right);
    }

    public abstract L getLeft();

    public abstract M getMiddle();

    public abstract R getRight();

    @Override
    public int compareTo(Triple<L, M, R> other) {
        this.checkComparable(this);
        this.checkComparable(other);
        Comparable thisLeft = (Comparable)this.getLeft();
        Comparable otherLeft = (Comparable)other.getLeft();
        if (thisLeft.compareTo(otherLeft) == 0) {
            return Pair.of(this.getMiddle(), this.getRight()).compareTo(Pair.of(other.getMiddle(), other.getRight()));
        }
        return thisLeft.compareTo(otherLeft);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Triple) {
            Triple other = (Triple)obj;
            return this.getLeft().equals(other.getLeft()) && this.getMiddle().equals(other.getMiddle()) && this.getRight().equals(other.getRight());
        }
        return false;
    }

    public int hashCode() {
        return (this.getLeft() == null ? 0 : this.getLeft().hashCode()) ^ (this.getMiddle() == null ? 0 : this.getMiddle().hashCode()) ^ (this.getRight() == null ? 0 : this.getRight().hashCode());
    }

    public String toString() {
        return "" + '(' + this.getLeft() + ',' + this.getMiddle() + ',' + this.getRight() + ')';
    }

    public String toString(String format) {
        return String.format(format, this.getLeft(), this.getMiddle(), this.getRight());
    }

    private void checkComparable(Triple<L, M, R> triplet) {
        if (!(triplet.getLeft() instanceof Comparable && triplet.getMiddle() instanceof Comparable && triplet.getRight() instanceof Comparable)) {
            throw new IllegalArgumentException("Elements of Triple must implement Comparable :" + triplet);
        }
    }
}

