/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrcReaderIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public class OrcUtils
extends BaseFileUtils {
    @Override
    public ClosableIterator<HoodieKey> getHoodieKeyIterator(Configuration configuration, Path filePath) {
        try {
            Configuration conf = new Configuration(configuration);
            conf.addResource(FSUtils.getFs(filePath.toString(), conf).getConf());
            Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            Schema readSchema = HoodieAvroUtils.getRecordKeyPartitionPathSchema();
            TypeDescription orcSchema = AvroOrcUtils.createOrcSchema(readSchema);
            RecordReader recordReader = reader.rows(new Reader.Options(conf).schema(orcSchema));
            List fieldNames = orcSchema.getFieldNames();
            int keyCol = -1;
            int partitionCol = -1;
            for (int i = 0; i < fieldNames.size(); ++i) {
                if (((String)fieldNames.get(i)).equals("_hoodie_record_key")) {
                    keyCol = i;
                }
                if (!((String)fieldNames.get(i)).equals("_hoodie_partition_path")) continue;
                partitionCol = i;
            }
            if (keyCol == -1 || partitionCol == -1) {
                throw new HoodieException(String.format("Couldn't find row keys or partition path in %s.", filePath));
            }
            return new OrcReaderIterator<HoodieKey>(recordReader, readSchema, orcSchema);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to open reader from ORC file:" + filePath, e);
        }
    }

    @Override
    public List<HoodieKey> fetchHoodieKeys(Configuration configuration, Path filePath) {
        try {
            if (!filePath.getFileSystem(configuration).exists(filePath)) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read from ORC file:" + filePath, e);
        }
        ArrayList<HoodieKey> hoodieKeys = new ArrayList<HoodieKey>();
        try (ClosableIterator<HoodieKey> iterator = this.getHoodieKeyIterator(configuration, filePath, Option.empty());){
            iterator.forEachRemaining(hoodieKeys::add);
        }
        return hoodieKeys;
    }

    @Override
    public List<HoodieKey> fetchHoodieKeys(Configuration configuration, Path filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        throw new UnsupportedOperationException("Custom key generator is not supported yet");
    }

    @Override
    public ClosableIterator<HoodieKey> getHoodieKeyIterator(Configuration configuration, Path filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        throw new UnsupportedOperationException("Custom key generator is not supported yet");
    }

    @Override
    public List<GenericRecord> readAvroRecords(Configuration configuration, Path filePath) {
        Schema avroSchema;
        try (Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)configuration));){
            avroSchema = AvroOrcUtils.createAvroSchema(reader.getSchema());
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read Avro records from an ORC file:" + filePath, io);
        }
        return this.readAvroRecords(configuration, filePath, avroSchema);
    }

    @Override
    public List<GenericRecord> readAvroRecords(Configuration configuration, Path filePath, Schema avroSchema) {
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        try (Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)configuration));){
            TypeDescription orcSchema = reader.getSchema();
            try (RecordReader recordReader = reader.rows(new Reader.Options(configuration).schema(orcSchema));){
                OrcReaderIterator iterator = new OrcReaderIterator(recordReader, avroSchema, orcSchema);
                while (iterator.hasNext()) {
                    GenericRecord record = (GenericRecord)iterator.next();
                    records.add(record);
                }
            }
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to create an ORC reader for ORC file:" + filePath, io);
        }
        return records;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Set<String> filterRowKeys(Configuration conf, Path filePath, Set<String> filter) throws HoodieIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> readFooter(Configuration conf, boolean required, Path orcFilePath, String ... footerNames) {
        try (Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));){
            HashMap<String, String> footerVals = new HashMap<String, String>();
            List metadataItemList = reader.getFileTail().getFooter().getMetadataList();
            Map<String, String> metadata = metadataItemList.stream().collect(Collectors.toMap(OrcProto.UserMetadataItem::getName, metadataItem -> metadataItem.getValue().toStringUtf8()));
            for (String footerName : footerNames) {
                if (metadata.containsKey(footerName)) {
                    footerVals.put(footerName, metadata.get(footerName));
                    continue;
                }
                if (!required) continue;
                throw new MetadataNotFoundException("Could not find index in ORC footer. Looked for key " + footerName + " in " + orcFilePath);
            }
            HashMap<String, String> hashMap = footerVals;
            return hashMap;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read footer for ORC file:" + orcFilePath, io);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Schema readAvroSchema(Configuration conf, Path orcFilePath) {
        try (Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));){
            if (reader.hasMetadataValue("orc.avro.schema")) {
                ByteBuffer metadataValue = reader.getMetadataValue("orc.avro.schema");
                byte[] bytes = new byte[metadataValue.remaining()];
                metadataValue.get(bytes);
                Schema schema = new Schema.Parser().parse(new String(bytes));
                return schema;
            }
            TypeDescription orcSchema = reader.getSchema();
            Schema schema = AvroOrcUtils.createAvroSchema(orcSchema);
            return schema;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to get Avro schema for ORC file:" + orcFilePath, io);
        }
    }

    @Override
    public HoodieFileFormat getFormat() {
        return HoodieFileFormat.ORC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getRowCount(Configuration conf, Path orcFilePath) {
        try (Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));){
            long l = reader.getNumberOfRows();
            return l;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to get row count for ORC file:" + orcFilePath, io);
        }
    }
}

