/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.compaction.CompactionPlanMigrator;
import org.apache.hudi.common.table.timeline.versioning.compaction.CompactionV1MigrationHandler;
import org.apache.hudi.common.table.timeline.versioning.compaction.CompactionV2MigrationHandler;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CompactionUtils {
    private static final Logger LOG = LogManager.getLogger(CompactionUtils.class);
    public static final Integer COMPACTION_METADATA_VERSION_1 = CompactionV1MigrationHandler.VERSION;
    public static final Integer COMPACTION_METADATA_VERSION_2;
    public static final Integer LATEST_COMPACTION_METADATA_VERSION;

    public static HoodieCompactionOperation buildFromFileSlice(String partitionPath, FileSlice fileSlice, Option<Function<Pair<String, FileSlice>, Map<String, Double>>> metricsCaptureFunction) {
        HoodieCompactionOperation.Builder builder = HoodieCompactionOperation.newBuilder();
        builder.setPartitionPath(partitionPath);
        builder.setFileId(fileSlice.getFileId());
        builder.setBaseInstantTime(fileSlice.getBaseInstantTime());
        builder.setDeltaFilePaths(fileSlice.getLogFiles().map(lf -> lf.getPath().getName()).collect(Collectors.toList()));
        if (fileSlice.getBaseFile().isPresent()) {
            builder.setDataFilePath(fileSlice.getBaseFile().get().getFileName());
            builder.setBootstrapFilePath(fileSlice.getBaseFile().get().getBootstrapBaseFile().map(BaseFile::getPath).orElse(null));
        }
        if (metricsCaptureFunction.isPresent()) {
            builder.setMetrics(metricsCaptureFunction.get().apply(Pair.of(partitionPath, fileSlice)));
        }
        return builder.build();
    }

    public static HoodieCompactionPlan buildFromFileSlices(List<Pair<String, FileSlice>> partitionFileSlicePairs, Option<Map<String, String>> extraMetadata, Option<Function<Pair<String, FileSlice>, Map<String, Double>>> metricsCaptureFunction) {
        HoodieCompactionPlan.Builder builder = HoodieCompactionPlan.newBuilder();
        extraMetadata.ifPresent(builder::setExtraMetadata);
        builder.setOperations(partitionFileSlicePairs.stream().map(pfPair -> CompactionUtils.buildFromFileSlice((String)pfPair.getKey(), (FileSlice)pfPair.getValue(), metricsCaptureFunction)).collect(Collectors.toList()));
        builder.setVersion(LATEST_COMPACTION_METADATA_VERSION);
        return builder.build();
    }

    public static HoodieCompactionOperation buildHoodieCompactionOperation(CompactionOperation op) {
        return HoodieCompactionOperation.newBuilder().setFileId(op.getFileId()).setBaseInstantTime(op.getBaseInstantTime()).setPartitionPath(op.getPartitionPath()).setBootstrapFilePath(op.getBootstrapFilePath().orElse(null)).setDataFilePath(op.getDataFileName().isPresent() ? op.getDataFileName().get() : null).setDeltaFilePaths(op.getDeltaFileNames()).setMetrics(op.getMetrics()).build();
    }

    public static CompactionOperation buildCompactionOperation(HoodieCompactionOperation hc) {
        return CompactionOperation.convertFromAvroRecordInstance(hc);
    }

    public static List<Pair<HoodieInstant, HoodieCompactionPlan>> getAllPendingCompactionPlans(HoodieTableMetaClient metaClient) {
        List pendingCompactionInstants = metaClient.getActiveTimeline().filterPendingCompactionTimeline().getInstants().collect(Collectors.toList());
        return pendingCompactionInstants.stream().map(instant -> {
            try {
                return Pair.of(instant, CompactionUtils.getCompactionPlan(metaClient, instant.getTimestamp()));
            }
            catch (IOException e) {
                throw new HoodieException(e);
            }
        }).collect(Collectors.toList());
    }

    public static HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient metaClient, String compactionInstant) throws IOException {
        CompactionPlanMigrator migrator = new CompactionPlanMigrator(metaClient);
        HoodieCompactionPlan compactionPlan = TimelineMetadataUtils.deserializeCompactionPlan(metaClient.getActiveTimeline().readCompactionPlanAsBytes(HoodieTimeline.getCompactionRequestedInstant(compactionInstant)).get());
        return migrator.upgradeToLatest(compactionPlan, compactionPlan.getVersion());
    }

    public static Map<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> getAllPendingCompactionOperations(HoodieTableMetaClient metaClient) {
        List<Pair<HoodieInstant, HoodieCompactionPlan>> pendingCompactionPlanWithInstants = CompactionUtils.getAllPendingCompactionPlans(metaClient);
        HashMap<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> fgIdToPendingCompactionWithInstantMap = new HashMap<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>>();
        pendingCompactionPlanWithInstants.stream().flatMap(instantPlanPair -> CompactionUtils.getPendingCompactionOperations((HoodieInstant)instantPlanPair.getKey(), (HoodieCompactionPlan)((Object)((Object)instantPlanPair.getValue())))).forEach(pair -> {
            HoodieCompactionOperation anotherOperation;
            HoodieCompactionOperation operation;
            if (fgIdToPendingCompactionWithInstantMap.containsKey(pair.getKey()) && !(operation = (HoodieCompactionOperation)((Object)((Object)((Pair)pair.getValue()).getValue()))).equals((Object)(anotherOperation = (HoodieCompactionOperation)((Object)((Object)((Pair)fgIdToPendingCompactionWithInstantMap.get(pair.getKey())).getValue()))))) {
                String msg = "Hudi File Id (" + pair.getKey() + ") has more than 1 pending compactions. Instants: " + pair.getValue() + ", " + fgIdToPendingCompactionWithInstantMap.get(pair.getKey());
                throw new IllegalStateException(msg);
            }
            fgIdToPendingCompactionWithInstantMap.put((HoodieFileGroupId)pair.getKey(), (Pair<String, HoodieCompactionOperation>)pair.getValue());
        });
        return fgIdToPendingCompactionWithInstantMap;
    }

    public static Stream<Pair<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>>> getPendingCompactionOperations(HoodieInstant instant, HoodieCompactionPlan compactionPlan) {
        List<HoodieCompactionOperation> ops = compactionPlan.getOperations();
        if (null != ops) {
            return ops.stream().map(op -> Pair.of(new HoodieFileGroupId(op.getPartitionPath(), op.getFileId()), Pair.of(instant.getTimestamp(), op)));
        }
        return Stream.empty();
    }

    public static List<HoodieInstant> getPendingCompactionInstantTimes(HoodieTableMetaClient metaClient) {
        return metaClient.getActiveTimeline().filterPendingCompactionTimeline().getInstants().collect(Collectors.toList());
    }

    public static Option<Pair<HoodieTimeline, HoodieInstant>> getDeltaCommitsSinceLatestCompaction(HoodieActiveTimeline activeTimeline) {
        Option<HoodieInstant> lastCompaction = activeTimeline.getCommitTimeline().filterCompletedInstants().lastInstant();
        HoodieTimeline deltaCommits = activeTimeline.getDeltaCommitTimeline();
        if (lastCompaction.isPresent()) {
            HoodieInstant latestInstant = lastCompaction.get();
            return Option.of(Pair.of(deltaCommits.findInstantsAfter(latestInstant.getTimestamp(), Integer.MAX_VALUE), lastCompaction.get()));
        }
        if (deltaCommits.countInstants() > 0) {
            HoodieInstant latestInstant = deltaCommits.firstInstant().get();
            return Option.of(Pair.of(deltaCommits.findInstantsAfterOrEquals(latestInstant.getTimestamp(), Integer.MAX_VALUE), latestInstant));
        }
        return Option.empty();
    }

    public static Option<HoodieInstant> getOldestInstantToRetainForCompaction(HoodieActiveTimeline activeTimeline, int maxDeltaCommits) {
        Option<Pair<HoodieTimeline, HoodieInstant>> deltaCommitsInfoOption = CompactionUtils.getDeltaCommitsSinceLatestCompaction(activeTimeline);
        if (deltaCommitsInfoOption.isPresent()) {
            Pair<HoodieTimeline, HoodieInstant> deltaCommitsInfo = deltaCommitsInfoOption.get();
            HoodieTimeline deltaCommitTimeline = deltaCommitsInfo.getLeft();
            int numDeltaCommits = deltaCommitTimeline.countInstants();
            if (numDeltaCommits < maxDeltaCommits) {
                return Option.of(deltaCommitsInfo.getRight());
            }
            List instants = deltaCommitTimeline.getInstants().limit(numDeltaCommits - maxDeltaCommits + 1).collect(Collectors.toList());
            return Option.of(instants.get(instants.size() - 1));
        }
        return Option.empty();
    }

    static {
        LATEST_COMPACTION_METADATA_VERSION = COMPACTION_METADATA_VERSION_2 = CompactionV2MigrationHandler.VERSION;
    }
}

