/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.model.CleanFileInfo;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanMetadataMigrator;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanMetadataV1MigrationHandler;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanMetadataV2MigrationHandler;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanMigrator;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CleanerUtils {
    private static final Logger LOG = LogManager.getLogger(CleanerUtils.class);
    public static final Integer CLEAN_METADATA_VERSION_1 = CleanMetadataV1MigrationHandler.VERSION;
    public static final Integer CLEAN_METADATA_VERSION_2;
    public static final Integer LATEST_CLEAN_METADATA_VERSION;

    public static HoodieCleanMetadata convertCleanMetadata(String startCleanTime, Option<Long> durationInMs, List<HoodieCleanStat> cleanStats) {
        HashMap<String, HoodieCleanPartitionMetadata> partitionMetadataMap = new HashMap<String, HoodieCleanPartitionMetadata>();
        HashMap<String, HoodieCleanPartitionMetadata> partitionBootstrapMetadataMap = new HashMap<String, HoodieCleanPartitionMetadata>();
        int totalDeleted = 0;
        String earliestCommitToRetain = null;
        for (HoodieCleanStat stat : cleanStats) {
            HoodieCleanPartitionMetadata metadata = new HoodieCleanPartitionMetadata(stat.getPartitionPath(), stat.getPolicy().name(), stat.getDeletePathPatterns(), stat.getSuccessDeleteFiles(), stat.getFailedDeleteFiles(), stat.isPartitionDeleted());
            partitionMetadataMap.put(stat.getPartitionPath(), metadata);
            if (null != stat.getDeleteBootstrapBasePathPatterns() && !stat.getDeleteBootstrapBasePathPatterns().isEmpty()) {
                HoodieCleanPartitionMetadata bootstrapMetadata = new HoodieCleanPartitionMetadata(stat.getPartitionPath(), stat.getPolicy().name(), stat.getDeleteBootstrapBasePathPatterns(), stat.getSuccessDeleteBootstrapBaseFiles(), stat.getFailedDeleteBootstrapBaseFiles(), stat.isPartitionDeleted());
                partitionBootstrapMetadataMap.put(stat.getPartitionPath(), bootstrapMetadata);
            }
            totalDeleted += stat.getSuccessDeleteFiles().size();
            if (earliestCommitToRetain != null) continue;
            earliestCommitToRetain = stat.getEarliestCommitToRetain();
        }
        return new HoodieCleanMetadata(startCleanTime, durationInMs.orElseGet(() -> -1L), totalDeleted, earliestCommitToRetain, partitionMetadataMap, CLEAN_METADATA_VERSION_2, partitionBootstrapMetadataMap);
    }

    public static HoodieCleanMetadata getCleanerMetadata(HoodieTableMetaClient metaClient, HoodieInstant cleanInstant) throws IOException {
        CleanMetadataMigrator metadataMigrator = new CleanMetadataMigrator(metaClient);
        HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata(metaClient.getActiveTimeline().readCleanerInfoAsBytes(cleanInstant).get());
        return metadataMigrator.upgradeToLatest(cleanMetadata, cleanMetadata.getVersion());
    }

    public static HoodieCleanerPlan getCleanerPlan(HoodieTableMetaClient metaClient, HoodieInstant cleanInstant) throws IOException {
        CleanPlanMigrator cleanPlanMigrator = new CleanPlanMigrator(metaClient);
        HoodieCleanerPlan cleanerPlan = TimelineMetadataUtils.deserializeAvroMetadata(metaClient.getActiveTimeline().readCleanerInfoAsBytes(cleanInstant).get(), HoodieCleanerPlan.class);
        return cleanPlanMigrator.upgradeToLatest(cleanerPlan, cleanerPlan.getVersion());
    }

    public static List<HoodieCleanFileInfo> convertToHoodieCleanFileInfoList(List<CleanFileInfo> cleanFileInfoList) {
        return cleanFileInfoList.stream().map(CleanFileInfo::toHoodieFileCleanInfo).collect(Collectors.toList());
    }

    public static void rollbackFailedWrites(HoodieFailedWritesCleaningPolicy cleaningPolicy, String actionType, Functions.Function0<Boolean> rollbackFailedWritesFunc) {
        switch (actionType) {
            case "clean": {
                if (cleaningPolicy.isEager()) {
                    return;
                }
                if (!cleaningPolicy.isLazy()) break;
                LOG.info((Object)"Cleaned failed attempts if any");
                rollbackFailedWritesFunc.apply();
                return;
            }
            case "commit": {
                if (!cleaningPolicy.isEager()) break;
                LOG.info((Object)"Cleaned failed attempts if any");
                rollbackFailedWritesFunc.apply();
                return;
            }
            default: {
                throw new IllegalArgumentException("Unsupported action type " + actionType);
            }
        }
    }

    static {
        LATEST_CLEAN_METADATA_VERSION = CLEAN_METADATA_VERSION_2 = CleanMetadataV2MigrationHandler.VERSION;
    }
}

