/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs.inline;

import java.io.File;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.ValidationUtils;

public class InLineFSUtils {
    private static final String START_OFFSET_STR = "start_offset";
    private static final String LENGTH_STR = "length";
    private static final String PATH_SEPARATOR = "/";
    private static final String SCHEME_SEPARATOR = ":";
    private static final String EQUALS_STR = "=";
    private static final String LOCAL_FILESYSTEM_SCHEME = "file";

    public static Path getInlineFilePath(Path outerPath, String origScheme, long inLineStartOffset, long inLineLength) {
        String subPath = new File(outerPath.toString().substring(outerPath.toString().indexOf(SCHEME_SEPARATOR) + 1)).getPath();
        return new Path("inlinefs:/" + subPath + PATH_SEPARATOR + origScheme + PATH_SEPARATOR + "?" + START_OFFSET_STR + EQUALS_STR + inLineStartOffset + "&" + LENGTH_STR + EQUALS_STR + inLineLength);
    }

    public static Path getOuterFilePathFromInlinePath(Path inlineFSPath) {
        InLineFSUtils.assertInlineFSPath(inlineFSPath);
        String outerFileScheme = inlineFSPath.getParent().getName();
        Path basePath = inlineFSPath.getParent().getParent();
        ValidationUtils.checkArgument(basePath.toString().contains(SCHEME_SEPARATOR), "Invalid InLineFS path: " + inlineFSPath);
        String pathExceptScheme = basePath.toString().substring(basePath.toString().indexOf(SCHEME_SEPARATOR) + 1);
        String fullPath = outerFileScheme + SCHEME_SEPARATOR + (outerFileScheme.equals(LOCAL_FILESYSTEM_SCHEME) ? PATH_SEPARATOR : "") + pathExceptScheme;
        return new Path(fullPath);
    }

    public static int startOffset(Path inlineFSPath) {
        InLineFSUtils.assertInlineFSPath(inlineFSPath);
        String[] slices = inlineFSPath.toString().split("[?&=]");
        return Integer.parseInt(slices[slices.length - 3]);
    }

    public static int length(Path inlinePath) {
        InLineFSUtils.assertInlineFSPath(inlinePath);
        String[] slices = inlinePath.toString().split("[?&=]");
        return Integer.parseInt(slices[slices.length - 1]);
    }

    private static void assertInlineFSPath(Path inlinePath) {
        String scheme = inlinePath.toUri().getScheme();
        ValidationUtils.checkArgument("inlinefs".equals(scheme));
    }
}

