/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieMapPair;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.FunctionWrapper;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieList<T>
extends HoodieData<T> {
    private final List<T> listData;

    private HoodieList(List<T> listData) {
        this.listData = listData;
    }

    public static <T> HoodieList<T> of(List<T> listData) {
        return new HoodieList<T>(listData);
    }

    public static <T> List<T> getList(HoodieData<T> hoodieData) {
        return ((HoodieList)hoodieData).get();
    }

    @Override
    public List<T> get() {
        return this.listData;
    }

    @Override
    public void persist(String cacheConfig) {
    }

    @Override
    public void unpersist() {
    }

    @Override
    public boolean isEmpty() {
        return this.listData.isEmpty();
    }

    @Override
    public long count() {
        return this.listData.size();
    }

    @Override
    public <O> HoodieData<O> map(SerializableFunction<T, O> func) {
        return HoodieList.of(((Stream)this.listData.stream().parallel()).map(FunctionWrapper.throwingMapWrapper(func)).collect(Collectors.toList()));
    }

    @Override
    public <O> HoodieData<O> mapPartitions(SerializableFunction<Iterator<T>, Iterator<O>> func, boolean preservesPartitioning) {
        ArrayList result = new ArrayList();
        FunctionWrapper.throwingMapWrapper(func).apply(this.listData.iterator()).forEachRemaining(result::add);
        return HoodieList.of(result);
    }

    @Override
    public <O> HoodieData<O> flatMap(SerializableFunction<T, Iterator<O>> func) {
        Function throwableFunc = FunctionWrapper.throwingMapWrapper(func);
        return HoodieList.of(this.listData.stream().flatMap((? super T e) -> {
            ArrayList result = new ArrayList();
            Iterator iterator = (Iterator)throwableFunc.apply(e);
            iterator.forEachRemaining(result::add);
            return result.stream();
        }).collect(Collectors.toList()));
    }

    @Override
    public <K, V> HoodiePairData<K, V> mapToPair(SerializablePairFunction<T, K, V> mapToPairFunc) {
        HashMap mapOfPairs = new HashMap();
        Function throwableMapToPairFunc = FunctionWrapper.throwingMapToPairWrapper(mapToPairFunc);
        this.listData.forEach(data -> {
            Pair pair = (Pair)throwableMapToPairFunc.apply(data);
            List list = mapOfPairs.computeIfAbsent(pair.getKey(), k -> new ArrayList());
            list.add(pair.getValue());
        });
        return HoodieMapPair.of(mapOfPairs);
    }

    @Override
    public HoodieData<T> distinct() {
        return HoodieList.of(new ArrayList<T>(new HashSet<T>(this.listData)));
    }

    @Override
    public HoodieData<T> distinct(int parallelism) {
        return this.distinct();
    }

    @Override
    public <O> HoodieData<T> distinctWithKey(SerializableFunction<T, O> keyGetter, int parallelism) {
        return this.mapToPair(i -> Pair.of(keyGetter.apply(i), i)).reduceByKey((value1, value2) -> value1, parallelism).values();
    }

    @Override
    public HoodieData<T> filter(SerializableFunction<T, Boolean> filterFunc) {
        return HoodieList.of(this.listData.stream().filter((? super T i) -> (Boolean)FunctionWrapper.throwingMapWrapper(filterFunc).apply(i)).collect(Collectors.toList()));
    }

    @Override
    public HoodieData<T> union(HoodieData<T> other) {
        ArrayList<T> unionResult = new ArrayList<T>();
        unionResult.addAll(this.listData);
        unionResult.addAll(other.collectAsList());
        return HoodieList.of(unionResult);
    }

    @Override
    public List<T> collectAsList() {
        return this.listData;
    }

    @Override
    public HoodieData<T> repartition(int parallelism) {
        return this;
    }
}

