/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;

public class TableName
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ILL_ARG_EXCEPTION_MSG = "Table name must be either <tablename>, <dbname>.<tablename> or <catname>.<dbname>.<tablename>";
    public static final Pattern SNAPSHOT_REF = Pattern.compile("(?:branch_|tag_)(.*)");
    private final String cat;
    private final String db;
    private final String table;
    private final String tableMetaRef;

    public TableName(String catName, String dbName, String tableName, String tableMetaRef) {
        this.cat = catName;
        this.db = dbName;
        this.table = tableName;
        this.tableMetaRef = tableMetaRef;
    }

    public TableName(String catName, String dbName, String tableName) {
        this(catName, dbName, tableName, null);
    }

    public static TableName fromString(String name, String defaultCatalog, String defaultDatabase) {
        return TableName.fromString(name, defaultCatalog, defaultDatabase, null);
    }

    public static TableName fromString(String name, String defaultCatalog, String defaultDatabase, String tableMetaRef) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(String.join((CharSequence)"", "Table value was null. ", ILL_ARG_EXCEPTION_MSG));
        }
        if (name.contains(".")) {
            String[] names = name.split("\\.");
            if (names.length == 2) {
                return new TableName(defaultCatalog, names[0], names[1], null);
            }
            if (names.length == 3) {
                if (SNAPSHOT_REF.matcher(names[2]).matches()) {
                    return new TableName(defaultCatalog, names[0], names[1], names[2]);
                }
                return new TableName(names[0], names[1], names[2], null);
            }
            throw new IllegalArgumentException(ILL_ARG_EXCEPTION_MSG);
        }
        return new TableName(defaultCatalog, defaultDatabase, name, tableMetaRef);
    }

    public String getCat() {
        return this.cat;
    }

    public String getDb() {
        return this.db;
    }

    public String getTable() {
        return this.table;
    }

    public String getTableMetaRef() {
        return this.tableMetaRef;
    }

    public String getDbTable() {
        return this.db + "." + this.table;
    }

    public String getEscapedNotEmptyDbTable() {
        return this.db == null || this.db.trim().isEmpty() ? "`" + this.table + "`" : "`" + this.db + "`" + "." + "`" + this.table + "`";
    }

    public String getNotEmptyDbTable() {
        String metaRefName = this.tableMetaRef == null ? "" : "." + this.tableMetaRef;
        return this.db == null || this.db.trim().isEmpty() ? this.table : this.db + "." + this.table + metaRefName;
    }

    public static String getDbTable(String dbName, String tableName) {
        return dbName + "." + tableName;
    }

    public static String getQualified(String catName, String dbName, String tableName) {
        return catName + "." + dbName + "." + tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableName tableName = (TableName)o;
        return Objects.equals(this.cat, tableName.cat) && Objects.equals(this.db, tableName.db) && Objects.equals(this.table, tableName.table);
    }

    public int hashCode() {
        return Objects.hash(this.cat, this.db, this.table);
    }

    public String toString() {
        return this.cat + "." + this.db + "." + this.table;
    }
}

