/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TCancelOperationReq;
import org.apache.hive.service.rpc.thrift.TCancelOperationResp;
import org.apache.hive.service.rpc.thrift.TCloseOperationReq;
import org.apache.hive.service.rpc.thrift.TCloseOperationResp;
import org.apache.hive.service.rpc.thrift.TCloseSessionReq;
import org.apache.hive.service.rpc.thrift.TCloseSessionResp;
import org.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import org.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import org.apache.hive.service.rpc.thrift.TFetchResultsReq;
import org.apache.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import org.apache.hive.service.rpc.thrift.TGetCatalogsResp;
import org.apache.hive.service.rpc.thrift.TGetColumnsReq;
import org.apache.hive.service.rpc.thrift.TGetColumnsResp;
import org.apache.hive.service.rpc.thrift.TGetCrossReferenceReq;
import org.apache.hive.service.rpc.thrift.TGetCrossReferenceResp;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import org.apache.hive.service.rpc.thrift.TGetFunctionsResp;
import org.apache.hive.service.rpc.thrift.TGetInfoReq;
import org.apache.hive.service.rpc.thrift.TGetInfoResp;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import org.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import org.apache.hive.service.rpc.thrift.TGetPrimaryKeysReq;
import org.apache.hive.service.rpc.thrift.TGetPrimaryKeysResp;
import org.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import org.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import org.apache.hive.service.rpc.thrift.TGetSchemasReq;
import org.apache.hive.service.rpc.thrift.TGetSchemasResp;
import org.apache.hive.service.rpc.thrift.TGetTableTypesReq;
import org.apache.hive.service.rpc.thrift.TGetTableTypesResp;
import org.apache.hive.service.rpc.thrift.TGetTablesReq;
import org.apache.hive.service.rpc.thrift.TGetTablesResp;
import org.apache.hive.service.rpc.thrift.TGetTypeInfoReq;
import org.apache.hive.service.rpc.thrift.TGetTypeInfoResp;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.hive.service.server.HiveServer2;
import org.apache.thrift.TException;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThriftCLIService
extends AbstractService
implements TCLIService.Iface,
Runnable {
    public static final Logger LOG = LoggerFactory.getLogger((String)ThriftCLIService.class.getName());
    protected CLIService cliService;
    private static final TStatus OK_STATUS = new TStatus(TStatusCode.SUCCESS_STATUS);
    protected static HiveAuthFactory hiveAuthFactory;
    private static final AtomicInteger sessionCount;
    protected int portNum;
    protected InetAddress serverIPAddress;
    protected String hiveHost;
    protected TServer server;
    protected Server httpServer;
    private boolean isStarted = false;
    protected boolean isEmbedded = false;
    protected HiveConf hiveConf;
    protected int minWorkerThreads;
    protected int maxWorkerThreads;
    protected long workerKeepAliveTime;
    protected ThreadLocal<ServerContext> currentServerContext;

    public ThriftCLIService(CLIService service, String serviceName) {
        super(serviceName);
        this.cliService = service;
        this.currentServerContext = new ThreadLocal();
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        String hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST");
        if (hiveHost == null) {
            hiveHost = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST);
        }
        try {
            this.serverIPAddress = ServerUtils.getHostAddress((String)hiveHost);
        }
        catch (UnknownHostException e) {
            throw new ServiceException(e);
        }
        if (HiveServer2.isHTTPTransportMode(hiveConf)) {
            this.workerKeepAliveTime = hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_WORKER_KEEPALIVE_TIME, TimeUnit.SECONDS);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_HTTP_PORT");
            this.portNum = portString != null ? Integer.parseInt(portString) : hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT);
        } else {
            this.workerKeepAliveTime = hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_WORKER_KEEPALIVE_TIME, TimeUnit.SECONDS);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_PORT");
            this.portNum = portString != null ? Integer.parseInt(portString) : hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
        }
        this.minWorkerThreads = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS);
        this.maxWorkerThreads = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
        if (!this.isStarted && !this.isEmbedded) {
            new Thread(this).start();
            this.isStarted = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.isStarted && !this.isEmbedded) {
            if (this.server != null) {
                this.server.stop();
                LOG.info("Thrift server has stopped");
            }
            if (this.httpServer != null && this.httpServer.isStarted()) {
                try {
                    this.httpServer.stop();
                    LOG.info("Http server has stopped");
                }
                catch (Exception e) {
                    LOG.error("Error stopping Http server: ", (Throwable)e);
                }
            }
            this.isStarted = false;
        }
        super.stop();
    }

    public int getPortNumber() {
        return this.portNum;
    }

    public InetAddress getServerIPAddress() {
        return this.serverIPAddress;
    }

    public TGetDelegationTokenResp GetDelegationToken(TGetDelegationTokenReq req) throws TException {
        TGetDelegationTokenResp resp = new TGetDelegationTokenResp();
        if (hiveAuthFactory == null) {
            resp.setStatus(this.unsecureTokenErrorStatus());
        } else {
            try {
                String token = this.cliService.getDelegationToken(new SessionHandle(req.getSessionHandle()), hiveAuthFactory, req.getOwner(), req.getRenewer());
                resp.setDelegationToken(token);
                resp.setStatus(OK_STATUS);
            }
            catch (HiveSQLException e) {
                LOG.error("Error obtaining delegation token", (Throwable)e);
                TStatus tokenErrorStatus = HiveSQLException.toTStatus(e);
                tokenErrorStatus.setSqlState("42000");
                resp.setStatus(tokenErrorStatus);
            }
        }
        return resp;
    }

    public TCancelDelegationTokenResp CancelDelegationToken(TCancelDelegationTokenReq req) throws TException {
        TCancelDelegationTokenResp resp = new TCancelDelegationTokenResp();
        if (hiveAuthFactory == null) {
            resp.setStatus(this.unsecureTokenErrorStatus());
        } else {
            try {
                this.cliService.cancelDelegationToken(new SessionHandle(req.getSessionHandle()), hiveAuthFactory, req.getDelegationToken());
                resp.setStatus(OK_STATUS);
            }
            catch (HiveSQLException e) {
                LOG.error("Error canceling delegation token", (Throwable)e);
                resp.setStatus(HiveSQLException.toTStatus(e));
            }
        }
        return resp;
    }

    public TRenewDelegationTokenResp RenewDelegationToken(TRenewDelegationTokenReq req) throws TException {
        TRenewDelegationTokenResp resp = new TRenewDelegationTokenResp();
        if (hiveAuthFactory == null) {
            resp.setStatus(this.unsecureTokenErrorStatus());
        } else {
            try {
                this.cliService.renewDelegationToken(new SessionHandle(req.getSessionHandle()), hiveAuthFactory, req.getDelegationToken());
                resp.setStatus(OK_STATUS);
            }
            catch (HiveSQLException e) {
                LOG.error("Error obtaining renewing token", (Throwable)e);
                resp.setStatus(HiveSQLException.toTStatus(e));
            }
        }
        return resp;
    }

    private TStatus unsecureTokenErrorStatus() {
        TStatus errorStatus = new TStatus(TStatusCode.ERROR_STATUS);
        errorStatus.setErrorMessage("Delegation token only supported over remote client with kerberos authentication");
        return errorStatus;
    }

    public TOpenSessionResp OpenSession(TOpenSessionReq req) throws TException {
        LOG.info("Client protocol version: " + req.getClient_protocol());
        TOpenSessionResp resp = new TOpenSessionResp();
        try {
            SessionHandle sessionHandle = this.getSessionHandle(req, resp);
            resp.setSessionHandle(sessionHandle.toTSessionHandle());
            resp.setConfiguration(new HashMap());
            resp.setStatus(OK_STATUS);
            ThriftCLIServerContext context = (ThriftCLIServerContext)this.currentServerContext.get();
            if (context != null) {
                context.setSessionHandle(sessionHandle);
            }
            LOG.info("Opened a session, current sessions: " + sessionCount.incrementAndGet());
        }
        catch (Exception e) {
            LOG.warn("Error opening session: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    private String getIpAddress() {
        String clientIpAddress = this.cliService.getHiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE).equalsIgnoreCase("http") ? SessionManager.getIpAddress() : (hiveAuthFactory != null && hiveAuthFactory.isSASLWithKerberizedHadoop() ? hiveAuthFactory.getIpAddress() : TSetIpAddressProcessor.getUserIpAddress());
        LOG.debug("Client's IP Address: " + clientIpAddress);
        return clientIpAddress;
    }

    private String getUserName(TOpenSessionReq req) throws HiveSQLException, IOException {
        String userName = null;
        if (hiveAuthFactory != null && hiveAuthFactory.isSASLWithKerberizedHadoop()) {
            userName = hiveAuthFactory.getRemoteUser();
        }
        if (userName == null) {
            userName = TSetIpAddressProcessor.getUserName();
        }
        if (this.cliService.getHiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE).equalsIgnoreCase("http")) {
            userName = SessionManager.getUserName();
        }
        if (userName == null) {
            userName = req.getUsername();
        }
        userName = this.getShortName(userName);
        String effectiveClientUser = this.getProxyUser(userName, req.getConfiguration(), this.getIpAddress());
        LOG.debug("Client's username: " + effectiveClientUser);
        return effectiveClientUser;
    }

    private String getShortName(String userName) throws IOException {
        String ret = null;
        if (userName != null) {
            HadoopShims.KerberosNameShim fullKerberosName = ShimLoader.getHadoopShims().getKerberosNameShim(userName);
            ret = fullKerberosName.getShortName();
        }
        return ret;
    }

    SessionHandle getSessionHandle(TOpenSessionReq req, TOpenSessionResp res) throws HiveSQLException, LoginException, IOException {
        SessionHandle sessionHandle;
        String userName = this.getUserName(req);
        String ipAddress = this.getIpAddress();
        TProtocolVersion protocol = this.getMinVersion(CLIService.SERVER_VERSION, req.getClient_protocol());
        if (this.cliService.getHiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS) && userName != null) {
            String delegationTokenStr = this.getDelegationToken(userName);
            sessionHandle = this.cliService.openSessionWithImpersonation(protocol, userName, req.getPassword(), ipAddress, req.getConfiguration(), delegationTokenStr);
        } else {
            sessionHandle = this.cliService.openSession(protocol, userName, req.getPassword(), ipAddress, req.getConfiguration());
        }
        res.setServerProtocolVersion(protocol);
        return sessionHandle;
    }

    private String getDelegationToken(String userName) throws HiveSQLException, LoginException, IOException {
        try {
            return this.cliService.getDelegationTokenFromMetaStore(userName);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    private TProtocolVersion getMinVersion(TProtocolVersion ... versions) {
        TProtocolVersion[] values = TProtocolVersion.values();
        int current = values[values.length - 1].getValue();
        for (TProtocolVersion version : versions) {
            if (current <= version.getValue()) continue;
            current = version.getValue();
        }
        for (TProtocolVersion version : values) {
            if (version.getValue() != current) continue;
            return version;
        }
        throw new IllegalArgumentException("never");
    }

    public TCloseSessionResp CloseSession(TCloseSessionReq req) throws TException {
        TCloseSessionResp resp = new TCloseSessionResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            this.cliService.closeSession(sessionHandle);
            LOG.info("Closed a session, current sessions: " + sessionCount.decrementAndGet());
            resp.setStatus(OK_STATUS);
            ThriftCLIServerContext context = (ThriftCLIServerContext)this.currentServerContext.get();
            if (context != null) {
                context.setSessionHandle(null);
            }
        }
        catch (Exception e) {
            LOG.warn("Error closing session: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetInfoResp GetInfo(TGetInfoReq req) throws TException {
        TGetInfoResp resp = new TGetInfoResp();
        try {
            GetInfoValue getInfoValue = this.cliService.getInfo(new SessionHandle(req.getSessionHandle()), GetInfoType.getGetInfoType(req.getInfoType()));
            resp.setInfoValue(getInfoValue.toTGetInfoValue());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting info: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TExecuteStatementResp ExecuteStatement(TExecuteStatementReq req) throws TException {
        TExecuteStatementResp resp = new TExecuteStatementResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            String statement = req.getStatement();
            Map confOverlay = req.getConfOverlay();
            Boolean runAsync = req.isRunAsync();
            long queryTimeout = req.getQueryTimeout();
            OperationHandle operationHandle = runAsync != false ? this.cliService.executeStatementAsync(sessionHandle, statement, confOverlay, queryTimeout) : this.cliService.executeStatement(sessionHandle, statement, confOverlay, queryTimeout);
            resp.setOperationHandle(operationHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error executing statement: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetTypeInfoResp GetTypeInfo(TGetTypeInfoReq req) throws TException {
        TGetTypeInfoResp resp = new TGetTypeInfoResp();
        try {
            OperationHandle operationHandle = this.cliService.getTypeInfo(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(operationHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting type info: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetCatalogsResp GetCatalogs(TGetCatalogsReq req) throws TException {
        TGetCatalogsResp resp = new TGetCatalogsResp();
        try {
            OperationHandle opHandle = this.cliService.getCatalogs(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting catalogs: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetSchemasResp GetSchemas(TGetSchemasReq req) throws TException {
        TGetSchemasResp resp = new TGetSchemasResp();
        try {
            OperationHandle opHandle = this.cliService.getSchemas(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting schemas: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetTablesResp GetTables(TGetTablesReq req) throws TException {
        TGetTablesResp resp = new TGetTablesResp();
        try {
            OperationHandle opHandle = this.cliService.getTables(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getTableName(), req.getTableTypes());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting tables: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetTableTypesResp GetTableTypes(TGetTableTypesReq req) throws TException {
        TGetTableTypesResp resp = new TGetTableTypesResp();
        try {
            OperationHandle opHandle = this.cliService.getTableTypes(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting table types: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetColumnsResp GetColumns(TGetColumnsReq req) throws TException {
        TGetColumnsResp resp = new TGetColumnsResp();
        try {
            OperationHandle opHandle = this.cliService.getColumns(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getTableName(), req.getColumnName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting columns: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetFunctionsResp GetFunctions(TGetFunctionsReq req) throws TException {
        TGetFunctionsResp resp = new TGetFunctionsResp();
        try {
            OperationHandle opHandle = this.cliService.getFunctions(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getFunctionName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting functions: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetOperationStatusResp GetOperationStatus(TGetOperationStatusReq req) throws TException {
        TGetOperationStatusResp resp = new TGetOperationStatusResp();
        try {
            OperationStatus operationStatus = this.cliService.getOperationStatus(new OperationHandle(req.getOperationHandle()));
            resp.setOperationState(operationStatus.getState().toTOperationState());
            HiveSQLException opException = operationStatus.getOperationException();
            resp.setTaskStatus(operationStatus.getTaskStatus());
            resp.setOperationStarted(operationStatus.getOperationStarted());
            resp.setOperationCompleted(operationStatus.getOperationCompleted());
            if (opException != null) {
                resp.setSqlState(opException.getSQLState());
                resp.setErrorCode(opException.getErrorCode());
                resp.setErrorMessage(opException.getMessage());
            }
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting operation status: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TCancelOperationResp CancelOperation(TCancelOperationReq req) throws TException {
        TCancelOperationResp resp = new TCancelOperationResp();
        try {
            this.cliService.cancelOperation(new OperationHandle(req.getOperationHandle()));
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error cancelling operation: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TCloseOperationResp CloseOperation(TCloseOperationReq req) throws TException {
        TCloseOperationResp resp = new TCloseOperationResp();
        try {
            this.cliService.closeOperation(new OperationHandle(req.getOperationHandle()));
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error closing operation: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetResultSetMetadataResp GetResultSetMetadata(TGetResultSetMetadataReq req) throws TException {
        TGetResultSetMetadataResp resp = new TGetResultSetMetadataResp();
        try {
            TableSchema schema = this.cliService.getResultSetMetadata(new OperationHandle(req.getOperationHandle()));
            resp.setSchema(schema.toTTableSchema());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting result set metadata: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TFetchResultsResp FetchResults(TFetchResultsReq req) throws TException {
        TFetchResultsResp resp = new TFetchResultsResp();
        try {
            RowSet rowSet = this.cliService.fetchResults(new OperationHandle(req.getOperationHandle()), FetchOrientation.getFetchOrientation(req.getOrientation()), req.getMaxRows(), FetchType.getFetchType(req.getFetchType()));
            resp.setResults(rowSet.toTRowSet());
            resp.setHasMoreRows(false);
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error fetching results: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetPrimaryKeysResp GetPrimaryKeys(TGetPrimaryKeysReq req) throws TException {
        TGetPrimaryKeysResp resp = new TGetPrimaryKeysResp();
        try {
            OperationHandle opHandle = this.cliService.getPrimaryKeys(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getTableName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting functions: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    public TGetCrossReferenceResp GetCrossReference(TGetCrossReferenceReq req) throws TException {
        TGetCrossReferenceResp resp = new TGetCrossReferenceResp();
        try {
            OperationHandle opHandle = this.cliService.getCrossReference(new SessionHandle(req.getSessionHandle()), req.getParentCatalogName(), req.getParentSchemaName(), req.getParentTableName(), req.getForeignCatalogName(), req.getForeignSchemaName(), req.getForeignTableName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            LOG.warn("Error getting functions: ", (Throwable)e);
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public abstract void run();

    private String getProxyUser(String realUser, Map<String, String> sessionConf, String ipAddress) throws HiveSQLException {
        String proxyUser = null;
        if (this.cliService.getHiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE).equalsIgnoreCase("http")) {
            proxyUser = SessionManager.getProxyUserName();
            LOG.debug("Proxy user from query string: " + proxyUser);
        }
        if (proxyUser == null && sessionConf != null && sessionConf.containsKey("hive.server2.proxy.user")) {
            String proxyUserFromThriftBody = sessionConf.get("hive.server2.proxy.user");
            LOG.debug("Proxy user from thrift body: " + proxyUserFromThriftBody);
            proxyUser = proxyUserFromThriftBody;
        }
        if (proxyUser == null) {
            return realUser;
        }
        if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ALLOW_USER_SUBSTITUTION)) {
            throw new HiveSQLException("Proxy user substitution is not allowed");
        }
        if (HiveAuthFactory.AuthTypes.NONE.toString().equalsIgnoreCase(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION))) {
            return proxyUser;
        }
        HiveAuthFactory.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hiveConf);
        LOG.debug("Verified proxy user: " + proxyUser);
        return proxyUser;
    }

    static {
        sessionCount = new AtomicInteger();
    }

    static class ThriftCLIServerContext
    implements ServerContext {
        private SessionHandle sessionHandle = null;

        ThriftCLIServerContext() {
        }

        public void setSessionHandle(SessionHandle sessionHandle) {
            this.sessionHandle = sessionHandle;
        }

        public SessionHandle getSessionHandle() {
            return this.sessionHandle;
        }
    }
}

