/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import com.google.common.base.Function;
import java.util.Comparator;
import org.apache.hadoop.hive.llap.daemon.impl.PriorityBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvictingPriorityBlockingQueue<E> {
    private static final Logger LOG = LoggerFactory.getLogger(EvictingPriorityBlockingQueue.class);
    private final PriorityBlockingDeque<E> deque;
    private final Comparator<E> comparator;
    private final int waitQueueSize;
    private int currentSize = 0;

    public EvictingPriorityBlockingQueue(Comparator<E> comparator, int maxSize) {
        this.deque = new PriorityBlockingDeque<E>(comparator);
        this.waitQueueSize = maxSize;
        this.comparator = comparator;
    }

    public synchronized void apply(Function<E, Boolean> fn) {
        for (E item : this.deque) {
            boolean isOk = (Boolean)fn.apply(item);
            if (isOk) continue;
            return;
        }
    }

    public synchronized void forceOffer(E e) {
        this.offerToDequeueInternal(e);
        ++this.currentSize;
    }

    public synchronized E offer(E e, int additionalElementsAllowed) {
        if (this.currentSize < this.waitQueueSize + additionalElementsAllowed) {
            this.offerToDequeueInternal(e);
            ++this.currentSize;
            return null;
        }
        if (this.isEmpty()) {
            return e;
        }
        E last = this.deque.peekLast();
        if (this.comparator.compare(e, last) < 0) {
            this.deque.removeLast();
            this.offerToDequeueInternal(e);
            return last;
        }
        return e;
    }

    public synchronized boolean isEmpty() {
        return this.currentSize == 0;
    }

    public synchronized E peek() {
        return this.deque.peek();
    }

    public synchronized E take() throws InterruptedException {
        E e = this.deque.take();
        --this.currentSize;
        return e;
    }

    public synchronized boolean remove(E e) {
        boolean removed = this.deque.remove(e);
        if (removed) {
            --this.currentSize;
        }
        return removed;
    }

    private void offerToDequeueInternal(E e) {
        boolean result = this.deque.offer(e);
        if (!result) {
            LOG.error("Failed to insert element into queue with capacity available. size={}, element={}", (Object)this.size(), e);
            throw new RuntimeException("Failed to insert element into queue with capacity available. size=" + this.size());
        }
    }

    public synchronized int size() {
        return this.currentSize;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("currentSize=").append(this.size()).append(", queue=").append(this.deque.toString());
        return sb.toString();
    }
}

