/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedOrcFile;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.orc.CompressionKind;
import org.apache.orc.DataReader;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.DataReaderProperties;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.orc.impl.RecordReaderUtils;
import org.apache.tez.common.CallableWithNdc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcEncodedDataReader
extends CallableWithNdc<Void>
implements ConsumerFeedback<Reader.OrcEncodedColumnBatch> {
    private static final Logger LOG = LoggerFactory.getLogger(OrcEncodedDataReader.class);
    public static final FixedSizedObjectPool<EncodedColumnBatch.ColumnStreamData> CSD_POOL = new FixedSizedObjectPool(8192, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<EncodedColumnBatch.ColumnStreamData>(){

        public EncodedColumnBatch.ColumnStreamData create() {
            return new EncodedColumnBatch.ColumnStreamData();
        }

        public void resetBeforeOffer(EncodedColumnBatch.ColumnStreamData t) {
            t.reset();
        }
    });
    public static final FixedSizedObjectPool<Reader.OrcEncodedColumnBatch> ECB_POOL = new FixedSizedObjectPool(1024, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<Reader.OrcEncodedColumnBatch>(){

        public Reader.OrcEncodedColumnBatch create() {
            return new Reader.OrcEncodedColumnBatch();
        }

        public void resetBeforeOffer(Reader.OrcEncodedColumnBatch t) {
            t.reset();
        }
    });
    private static final Reader.PoolFactory POOL_FACTORY = new Reader.PoolFactory(){

        public <T> Pool<T> createPool(int size, Pool.PoolObjectHelper<T> helper) {
            return new FixedSizedObjectPool(size, helper);
        }

        public Pool<EncodedColumnBatch.ColumnStreamData> createColumnStreamDataPool() {
            return CSD_POOL;
        }

        public Pool<Reader.OrcEncodedColumnBatch> createEncodedColumnBatchPool() {
            return ECB_POOL;
        }
    };
    private final OrcMetadataCache metadataCache;
    private final LowLevelCache lowLevelCache;
    private final BufferUsageManager bufferManager;
    private final Configuration conf;
    private final FileSplit split;
    private List<Integer> columnIds;
    private final SearchArgument sarg;
    private final String[] columnNames;
    private final OrcEncodedDataConsumer consumer;
    private final QueryFragmentCounters counters;
    private final UserGroupInformation ugi;
    private int stripeIxFrom;
    private OrcFileMetadata fileMetadata;
    private Path path;
    private Reader orcReader;
    private DataReader metadataReader;
    private EncodedReader stripeReader;
    private Object fileKey;
    private FileSystem fs;
    private boolean[][][] readState;
    private volatile boolean isStopped = false;
    private volatile boolean isPaused = false;

    public OrcEncodedDataReader(LowLevelCache lowLevelCache, BufferUsageManager bufferManager, OrcMetadataCache metadataCache, Configuration conf, FileSplit split, List<Integer> columnIds, SearchArgument sarg, String[] columnNames, OrcEncodedDataConsumer consumer, QueryFragmentCounters counters) {
        this.lowLevelCache = lowLevelCache;
        this.metadataCache = metadataCache;
        this.bufferManager = bufferManager;
        this.conf = conf;
        this.split = split;
        this.columnIds = columnIds;
        if (this.columnIds != null) {
            Collections.sort(this.columnIds);
        }
        this.sarg = sarg;
        this.columnNames = columnNames;
        this.consumer = consumer;
        this.counters = counters;
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        LOG.debug("Encoded reader is being stopped");
        this.isStopped = true;
    }

    @Override
    public void pause() {
        this.isPaused = true;
    }

    @Override
    public void unpause() {
        this.isPaused = false;
    }

    protected Void callInternal() throws IOException, InterruptedException {
        return (Void)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                return OrcEncodedDataReader.this.performDataRead();
            }
        });
    }

    protected Void performDataRead() throws IOException {
        long startTime = this.counters.startTimeCounter();
        LlapIoImpl.LOG.info("Processing data for {}", (Object)this.split.getPath());
        if (this.processStop()) {
            this.recordReaderTime(startTime);
            return null;
        }
        this.counters.setDesc(QueryFragmentCounters.Desc.TABLE, OrcEncodedDataReader.getDbAndTableName(this.split.getPath()));
        this.orcReader = null;
        this.fs = this.split.getPath().getFileSystem(this.conf);
        this.fileKey = OrcEncodedDataReader.determineFileId(this.fs, this.split, HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_ALLOW_SYNTHETIC_FILEID));
        this.counters.setDesc(QueryFragmentCounters.Desc.FILE, this.split.getPath() + (this.fileKey == null ? "" : " (" + this.fileKey + ")"));
        try {
            this.fileMetadata = this.getOrReadFileMetadata();
            this.consumer.setFileMetadata(this.fileMetadata);
            this.validateFileMetadata();
            if (this.columnIds == null) {
                this.columnIds = OrcEncodedDataReader.createColumnIds(this.fileMetadata);
            }
            this.determineStripesToRead();
        }
        catch (Throwable t) {
            this.recordReaderTime(startTime);
            this.consumer.setError(t);
            return null;
        }
        if (this.readState.length == 0) {
            this.consumer.setDone();
            this.recordReaderTime(startTime);
            return null;
        }
        this.counters.setDesc(QueryFragmentCounters.Desc.STRIPES, this.stripeIxFrom + "," + this.readState.length);
        int stride = this.fileMetadata.getRowIndexStride();
        ArrayList<OrcStripeMetadata> stripeMetadatas = null;
        boolean[] globalIncludes = null;
        boolean[] sargColumns = null;
        try {
            boolean hasData;
            globalIncludes = OrcInputFormat.genIncludedColumns(this.fileMetadata.getTypes(), this.columnIds, (boolean)true);
            if (this.sarg != null && stride != 0) {
                int[] filterColumns = RecordReaderImpl.mapSargColumnsToOrcInternalColIdx((List)this.sarg.getLeaves(), (String[])this.columnNames, (int)0);
                sargColumns = new boolean[globalIncludes.length];
                for (int i : filterColumns) {
                    if (i <= 0) continue;
                    sargColumns[i] = true;
                }
                stripeMetadatas = this.readStripesMetadata(globalIncludes, sargColumns);
            }
            if (!(hasData = this.determineRgsToRead(globalIncludes, stride, stripeMetadatas))) {
                this.consumer.setDone();
                this.recordReaderTime(startTime);
                return null;
            }
        }
        catch (Throwable t) {
            this.cleanupReaders();
            this.consumer.setError(t);
            this.recordReaderTime(startTime);
            return null;
        }
        if (this.processStop()) {
            this.cleanupReaders();
            this.recordReaderTime(startTime);
            return null;
        }
        Object stripeColsToRead = null;
        try {
            this.ensureOrcReader();
            DataWrapperForOrc dw = new DataWrapperForOrc();
            this.stripeReader = this.orcReader.encodedReader(this.fileKey, (DataCache)dw, (DataReader)dw, POOL_FACTORY);
            this.stripeReader.setTracing(LlapIoImpl.ORC_LOGGER.isTraceEnabled());
        }
        catch (Throwable t) {
            this.consumer.setError(t);
            this.recordReaderTime(startTime);
            this.cleanupReaders();
            return null;
        }
        boolean hasFileId = this.fileKey != null;
        OrcBatchKey stripeKey = hasFileId ? new OrcBatchKey(this.fileKey, -1, 0) : null;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            StripeInformation stripe;
            if (this.processStop()) {
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            int stripeIx = this.stripeIxFrom + stripeIxMod;
            boolean[][] colRgs = null;
            boolean[] stripeIncludes = null;
            OrcStripeMetadata stripeMetadata = null;
            try {
                List<Integer> cols;
                Object object = cols = stripeColsToRead == null ? null : stripeColsToRead[stripeIxMod];
                if (cols != null && cols.isEmpty()) continue;
                stripe = this.fileMetadata.getStripes().get(stripeIx);
                LlapIoImpl.ORC_LOGGER.trace("Reading stripe {}: {}, {}", new Object[]{stripeIx, stripe.getOffset(), stripe.getLength()});
                colRgs = this.readState[stripeIxMod];
                if (colRgs.length > 0 && colRgs[0] == RecordReaderImpl.SargApplier.READ_NO_RGS) continue;
                if (cols == null || cols.size() == colRgs.length) {
                    cols = this.columnIds;
                    stripeIncludes = globalIncludes;
                } else {
                    stripeIncludes = OrcInputFormat.genIncludedColumns(this.fileMetadata.getTypes(), cols, (boolean)true);
                    colRgs = this.genStripeColRgs(cols, colRgs);
                }
                boolean isFoundInCache = false;
                if (stripeMetadatas != null) {
                    stripeMetadata = stripeMetadatas.get(stripeIxMod);
                } else {
                    if (hasFileId && this.metadataCache != null) {
                        stripeKey.stripeIx = stripeIx;
                        stripeMetadata = this.metadataCache.getStripeMetadata(stripeKey);
                    }
                    boolean bl = isFoundInCache = stripeMetadata != null;
                    if (!isFoundInCache) {
                        this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
                        this.ensureMetadataReader();
                        long startTimeHdfs = this.counters.startTimeCounter();
                        stripeMetadata = new OrcStripeMetadata(new OrcBatchKey(this.fileKey, stripeIx, 0), this.metadataReader, stripe, stripeIncludes, sargColumns);
                        this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTimeHdfs);
                        if (hasFileId && this.metadataCache != null) {
                            stripeMetadata = this.metadataCache.putStripeMetadata(stripeMetadata);
                            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                                LlapIoImpl.ORC_LOGGER.trace("Caching stripe {} metadata with includes: {}", (Object)stripeKey.stripeIx, (Object)DebugUtils.toString((boolean[])stripeIncludes));
                            }
                        }
                    }
                    this.consumer.setStripeMetadata(stripeMetadata);
                }
                if (!stripeMetadata.hasAllIndexes(stripeIncludes)) {
                    if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.ORC_LOGGER.trace("Updating indexes in stripe {} metadata for includes: {}", (Object)stripeKey.stripeIx, (Object)DebugUtils.toString((boolean[])stripeIncludes));
                    }
                    assert (isFoundInCache);
                    this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
                    this.ensureMetadataReader();
                    this.updateLoadedIndexes(stripeMetadata, stripe, stripeIncludes, sargColumns);
                } else if (isFoundInCache) {
                    this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_HIT);
                }
            }
            catch (Throwable t) {
                this.consumer.setError(t);
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            if (this.processStop()) {
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
            try {
                this.stripeReader.readEncodedColumns(stripeIx, stripe, stripeMetadata.getRowIndexes(), stripeMetadata.getEncodings(), stripeMetadata.getStreams(), stripeIncludes, colRgs, (Consumer)this.consumer);
                continue;
            }
            catch (Throwable t) {
                this.consumer.setError(t);
                this.cleanupReaders();
                this.recordReaderTime(startTime);
                return null;
            }
        }
        this.recordReaderTime(startTime);
        this.consumer.setDone();
        LlapIoImpl.LOG.trace("done processing {}", (Object)this.split);
        this.cleanupReaders();
        return null;
    }

    private void recordReaderTime(long startTime) {
        this.counters.incrTimeCounter(LlapIOCounters.TOTAL_IO_TIME_NS, startTime);
    }

    private static String getDbAndTableName(Path path) {
        String[] parts = path.toUri().getPath().toString().split("/");
        int dbIx = -1;
        for (int i = 0; i < parts.length - 2; ++i) {
            if (!parts[i].endsWith(".db")) continue;
            if (dbIx >= 0) {
                dbIx = -1;
                break;
            }
            dbIx = i;
        }
        if (dbIx >= 0) {
            return parts[dbIx].substring(0, parts[dbIx].length() - 3) + "." + parts[dbIx + 1];
        }
        boolean isInPartFields = false;
        for (int i = parts.length - 2; i >= 0; --i) {
            String p = parts[i];
            boolean isPartField = p.contains("=");
            if (isInPartFields && !isPartField || !isPartField && !p.startsWith("base_") && !p.startsWith("delta_") && !p.startsWith("bucket_")) {
                dbIx = i - 1;
                break;
            }
            isInPartFields = isPartField;
        }
        if (dbIx >= 0) {
            String dbName = parts[dbIx];
            if (dbName.endsWith(".db")) {
                dbName = dbName.substring(0, dbName.length() - 3);
            }
            return dbName + "." + parts[dbIx + 1];
        }
        return "unknown";
    }

    private void validateFileMetadata() throws IOException {
        long minAllocSize;
        if (this.fileMetadata.getCompressionKind() == CompressionKind.NONE) {
            return;
        }
        int bufferSize = this.fileMetadata.getCompressionBufferSize();
        if ((long)bufferSize < (minAllocSize = HiveConf.getSizeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC))) {
            LOG.warn("ORC compression buffer size (" + bufferSize + ") is smaller than LLAP low-level " + "cache minimum allocation size (" + minAllocSize + "). Decrease the value for " + HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC.toString() + " to avoid wasting memory");
        }
    }

    private boolean processStop() {
        if (!this.isStopped) {
            return false;
        }
        LOG.info("Encoded data reader is stopping");
        this.cleanupReaders();
        return true;
    }

    private static Object determineFileId(FileSystem fs, FileSplit split, boolean allowSynthetic) throws IOException {
        Object fileKey;
        if (split instanceof OrcSplit && (fileKey = ((OrcSplit)split).getFileKey()) != null) {
            return fileKey;
        }
        LOG.warn("Split for " + split.getPath() + " (" + split.getClass() + ") does not have file ID");
        return HdfsUtils.getFileId((FileSystem)fs, (Path)split.getPath(), (boolean)allowSynthetic);
    }

    private boolean[][] genStripeColRgs(List<Integer> stripeCols, boolean[][] globalColRgs) {
        boolean[][] stripeColRgs = new boolean[stripeCols.size()][];
        int i2 = -1;
        for (int i = 0; i < globalColRgs.length; ++i) {
            if (globalColRgs[i] == null) continue;
            stripeColRgs[i2] = globalColRgs[i];
            ++i2;
        }
        return stripeColRgs;
    }

    private static List<Integer> createColumnIds(OrcFileMetadata metadata) {
        ArrayList<Integer> columnIds = new ArrayList<Integer>(metadata.getTypes().size());
        for (int i = 1; i < metadata.getTypes().size(); ++i) {
            columnIds.add(i);
        }
        return columnIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoadedIndexes(OrcStripeMetadata stripeMetadata, StripeInformation stripe, boolean[] stripeIncludes, boolean[] sargColumns) throws IOException {
        OrcStripeMetadata orcStripeMetadata = stripeMetadata;
        synchronized (orcStripeMetadata) {
            if (stripeMetadata.hasAllIndexes(stripeIncludes)) {
                return;
            }
            long startTime = this.counters.startTimeCounter();
            stripeMetadata.loadMissingIndexes(this.metadataReader, stripe, stripeIncludes, sargColumns);
            this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
        }
    }

    private void cleanupReaders() {
        if (this.stripeReader != null) {
            try {
                this.stripeReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ensureOrcReader() throws IOException {
        if (this.orcReader != null) {
            return;
        }
        this.path = this.split.getPath();
        if (this.fileKey instanceof Long && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_USE_FILEID_PATH)) {
            this.path = HdfsUtils.getFileIdPath((FileSystem)this.fs, (Path)this.path, (long)((Long)this.fileKey));
        }
        LlapIoImpl.ORC_LOGGER.trace("Creating reader for {} ({})", (Object)this.path, (Object)this.split.getPath());
        long startTime = this.counters.startTimeCounter();
        OrcFile.ReaderOptions opts = OrcFile.readerOptions((Configuration)this.conf).filesystem(this.fs).fileMetadata((FileMetadata)this.fileMetadata);
        this.orcReader = EncodedOrcFile.createReader((Path)this.path, (OrcFile.ReaderOptions)opts);
        this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
    }

    private OrcFileMetadata getOrReadFileMetadata() throws IOException {
        OrcFileMetadata metadata = null;
        if (this.fileKey != null && this.metadataCache != null) {
            metadata = this.metadataCache.getFileMetadata(this.fileKey);
            if (metadata != null) {
                this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_HIT);
                return metadata;
            }
            this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
        }
        this.ensureOrcReader();
        metadata = new OrcFileMetadata(this.fileKey, (org.apache.hadoop.hive.ql.io.orc.Reader)this.orcReader);
        if (this.fileKey == null || this.metadataCache == null) {
            return metadata;
        }
        return this.metadataCache.putFileMetadata(metadata);
    }

    private ArrayList<OrcStripeMetadata> readStripesMetadata(boolean[] globalInc, boolean[] sargColumns) throws IOException {
        ArrayList<OrcStripeMetadata> result = new ArrayList<OrcStripeMetadata>(this.readState.length);
        boolean hasFileId = this.fileKey != null;
        OrcBatchKey stripeKey = hasFileId ? new OrcBatchKey(this.fileKey, 0, 0) : null;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            OrcStripeMetadata value = null;
            int stripeIx = stripeIxMod + this.stripeIxFrom;
            if (hasFileId && this.metadataCache != null) {
                stripeKey.stripeIx = stripeIx;
                value = this.metadataCache.getStripeMetadata(stripeKey);
            }
            if (value == null || !value.hasAllIndexes(globalInc)) {
                this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_MISS);
                this.ensureMetadataReader();
                StripeInformation si = this.fileMetadata.getStripes().get(stripeIx);
                if (value == null) {
                    long startTime = this.counters.startTimeCounter();
                    value = new OrcStripeMetadata(new OrcBatchKey(this.fileKey, stripeIx, 0), this.metadataReader, si, globalInc, sargColumns);
                    this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
                    if (hasFileId && this.metadataCache != null) {
                        value = this.metadataCache.putStripeMetadata(value);
                        if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                            LlapIoImpl.ORC_LOGGER.trace("Caching stripe {} metadata with includes: {}", (Object)stripeKey.stripeIx, (Object)DebugUtils.toString((boolean[])globalInc));
                        }
                    }
                }
                if (!value.hasAllIndexes(globalInc)) {
                    if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.ORC_LOGGER.trace("Updating indexes in stripe {} metadata for includes: {}", (Object)stripeKey.stripeIx, (Object)DebugUtils.toString((boolean[])globalInc));
                    }
                    this.updateLoadedIndexes(value, si, globalInc, sargColumns);
                }
            } else {
                this.counters.incrCounter(LlapIOCounters.METADATA_CACHE_HIT);
            }
            result.add(value);
            this.consumer.setStripeMetadata(value);
        }
        return result;
    }

    private void ensureMetadataReader() throws IOException {
        this.ensureOrcReader();
        if (this.metadataReader != null) {
            return;
        }
        long startTime = this.counters.startTimeCounter();
        boolean useZeroCopy = this.conf != null && OrcConf.USE_ZEROCOPY.getBoolean(this.conf);
        this.metadataReader = RecordReaderUtils.createDefaultDataReader((DataReaderProperties)DataReaderProperties.builder().withBufferSize(this.orcReader.getCompressionSize()).withCompression(this.orcReader.getCompressionKind()).withFileSystem(this.fs).withPath(this.path).withTypeCount(this.orcReader.getSchema().getMaximumId() + 1).withZeroCopy(useZeroCopy).build());
        this.counters.incrTimeCounter(LlapIOCounters.HDFS_TIME_NS, startTime);
    }

    @Override
    public void returnData(Reader.OrcEncodedColumnBatch ecb) {
        for (EncodedColumnBatch.ColumnStreamData[] datas : ecb.getColumnData()) {
            if (datas == null) continue;
            for (EncodedColumnBatch.ColumnStreamData data : datas) {
                if (data == null || data.decRef() != 0) continue;
                if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                    for (MemoryBuffer buf : data.getCacheBuffers()) {
                        LlapIoImpl.LOCKING_LOGGER.trace("Unlocking {} at the end of processing", (Object)buf);
                    }
                }
                this.bufferManager.decRefBuffers(data.getCacheBuffers());
                CSD_POOL.offer((Object)data);
            }
        }
        ECB_POOL.offer((Object)ecb);
    }

    private boolean determineRgsToRead(boolean[] globalIncludes, int rowIndexStride, ArrayList<OrcStripeMetadata> metadata) throws IOException {
        RecordReaderImpl.SargApplier sargApp = null;
        if (this.sarg != null && rowIndexStride != 0) {
            List<OrcProto.Type> types = this.fileMetadata.getTypes();
            String[] colNamesForSarg = OrcInputFormat.getSargColumnNames((String[])this.columnNames, types, (boolean[])globalIncludes, (boolean)this.fileMetadata.isOriginalFormat());
            sargApp = new RecordReaderImpl.SargApplier(this.sarg, colNamesForSarg, (long)rowIndexStride, types, globalIncludes.length);
        }
        boolean hasAnyData = false;
        for (int stripeIxMod = 0; stripeIxMod < this.readState.length; ++stripeIxMod) {
            int stripeIx = stripeIxMod + this.stripeIxFrom;
            StripeInformation stripe = this.fileMetadata.getStripes().get(stripeIx);
            int rgCount = this.getRgCount(stripe, rowIndexStride);
            boolean[] rgsToRead = null;
            if (sargApp != null) {
                OrcStripeMetadata stripeMetadata = metadata.get(stripeIxMod);
                rgsToRead = sargApp.pickRowGroups(stripe, stripeMetadata.getRowIndexes(), stripeMetadata.getBloomFilterIndexes(), true);
            }
            boolean isNone = rgsToRead == RecordReaderImpl.SargApplier.READ_NO_RGS;
            boolean isAll = rgsToRead == RecordReaderImpl.SargApplier.READ_ALL_RGS;
            boolean bl = hasAnyData = hasAnyData || !isNone;
            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                if (isNone) {
                    LlapIoImpl.ORC_LOGGER.trace("SARG eliminated all RGs for stripe {}", (Object)stripeIx);
                } else if (!isAll) {
                    LlapIoImpl.ORC_LOGGER.trace("SARG picked RGs for stripe {}: {}", (Object)stripeIx, (Object)DebugUtils.toString((boolean[])rgsToRead));
                } else {
                    LlapIoImpl.ORC_LOGGER.trace("Will read all {} RGs for stripe {}", (Object)rgCount, (Object)stripeIx);
                }
            }
            assert (isAll || isNone || rgsToRead.length == rgCount);
            this.readState[stripeIxMod] = new boolean[this.columnIds.size()][];
            for (int j = 0; j < this.columnIds.size(); ++j) {
                this.readState[stripeIxMod][j] = isAll || isNone ? rgsToRead : Arrays.copyOf(rgsToRead, rgsToRead.length);
            }
            this.adjustRgMetric(rgCount, rgsToRead, isNone, isAll);
        }
        return hasAnyData;
    }

    private void adjustRgMetric(int rgCount, boolean[] rgsToRead, boolean isNone, boolean isAll) {
        int count = 0;
        if (!isAll) {
            for (boolean b : rgsToRead) {
                if (!b) continue;
                ++count;
            }
        } else if (!isNone) {
            count = rgCount;
        }
        this.counters.incrCounter(LlapIOCounters.SELECTED_ROWGROUPS, count);
    }

    private int getRgCount(StripeInformation stripe, int rowIndexStride) {
        return (int)Math.ceil((double)stripe.getNumberOfRows() / (double)rowIndexStride);
    }

    public void determineStripesToRead() {
        List<StripeInformation> stripes = this.fileMetadata.getStripes();
        long offset = this.split.getStart();
        long maxOffset = offset + this.split.getLength();
        this.stripeIxFrom = -1;
        int stripeIxTo = -1;
        if (LlapIoImpl.ORC_LOGGER.isDebugEnabled()) {
            String tmp = "FileSplit {" + this.split.getStart() + ", " + this.split.getLength() + "}; stripes ";
            for (StripeInformation stripe : stripes) {
                tmp = tmp + "{" + stripe.getOffset() + ", " + stripe.getLength() + "}, ";
            }
            LlapIoImpl.ORC_LOGGER.debug(tmp);
        }
        int stripeIx = 0;
        for (StripeInformation stripe : stripes) {
            long stripeStart = stripe.getOffset();
            if (offset > stripeStart) {
                ++stripeIx;
                continue;
            }
            if (this.stripeIxFrom == -1) {
                LlapIoImpl.ORC_LOGGER.trace("Including stripes from {} ({} >= {})", new Object[]{stripeIx, stripeStart, offset});
                this.stripeIxFrom = stripeIx;
            }
            if (stripeStart >= maxOffset) {
                stripeIxTo = stripeIx;
                LlapIoImpl.ORC_LOGGER.trace("Including stripes until {} ({} >= {}); {} stripes", new Object[]{stripeIxTo, stripeStart, maxOffset, stripeIxTo - this.stripeIxFrom});
                break;
            }
            ++stripeIx;
        }
        if (this.stripeIxFrom == -1) {
            LlapIoImpl.LOG.info("Not including any stripes - empty split");
        }
        if (stripeIxTo == -1 && this.stripeIxFrom != -1) {
            stripeIxTo = stripeIx;
            LlapIoImpl.ORC_LOGGER.trace("Including stripes until {} (end of file); {} stripes", (Object)stripeIx, (Object)(stripeIxTo - this.stripeIxFrom));
        }
        this.readState = new boolean[stripeIxTo - this.stripeIxFrom][][];
    }

    private class DataWrapperForOrc
    implements DataReader,
    DataCache {
        private final DataReader orcDataReader;

        private DataWrapperForOrc(DataWrapperForOrc other) {
            this.orcDataReader = other.orcDataReader.clone();
        }

        public DataWrapperForOrc() throws IOException {
            OrcEncodedDataReader.this.ensureMetadataReader();
            this.orcDataReader = OrcEncodedDataReader.this.metadataReader.clone();
        }

        public DiskRangeList getFileData(Object fileKey, DiskRangeList range, long baseOffset, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
            DiskRangeList result;
            DiskRangeList diskRangeList = result = OrcEncodedDataReader.this.lowLevelCache == null ? range : OrcEncodedDataReader.this.lowLevelCache.getFileData(fileKey, range, baseOffset, factory, OrcEncodedDataReader.this.counters, gotAllData);
            if (gotAllData.value) {
                return result;
            }
            return OrcEncodedDataReader.this.metadataCache == null ? range : OrcEncodedDataReader.this.metadataCache.getIncompleteCbs(fileKey, range, baseOffset, factory, gotAllData);
        }

        public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] data, long baseOffset) {
            if (data != null) {
                return OrcEncodedDataReader.this.lowLevelCache == null ? null : OrcEncodedDataReader.this.lowLevelCache.putFileData(fileKey, ranges, data, baseOffset, LowLevelCache.Priority.NORMAL, OrcEncodedDataReader.this.counters);
            }
            if (OrcEncodedDataReader.this.metadataCache != null) {
                OrcEncodedDataReader.this.metadataCache.putIncompleteCbs(fileKey, ranges, baseOffset);
            }
            return null;
        }

        public void releaseBuffer(MemoryBuffer buffer) {
            OrcEncodedDataReader.this.bufferManager.decRefBuffer(buffer);
        }

        public void reuseBuffer(MemoryBuffer buffer) {
            boolean isReused = OrcEncodedDataReader.this.bufferManager.incRefBuffer(buffer);
            assert (isReused);
        }

        public Allocator getAllocator() {
            return OrcEncodedDataReader.this.bufferManager.getAllocator();
        }

        public void close() throws IOException {
            this.orcDataReader.close();
        }

        public DiskRangeList readFileData(DiskRangeList range, long baseOffset, boolean doForceDirect) throws IOException {
            long startTime = OrcEncodedDataReader.this.counters.startTimeCounter();
            DiskRangeList result = this.orcDataReader.readFileData(range, baseOffset, doForceDirect);
            OrcEncodedDataReader.this.counters.recordHdfsTime(startTime);
            if (LlapIoImpl.ORC_LOGGER.isTraceEnabled()) {
                LlapIoImpl.ORC_LOGGER.trace("Disk ranges after disk read (file {}, base offset {}): {}", new Object[]{OrcEncodedDataReader.this.fileKey, baseOffset, RecordReaderUtils.stringifyDiskRanges((DiskRangeList)result)});
            }
            return result;
        }

        public boolean isTrackingDiskRanges() {
            return this.orcDataReader.isTrackingDiskRanges();
        }

        public void releaseBuffer(ByteBuffer buffer) {
            this.orcDataReader.releaseBuffer(buffer);
        }

        public DataWrapperForOrc clone() {
            return new DataWrapperForOrc(this);
        }

        public void open() throws IOException {
            long startTime = OrcEncodedDataReader.this.counters.startTimeCounter();
            this.orcDataReader.open();
            OrcEncodedDataReader.this.counters.recordHdfsTime(startTime);
        }

        public OrcIndex readRowIndex(StripeInformation stripe, OrcProto.StripeFooter footer, boolean[] included, OrcProto.RowIndex[] indexes, boolean[] sargColumns, OrcProto.BloomFilterIndex[] bloomFilterIndices) throws IOException {
            return this.orcDataReader.readRowIndex(stripe, footer, included, indexes, sargColumns, bloomFilterIndices);
        }

        public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
            return this.orcDataReader.readStripeFooter(stripe);
        }
    }
}

