/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheMemoryManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelFifoCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.SimpleAllocator;
import org.apache.hadoop.hive.llap.cache.SimpleBufferManager;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.metrics2.util.MBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapIoImpl
implements LlapIo<VectorizedRowBatch> {
    public static final Logger LOG = LoggerFactory.getLogger((String)"LlapIoImpl");
    public static final Logger ORC_LOGGER = LoggerFactory.getLogger((String)"LlapIoOrc");
    public static final Logger CACHE_LOGGER = LoggerFactory.getLogger((String)"LlapIoCache");
    public static final Logger LOCKING_LOGGER = LoggerFactory.getLogger((String)"LlapIoLocking");
    private static final String MODE_CACHE = "cache";
    private static final String MODE_ALLOCATOR = "allocator";
    private final ColumnVectorProducer cvp;
    private final ListeningExecutorService executor;
    private LlapDaemonCacheMetrics cacheMetrics;
    private LlapDaemonIOMetrics ioMetrics;
    private ObjectName buddyAllocatorMXBean;
    private Allocator allocator;

    private LlapIoImpl(Configuration conf) throws IOException {
        String ioMode = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MODE);
        boolean useLowLevelCache = MODE_CACHE.equalsIgnoreCase(ioMode);
        boolean useAllocOnly = !useLowLevelCache && MODE_ALLOCATOR.equalsIgnoreCase(ioMode);
        LOG.info("Initializing LLAP IO in {} mode", (Object)ioMode);
        String displayName = "LlapDaemonCacheMetrics-" + MetricsUtils.getHostName();
        String sessionId = conf.get("llap.daemon.metrics.sessionid");
        this.cacheMetrics = LlapDaemonCacheMetrics.create(displayName, sessionId);
        displayName = "LlapDaemonIOMetrics-" + MetricsUtils.getHostName();
        Object[] strIntervals = HiveConf.getTrimmedStringsVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_DECODING_METRICS_PERCENTILE_INTERVALS);
        ArrayList<Integer> intervalList = new ArrayList<Integer>();
        if (strIntervals != null) {
            for (String string : strIntervals) {
                try {
                    intervalList.add(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Ignoring IO decoding metrics interval {} from {} as it is invalid", (Object)string, (Object)Arrays.toString(strIntervals));
                }
            }
        }
        this.ioMetrics = LlapDaemonIOMetrics.create(displayName, sessionId, Ints.toArray(intervalList));
        LOG.info("Started llap daemon metrics with displayName: {} sessionId: {}", (Object)displayName, (Object)sessionId);
        OrcMetadataCache metadataCache = null;
        LowLevelCacheImpl orcCache = null;
        BufferUsageManager bufferManager = null;
        if (useLowLevelCache) {
            boolean bl = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_USE_LRFU);
            LowLevelCachePolicy cachePolicy = bl ? new LowLevelLrfuCachePolicy(conf) : new LowLevelFifoCachePolicy(conf);
            LowLevelCacheMemoryManager memManager = new LowLevelCacheMemoryManager(conf, cachePolicy, this.cacheMetrics);
            BuddyAllocator allocator = new BuddyAllocator(conf, memManager, this.cacheMetrics);
            this.allocator = allocator;
            orcCache = new LowLevelCacheImpl(this.cacheMetrics, cachePolicy, allocator, true);
            boolean useGapCache = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CACHE_ENABLE_ORC_GAP_CACHE);
            metadataCache = new OrcMetadataCache(memManager, cachePolicy, useGapCache);
            cachePolicy.setEvictionListener(new EvictionDispatcher(orcCache, metadataCache));
            cachePolicy.setParentDebugDumper(orcCache);
            orcCache.init();
            bufferManager = orcCache;
        } else {
            if (useAllocOnly) {
                LowLevelCacheMemoryManager lowLevelCacheMemoryManager = new LowLevelCacheMemoryManager(conf, null, this.cacheMetrics);
                this.allocator = new BuddyAllocator(conf, lowLevelCacheMemoryManager, this.cacheMetrics);
            } else {
                this.allocator = new SimpleAllocator(conf);
            }
            bufferManager = new SimpleBufferManager(this.allocator, this.cacheMetrics);
        }
        int n = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE);
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(n, new ThreadFactoryBuilder().setNameFormat("IO-Elevator-Thread-%d").setDaemon(true).build()));
        this.cvp = new OrcColumnVectorProducer(metadataCache, orcCache, bufferManager, conf, this.cacheMetrics, this.ioMetrics);
        LOG.info("LLAP IO initialized");
        this.registerMXBeans();
    }

    private void registerMXBeans() {
        this.buddyAllocatorMXBean = MBeans.register((String)"LlapDaemon", (String)"BuddyAllocatorInfo", (Object)this.allocator);
    }

    public InputFormat<NullWritable, VectorizedRowBatch> getInputFormat(InputFormat sourceInputFormat) {
        return new LlapInputFormat(sourceInputFormat, this.cvp, this.executor);
    }

    public void close() {
        LOG.info("Closing LlapIoImpl..");
        if (this.buddyAllocatorMXBean != null) {
            MBeans.unregister((ObjectName)this.buddyAllocatorMXBean);
            this.buddyAllocatorMXBean = null;
        }
        this.executor.shutdownNow();
    }
}

