/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.Date;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ClusterStatusTracker
extends ZKNodeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterStatusTracker.class);

    public ClusterStatusTracker(ZKWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getZNodePaths().clusterStateZNode, abortable);
    }

    public boolean isClusterUp() {
        return super.getData(false) != null;
    }

    public void setClusterUp() throws KeeperException {
        byte[] upData = ClusterStatusTracker.toByteArray();
        try {
            ZKUtil.createAndWatch(this.watcher, this.watcher.getZNodePaths().clusterStateZNode, upData);
        }
        catch (KeeperException.NodeExistsException nee) {
            ZKUtil.setData(this.watcher, this.watcher.getZNodePaths().clusterStateZNode, upData);
        }
    }

    public void setClusterDown() throws KeeperException {
        try {
            ZKUtil.deleteNode(this.watcher, this.watcher.getZNodePaths().clusterStateZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.warn("Attempted to set cluster as down but already down, cluster state node (" + this.watcher.getZNodePaths().clusterStateZNode + ") not found");
        }
    }

    static byte[] toByteArray() {
        ZooKeeperProtos.ClusterUp.Builder builder = ZooKeeperProtos.ClusterUp.newBuilder();
        builder.setStartDate(new Date().toString());
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }
}

