/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ImmutableSegment
extends Segment {
    public static final long DEEP_OVERHEAD = Segment.DEEP_OVERHEAD + (long)ClassSize.NON_SYNC_TIMERANGE_TRACKER;

    protected abstract boolean canBeFlattened();

    protected ImmutableSegment(CellComparator comparator) {
        super(comparator, TimeRangeTracker.create(TimeRangeTracker.Type.NON_SYNC));
    }

    protected ImmutableSegment(CellSet cs, CellComparator comparator, MemStoreLAB memStoreLAB) {
        super(cs, comparator, memStoreLAB, TimeRangeTracker.create(TimeRangeTracker.Type.NON_SYNC));
    }

    protected ImmutableSegment(Segment segment) {
        super(segment);
    }

    public int getNumOfSegments() {
        return 1;
    }

    public List<Segment> getAllSegments() {
        ArrayList<Segment> res = new ArrayList<Segment>(Arrays.asList(this));
        return res;
    }
}

