/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Predicate;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NamespaceQuotaSnapshotStore
implements QuotaSnapshotStore<String> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rlock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock wlock = this.lock.writeLock();
    private final Connection conn;
    private final QuotaObserverChore chore;
    private Map<RegionInfo, Long> regionUsage;

    public NamespaceQuotaSnapshotStore(Connection conn, QuotaObserverChore chore, Map<RegionInfo, Long> regionUsage) {
        this.conn = Objects.requireNonNull(conn);
        this.chore = Objects.requireNonNull(chore);
        this.regionUsage = Objects.requireNonNull(regionUsage);
    }

    @Override
    public QuotaProtos.SpaceQuota getSpaceQuota(String namespace) throws IOException {
        QuotaProtos.Quotas quotas = this.getQuotaForNamespace(namespace);
        if (quotas != null && quotas.hasSpace()) {
            return quotas.getSpace();
        }
        return null;
    }

    QuotaProtos.Quotas getQuotaForNamespace(String namespace) throws IOException {
        return QuotaTableUtil.getNamespaceQuota((Connection)this.conn, (String)namespace);
    }

    @Override
    public SpaceQuotaSnapshot getCurrentState(String namespace) {
        return this.chore.getNamespaceQuotaSnapshot(namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpaceQuotaSnapshot getTargetState(String subject, QuotaProtos.SpaceQuota spaceQuota) throws IOException {
        this.rlock.lock();
        try {
            long sizeLimitInBytes = spaceQuota.getSoftLimit();
            long sum = 0L;
            for (Map.Entry<RegionInfo, Long> entry : this.filterBySubject(subject)) {
                sum += entry.getValue().longValue();
            }
            SpaceQuotaSnapshot.SpaceQuotaStatus status = (sum += QuotaTableUtil.getNamespaceSnapshotSize((Connection)this.conn, (String)subject)) <= sizeLimitInBytes ? SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation() : new SpaceQuotaSnapshot.SpaceQuotaStatus(ProtobufUtil.toViolationPolicy((QuotaProtos.SpaceViolationPolicy)spaceQuota.getViolationPolicy()));
            SpaceQuotaSnapshot spaceQuotaSnapshot = new SpaceQuotaSnapshot(status, sum, sizeLimitInBytes);
            return spaceQuotaSnapshot;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public Iterable<Map.Entry<RegionInfo, Long>> filterBySubject(final String namespace) {
        this.rlock.lock();
        try {
            Iterable iterable = Iterables.filter(this.regionUsage.entrySet(), (Predicate)new Predicate<Map.Entry<RegionInfo, Long>>(){

                public boolean apply(Map.Entry<RegionInfo, Long> input) {
                    return namespace.equals(input.getKey().getTable().getNamespaceAsString());
                }
            });
            return iterable;
        }
        finally {
            this.rlock.unlock();
        }
    }

    @Override
    public void setCurrentState(String namespace, SpaceQuotaSnapshot snapshot) {
        this.chore.setNamespaceQuotaSnapshot(namespace, snapshot);
    }

    @Override
    public void setRegionUsage(Map<RegionInfo, Long> regionUsage) {
        this.wlock.lock();
        try {
            this.regionUsage = Objects.requireNonNull(regionUsage);
        }
        finally {
            this.wlock.unlock();
        }
    }
}

