/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsSnapshot;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;

@InterfaceAudience.Private
public class RestoreSnapshotHandler
extends TableEventHandler
implements SnapshotSentinel {
    private static final Log LOG = LogFactory.getLog(RestoreSnapshotHandler.class);
    private final HTableDescriptor hTableDescriptor;
    private final HBaseProtos.SnapshotDescription snapshot;
    private final boolean restoreAcl;
    private final ForeignExceptionDispatcher monitor;
    private final MetricsSnapshot metricsSnapshot = new MetricsSnapshot();
    private final MonitoredTask status;
    private volatile boolean stopped = false;

    public RestoreSnapshotHandler(MasterServices masterServices, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor htd, boolean restoreAcl) throws IOException {
        super(EventType.C_M_RESTORE_SNAPSHOT, htd.getTableName(), masterServices, masterServices);
        this.snapshot = snapshot;
        this.restoreAcl = restoreAcl;
        this.monitor = new ForeignExceptionDispatcher();
        this.getTableDescriptor();
        this.hTableDescriptor = htd;
        this.status = TaskMonitor.get().createStatus("Restoring  snapshot '" + snapshot.getName() + "' to table " + this.hTableDescriptor.getTableName());
    }

    @Override
    public RestoreSnapshotHandler prepare() throws IOException {
        return (RestoreSnapshotHandler)super.prepare();
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        MasterFileSystem fileSystemManager = this.masterServices.getMasterFileSystem();
        ClusterConnection conn = this.masterServices.getConnection();
        FileSystem fs = fileSystemManager.getFileSystem();
        Path rootDir = fileSystemManager.getRootDir();
        TableName tableName = this.hTableDescriptor.getTableName();
        try {
            this.masterServices.getTableDescriptors().add(this.hTableDescriptor);
            LOG.debug((Object)("Starting restore snapshot=" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)this.snapshot)));
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, rootDir);
            SnapshotManifest manifest = SnapshotManifest.open(this.masterServices.getConfiguration(), fs, snapshotDir, this.snapshot);
            RestoreSnapshotHelper restoreHelper = new RestoreSnapshotHelper(this.masterServices.getConfiguration(), fs, manifest, this.hTableDescriptor, rootDir, this.monitor, this.status);
            RestoreSnapshotHelper.RestoreMetaChanges metaChanges = restoreHelper.restoreHdfsRegions();
            this.forceRegionsOffline(metaChanges);
            this.status.setStatus("Preparing to restore each region");
            LinkedList<HRegionInfo> hrisToRemove = new LinkedList<HRegionInfo>();
            if (metaChanges.hasRegionsToRemove()) {
                hrisToRemove.addAll(metaChanges.getRegionsToRemove());
            }
            MetaTableAccessor.deleteRegions((Connection)conn, hrisToRemove);
            hris.clear();
            if (metaChanges.hasRegionsToAdd()) {
                hris.addAll(metaChanges.getRegionsToAdd());
            }
            MetaTableAccessor.addRegionsToMeta((Connection)conn, hris, (int)this.hTableDescriptor.getRegionReplication());
            if (metaChanges.hasRegionsToRestore()) {
                MetaTableAccessor.overwriteRegions((Connection)conn, metaChanges.getRegionsToRestore(), (int)this.hTableDescriptor.getRegionReplication());
            }
            metaChanges.updateMetaParentRegions((Connection)this.server.getConnection(), hris);
            if (this.restoreAcl && this.snapshot.hasUsersAndPermissions() && SnapshotDescriptionUtils.isSecurityAvailable(this.server.getConfiguration())) {
                RestoreSnapshotHelper.restoreSnapshotACL(this.snapshot, tableName, this.server.getConfiguration());
            }
            LOG.info((Object)("Restore snapshot=" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)this.snapshot) + " on table=" + tableName + " completed!"));
        }
        catch (IOException e) {
            String msg = "restore snapshot=" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)this.snapshot) + " failed. Try re-running the restore command.";
            LOG.error((Object)msg, (Throwable)e);
            this.monitor.receive(new ForeignException(this.masterServices.getServerName().toString(), e));
            throw new RestoreSnapshotException(msg, (Exception)e);
        }
    }

    private void forceRegionsOffline(RestoreSnapshotHelper.RestoreMetaChanges metaChanges) {
        this.forceRegionsOffline(metaChanges.getRegionsToAdd());
        this.forceRegionsOffline(metaChanges.getRegionsToRestore());
        this.forceRegionsOffline(metaChanges.getRegionsToRemove());
    }

    private void forceRegionsOffline(List<HRegionInfo> hris) {
        AssignmentManager am = this.masterServices.getAssignmentManager();
        RegionStates states = am.getRegionStates();
        if (hris != null) {
            for (HRegionInfo hri : hris) {
                states.regionOffline(hri);
            }
        }
    }

    @Override
    protected void completed(Throwable exception) {
        this.stopped = true;
        if (exception != null) {
            this.status.abort("Restore snapshot '" + this.snapshot.getName() + "' failed because " + exception.getMessage());
        } else {
            this.status.markComplete("Restore snapshot '" + this.snapshot.getName() + "'!");
        }
        this.metricsSnapshot.addSnapshotRestore(this.status.getCompletionTimestamp() - this.status.getStartTime());
        super.completed(exception);
    }

    @Override
    public boolean isFinished() {
        return this.stopped;
    }

    @Override
    public long getCompletionTimestamp() {
        return this.status.getCompletionTimestamp();
    }

    @Override
    public HBaseProtos.SnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void cancel(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        String msg = "Stopping restore snapshot=" + ClientSnapshotDescriptionUtils.toString((HBaseProtos.SnapshotDescription)this.snapshot) + " because: " + why;
        LOG.info((Object)msg);
        CancellationException ce = new CancellationException(why);
        this.monitor.receive(new ForeignException(this.masterServices.getServerName().toString(), ce));
    }

    @Override
    public ForeignException getExceptionIfFailed() {
        return this.monitor.getException();
    }

    @Override
    public void rethrowExceptionIfFailed() throws ForeignException {
        this.monitor.rethrowException();
    }
}

