/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class SimpleTotalOrderPartitioner<VALUE>
extends Partitioner<ImmutableBytesWritable, VALUE>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTotalOrderPartitioner.class);
    @Deprecated
    public static final String START = "hbase.simpletotalorder.start";
    @Deprecated
    public static final String END = "hbase.simpletotalorder.end";
    static final String START_BASE64 = "hbase.simpletotalorder.start.base64";
    static final String END_BASE64 = "hbase.simpletotalorder.end.base64";
    private Configuration c;
    private byte[] startkey;
    private byte[] endkey;
    private byte[][] splits;
    private int lastReduces = -1;

    public static void setStartKey(Configuration conf, byte[] startKey) {
        conf.set(START_BASE64, Base64.encodeBytes((byte[])startKey));
    }

    public static void setEndKey(Configuration conf, byte[] endKey) {
        conf.set(END_BASE64, Base64.encodeBytes((byte[])endKey));
    }

    static byte[] getStartKey(Configuration conf) {
        return SimpleTotalOrderPartitioner.getKeyFromConf(conf, START_BASE64, START);
    }

    static byte[] getEndKey(Configuration conf) {
        return SimpleTotalOrderPartitioner.getKeyFromConf(conf, END_BASE64, END);
    }

    private static byte[] getKeyFromConf(Configuration conf, String base64Key, String deprecatedKey) {
        String encoded = conf.get(base64Key);
        if (encoded != null) {
            return Base64.decode((String)encoded);
        }
        String oldStyleVal = conf.get(deprecatedKey);
        if (oldStyleVal == null) {
            return null;
        }
        LOG.warn("Using deprecated configuration " + deprecatedKey + " - please use static accessor methods instead.");
        return Bytes.toBytesBinary((String)oldStyleVal);
    }

    public int getPartition(ImmutableBytesWritable key, VALUE value, int reduces) {
        int pos;
        if (reduces == 1) {
            return 0;
        }
        if (this.lastReduces != reduces) {
            this.splits = Bytes.split((byte[])this.startkey, (byte[])this.endkey, (int)(reduces - 1));
            for (int i = 0; i < this.splits.length; ++i) {
                LOG.info(Bytes.toStringBinary((byte[])this.splits[i]));
            }
            this.lastReduces = reduces;
        }
        if ((pos = Bytes.binarySearch((byte[][])this.splits, (byte[])key.get(), (int)key.getOffset(), (int)key.getLength())) < 0) {
            ++pos;
            if ((pos *= -1) == 0) {
                throw new RuntimeException("Key outside start/stop range: " + key.toString());
            }
            --pos;
        }
        return pos;
    }

    public Configuration getConf() {
        return this.c;
    }

    public void setConf(Configuration conf) {
        this.c = conf;
        this.startkey = SimpleTotalOrderPartitioner.getStartKey(conf);
        this.endkey = SimpleTotalOrderPartitioner.getEndKey(conf);
        if (this.startkey == null || this.endkey == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass() + " not configured");
        }
        LOG.info("startkey=" + Bytes.toStringBinary((byte[])this.startkey) + ", endkey=" + Bytes.toStringBinary((byte[])this.endkey));
        this.lastReduces = -1;
    }
}

