/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.aes;

import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AESDecryptor
implements Decryptor {
    private Cipher cipher;
    private Key key;
    private byte[] iv;
    private boolean initialized = false;

    public AESDecryptor(Cipher cipher) {
        this.cipher = cipher;
    }

    Cipher getCipher() {
        return this.cipher;
    }

    @Override
    public void setKey(Key key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        this.key = key;
    }

    @Override
    public int getIvLength() {
        return 16;
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void setIv(byte[] iv) {
        Preconditions.checkNotNull((Object)iv, (Object)"IV cannot be null");
        Preconditions.checkArgument((iv.length == 16 ? 1 : 0) != 0, (Object)"Invalid IV length");
        this.iv = iv;
    }

    @Override
    public InputStream createDecryptionStream(InputStream in) {
        if (!this.initialized) {
            this.init();
        }
        return new CipherInputStream(in, this.cipher);
    }

    @Override
    public void reset() {
        this.init();
    }

    protected void init() {
        try {
            if (this.iv == null) {
                throw new NullPointerException("IV is null");
            }
            this.cipher.init(2, this.key, new IvParameterSpec(this.iv));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }
}

