/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacitySchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.PlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchedulerPlanFollower
implements PlanFollower {
    private static final Logger LOG = LoggerFactory.getLogger(CapacitySchedulerPlanFollower.class);
    protected Collection<Plan> plans = new ArrayList<Plan>();
    protected YarnScheduler scheduler;
    protected Clock clock;

    @Override
    public void init(Clock clock, ResourceScheduler sched, Collection<Plan> plans) {
        this.clock = clock;
        this.scheduler = sched;
        this.plans.addAll(plans);
    }

    @Override
    public synchronized void run() {
        for (Plan plan : this.plans) {
            this.synchronizePlan(plan);
        }
    }

    @Override
    public synchronized void setPlans(Collection<Plan> plans) {
        this.plans.clear();
        this.plans.addAll(plans);
    }

    @Override
    public synchronized void synchronizePlan(Plan plan) {
        Queue planQueue;
        String planQueueName = plan.getQueueName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running plan follower edit policy for plan: " + planQueueName);
        }
        long step = plan.getStep();
        long now = this.clock.getTime();
        if (now % step != 0L) {
            now += step - now % step;
        }
        if ((planQueue = this.getPlanQueue(planQueueName)) == null) {
            return;
        }
        Resource clusterResources = this.scheduler.getClusterResource();
        Resource planResources = this.getPlanResources(plan, planQueue, clusterResources);
        Set<ReservationAllocation> currentReservations = plan.getReservationsAtTime(now);
        HashSet<String> curReservationNames = new HashSet<String>();
        Resource reservedResources = Resource.newInstance((int)0, (int)0);
        int numRes = this.getReservedResources(now, currentReservations, curReservationNames, reservedResources);
        String defReservationId = this.getReservationIdFromQueueName(planQueueName) + "-default";
        String defReservationQueue = this.getReservationQueueName(planQueueName, defReservationId);
        this.createDefaultReservationQueue(planQueueName, planQueue, defReservationId);
        curReservationNames.add(defReservationId);
        if (this.arePlanResourcesLessThanReservations(clusterResources, planResources, reservedResources)) {
            try {
                plan.getReplanner().plan(plan, null);
            }
            catch (PlanningException e) {
                LOG.warn("Exception while trying to replan: {}", (Object)planQueueName, (Object)e);
            }
        }
        List<? extends Queue> resQueues = this.getChildReservationQueues(planQueue);
        HashSet<String> expired = new HashSet<String>();
        for (Queue queue : resQueues) {
            String resQueueName = queue.getQueueName();
            String reservationId = this.getReservationIdFromQueueName(resQueueName);
            if (curReservationNames.contains(reservationId)) {
                curReservationNames.remove(reservationId);
                continue;
            }
            expired.add(reservationId);
        }
        this.cleanupExpiredQueues(planQueueName, plan.getMoveOnExpiry(), expired, defReservationQueue);
        float totalAssignedCapacity = 0.0f;
        if (currentReservations != null) {
            try {
                this.setQueueEntitlement(planQueueName, defReservationQueue, 0.0f, 1.0f);
            }
            catch (YarnException yarnException) {
                LOG.warn("Exception while trying to release default queue capacity for plan: {}", (Object)planQueueName, (Object)yarnException);
            }
            List<ReservationAllocation> list = this.sortByDelta(new ArrayList<ReservationAllocation>(currentReservations), now, plan);
            for (ReservationAllocation res : list) {
                String currResId = res.getReservationId().toString();
                if (curReservationNames.contains(currResId)) {
                    this.addReservationQueue(planQueueName, planQueue, currResId);
                }
                Resource capToAssign = res.getResourcesAtTime(now);
                float targetCapacity = 0.0f;
                if (planResources.getMemory() > 0 && planResources.getVirtualCores() > 0) {
                    targetCapacity = this.calculateReservationToPlanRatio(clusterResources, planResources, capToAssign);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Assigning capacity of {} to queue {} with target capacity {}", new Object[]{capToAssign, currResId, Float.valueOf(targetCapacity)});
                }
                float maxCapacity = 1.0f;
                if (res.containsGangs()) {
                    maxCapacity = targetCapacity;
                }
                try {
                    this.setQueueEntitlement(planQueueName, currResId, targetCapacity, maxCapacity);
                }
                catch (YarnException e) {
                    LOG.warn("Exception while trying to size reservation for plan: {}", new Object[]{currResId, planQueueName, e});
                }
                totalAssignedCapacity += targetCapacity;
            }
        }
        float f = 1.0f - totalAssignedCapacity;
        if (LOG.isDebugEnabled()) {
            LOG.debug("PlanFollowerEditPolicyTask: total Plan Capacity: {} currReservation: {} default-queue capacity: {}", new Object[]{planResources, numRes, Float.valueOf(f)});
        }
        try {
            this.setQueueEntitlement(planQueueName, defReservationQueue, f, 1.0f);
        }
        catch (YarnException e) {
            LOG.warn("Exception while trying to reclaim default queue capacity for plan: {}", (Object)planQueueName, (Object)e);
        }
        try {
            plan.archiveCompletedReservations(now);
        }
        catch (PlanningException e) {
            LOG.error("Exception in archiving completed reservations: ", (Throwable)e);
        }
        LOG.info("Finished iteration of plan follower edit policy for plan: " + planQueueName);
    }

    protected String getReservationIdFromQueueName(String resQueueName) {
        return resQueueName;
    }

    protected void setQueueEntitlement(String planQueueName, String currResId, float targetCapacity, float maxCapacity) throws YarnException {
        String reservationQueueName = this.getReservationQueueName(planQueueName, currResId);
        this.scheduler.setEntitlement(reservationQueueName, new QueueEntitlement(targetCapacity, maxCapacity));
    }

    protected String getReservationQueueName(String planQueueName, String reservationId) {
        return reservationId;
    }

    protected void cleanupExpiredQueues(String planQueueName, boolean shouldMove, Set<String> toRemove, String defReservationQueue) {
        for (String expiredReservationId : toRemove) {
            try {
                String expiredReservation = this.getReservationQueueName(planQueueName, expiredReservationId);
                this.setQueueEntitlement(planQueueName, expiredReservation, 0.0f, 0.0f);
                if (shouldMove) {
                    this.moveAppsInQueueSync(expiredReservation, defReservationQueue);
                }
                if (this.scheduler.getAppsInQueue(expiredReservation).size() > 0) {
                    this.scheduler.killAllAppsInQueue(expiredReservation);
                    LOG.info("Killing applications in queue: {}", (Object)expiredReservation);
                    continue;
                }
                this.scheduler.removeQueue(expiredReservation);
                LOG.info("Queue: " + expiredReservation + " removed");
            }
            catch (YarnException e) {
                LOG.warn("Exception while trying to expire reservation: {}", (Object)expiredReservationId, (Object)e);
            }
        }
    }

    private void moveAppsInQueueSync(String expiredReservation, String defReservationQueue) {
        List<ApplicationAttemptId> activeApps = this.scheduler.getAppsInQueue(expiredReservation);
        if (activeApps.isEmpty()) {
            return;
        }
        for (ApplicationAttemptId app : activeApps) {
            try {
                this.scheduler.moveApplication(app.getApplicationId(), defReservationQueue);
            }
            catch (YarnException e) {
                LOG.warn("Encountered unexpected error during migration of application: {} from reservation: {}", new Object[]{app, expiredReservation, e});
            }
        }
    }

    protected int getReservedResources(long now, Set<ReservationAllocation> currentReservations, Set<String> curReservationNames, Resource reservedResources) {
        int numRes = 0;
        if (currentReservations != null) {
            numRes = currentReservations.size();
            for (ReservationAllocation reservation : currentReservations) {
                curReservationNames.add(reservation.getReservationId().toString());
                Resources.addTo((Resource)reservedResources, (Resource)reservation.getResourcesAtTime(now));
            }
        }
        return numRes;
    }

    protected List<ReservationAllocation> sortByDelta(List<ReservationAllocation> currentReservations, long now, Plan plan) {
        Collections.sort(currentReservations, new ReservationAllocationComparator(now, this, plan));
        return currentReservations;
    }

    protected abstract Queue getPlanQueue(String var1);

    protected abstract float calculateReservationToPlanRatio(Resource var1, Resource var2, Resource var3);

    protected abstract boolean arePlanResourcesLessThanReservations(Resource var1, Resource var2, Resource var3);

    protected abstract List<? extends Queue> getChildReservationQueues(Queue var1);

    protected abstract void addReservationQueue(String var1, Queue var2, String var3);

    protected abstract void createDefaultReservationQueue(String var1, Queue var2, String var3);

    protected abstract Resource getPlanResources(Plan var1, Queue var2, Resource var3);

    protected abstract Resource getReservationQueueResourceIfExists(Plan var1, ReservationId var2);

    private static class ReservationAllocationComparator
    implements Comparator<ReservationAllocation> {
        AbstractSchedulerPlanFollower planFollower;
        long now;
        Plan plan;

        ReservationAllocationComparator(long now, AbstractSchedulerPlanFollower planFollower, Plan plan) {
            this.now = now;
            this.planFollower = planFollower;
            this.plan = plan;
        }

        private Resource getUnallocatedReservedResources(ReservationAllocation reservation) {
            Resource reservationResource = this.planFollower.getReservationQueueResourceIfExists(this.plan, reservation.getReservationId());
            Resource resResource = reservationResource != null ? Resources.subtract((Resource)reservation.getResourcesAtTime(this.now), (Resource)reservationResource) : reservation.getResourcesAtTime(this.now);
            return resResource;
        }

        @Override
        public int compare(ReservationAllocation lhs, ReservationAllocation rhs) {
            Resource lhsRes = this.getUnallocatedReservedResources(lhs);
            Resource rhsRes = this.getUnallocatedReservedResources(rhs);
            return lhsRes.compareTo((Object)rhsRes);
        }
    }
}

