/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.lib;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZKClient {
    private ZooKeeper zkClient;

    public ZKClient(String string) throws IOException {
        this.zkClient = new ZooKeeper(string, 30000, (Watcher)new ZKWatcher());
    }

    public void registerService(String path, String data) throws IOException, InterruptedException {
        try {
            this.zkClient.create(path, data.getBytes(Charset.forName("UTF-8")), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException ke) {
            throw new IOException(ke);
        }
    }

    public void unregisterService(String path) throws IOException, InterruptedException {
        try {
            this.zkClient.delete(path, -1);
        }
        catch (KeeperException ke) {
            throw new IOException(ke);
        }
    }

    public List<String> listServices(String path) throws IOException, InterruptedException {
        List children = null;
        try {
            children = this.zkClient.getChildren(path, false);
        }
        catch (KeeperException ke) {
            throw new IOException(ke);
        }
        return children;
    }

    public String getServiceData(String path) throws IOException, InterruptedException {
        String data;
        try {
            Stat stat = new Stat();
            byte[] byteData = this.zkClient.getData(path, false, stat);
            data = new String(byteData, Charset.forName("UTF-8"));
        }
        catch (KeeperException ke) {
            throw new IOException(ke);
        }
        return data;
    }

    private static class ZKWatcher
    implements Watcher {
        private ZKWatcher() {
        }

        public void process(WatchedEvent arg0) {
        }
    }
}

