/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import java.io.IOException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Invoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipartUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartUtils.class);

    private MultipartUtils() {
    }

    static UploadIterator listMultipartUploads(AmazonS3 s3, Invoker invoker, String bucketName, int maxKeys, @Nullable String prefix) throws IOException {
        return new UploadIterator(s3, invoker, bucketName, maxKeys, prefix);
    }

    public static class UploadIterator
    implements RemoteIterator<MultipartUpload> {
        private ListingIterator lister;
        private MultipartUploadListing listing;
        private ListIterator<MultipartUpload> batchIterator;

        public UploadIterator(AmazonS3 s3, Invoker invoker, String bucketName, int maxKeys, @Nullable String prefix) throws IOException {
            this.lister = new ListingIterator(s3, invoker, bucketName, maxKeys, prefix);
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            return this.batchIterator.hasNext() || this.requestNextBatch();
        }

        public MultipartUpload next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.batchIterator.next();
        }

        private boolean requestNextBatch() throws IOException {
            if (this.lister.hasNext()) {
                this.listing = this.lister.next();
                this.batchIterator = this.listing.getMultipartUploads().listIterator();
                return this.batchIterator.hasNext();
            }
            return false;
        }
    }

    static class ListingIterator
    implements RemoteIterator<MultipartUploadListing> {
        private final String bucketName;
        private final String prefix;
        private final int maxKeys;
        private final AmazonS3 s3;
        private final Invoker invoker;
        private MultipartUploadListing listing;
        private boolean firstListing = true;
        private int listCount = 1;

        ListingIterator(AmazonS3 s3, Invoker invoker, String bucketName, int maxKeys, @Nullable String prefix) throws IOException {
            this.s3 = s3;
            this.bucketName = bucketName;
            this.maxKeys = maxKeys;
            this.prefix = prefix;
            this.invoker = invoker;
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            if (this.listing == null) {
                return false;
            }
            return this.firstListing || this.listing.isTruncated();
        }

        public MultipartUploadListing next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
            } else {
                if (this.listing == null || !this.listing.isTruncated()) {
                    throw new NoSuchElementException("No more uploads under " + this.prefix);
                }
                this.requestNextBatch();
            }
            return this.listing;
        }

        public String toString() {
            return "Upload iterator: prefix " + this.prefix + "; list count " + this.listCount + "; isTruncated=" + this.listing.isTruncated();
        }

        private void requestNextBatch() throws IOException {
            ListMultipartUploadsRequest req = new ListMultipartUploadsRequest(this.bucketName);
            if (this.prefix != null) {
                req.setPrefix(this.prefix);
            }
            if (!this.firstListing) {
                req.setKeyMarker(this.listing.getNextKeyMarker());
                req.setUploadIdMarker(this.listing.getNextUploadIdMarker());
            }
            req.setMaxUploads(Integer.valueOf(this.listCount));
            LOG.debug("[{}], Requesting next {} uploads prefix {}, next key {}, next upload id {}", new Object[]{this.listCount, this.maxKeys, this.prefix, req.getKeyMarker(), req.getUploadIdMarker()});
            ++this.listCount;
            this.listing = this.invoker.retry("listMultipartUploads", this.prefix, true, () -> this.s3.listMultipartUploads(req));
            LOG.debug("New listing state: {}", (Object)this);
        }
    }
}

