/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.InconsistentAmazonS3Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureInjectionPolicy {
    public static final String DEFAULT_DELAY_KEY_SUBSTRING = "DELAY_LISTING_ME";
    public static final long DEFAULT_DELAY_KEY_MSEC = 5000L;
    public static final float DEFAULT_DELAY_KEY_PROBABILITY = 1.0f;
    public static final String MATCH_ALL_KEYS = "*";
    private static final Logger LOG = LoggerFactory.getLogger(InconsistentAmazonS3Client.class);
    private String delayKeySubstring;
    private float delayKeyProbability;
    private long delayKeyMsec;
    private float throttleProbability;
    private int failureLimit = 0;

    public FailureInjectionPolicy(Configuration conf) {
        this.delayKeySubstring = conf.get("fs.s3a.failinject.inconsistency.key.substring", DEFAULT_DELAY_KEY_SUBSTRING);
        if (this.delayKeySubstring.equals(MATCH_ALL_KEYS)) {
            this.delayKeySubstring = "";
        }
        this.delayKeyProbability = FailureInjectionPolicy.validProbability(conf.getFloat("fs.s3a.failinject.inconsistency.probability", 1.0f));
        this.delayKeyMsec = conf.getLong("fs.s3a.failinject.inconsistency.msec", 5000L);
        this.setThrottleProbability(conf.getFloat("fs.s3a.failinject.throttle.probability", 0.0f));
    }

    public String getDelayKeySubstring() {
        return this.delayKeySubstring;
    }

    public float getDelayKeyProbability() {
        return this.delayKeyProbability;
    }

    public long getDelayKeyMsec() {
        return this.delayKeyMsec;
    }

    public float getThrottleProbability() {
        return this.throttleProbability;
    }

    public int getFailureLimit() {
        return this.failureLimit;
    }

    public void setFailureLimit(int failureLimit) {
        this.failureLimit = failureLimit;
    }

    public void setThrottleProbability(float throttleProbability) {
        this.throttleProbability = FailureInjectionPolicy.validProbability(throttleProbability);
    }

    public static boolean trueWithProbability(float p) {
        return Math.random() < (double)p;
    }

    public boolean shouldDelay(String key) {
        float p = this.getDelayKeyProbability();
        boolean delay = key.contains(this.getDelayKeySubstring());
        delay = delay && FailureInjectionPolicy.trueWithProbability(p);
        LOG.debug("{}, p={} -> {}", new Object[]{key, Float.valueOf(p), delay});
        return delay;
    }

    public String toString() {
        return String.format("FailureInjectionPolicy: %s msec delay, substring %s, delay probability %s; throttle probability %s; failure limit %d", this.delayKeyMsec, this.delayKeySubstring, Float.valueOf(this.delayKeyProbability), Float.valueOf(this.throttleProbability), this.failureLimit);
    }

    private static float validProbability(float p) {
        Preconditions.checkArgument((p >= 0.0f && p <= 1.0f ? 1 : 0) != 0, (String)"Probability out of range 0 to 1 %s", (Object)Float.valueOf(p));
        return p;
    }
}

