/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSInputStream;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSOutputStream;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;
import org.apache.hadoop.fs.aliyun.oss.FileStatusAcceptor;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AliyunOSSFileSystem.class);
    private URI uri;
    private String bucket;
    private Path workingDir;
    private AliyunOSSFileSystemStore store;
    private int maxKeys;
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }
    };

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Append is not supported!");
    }

    public void close() throws IOException {
        try {
            this.store.close();
        }
        finally {
            super.close();
        }
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        String key = this.pathToKey(path);
        FileStatus status = null;
        try {
            status = this.getFileStatus(path);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(path + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(path + " already exists");
            }
            LOG.debug("Overwriting file {}", (Object)path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return new FSDataOutputStream((OutputStream)new AliyunOSSOutputStream(this.getConf(), this.store, key, progress, this.statistics), (FileSystem.Statistics)null);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !this.getFileStatus(parent).isDirectory()) {
            throw new FileAlreadyExistsException("Not a directory: " + parent);
        }
        return this.create(path, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            return this.innerDelete(this.getFileStatus(path), recursive);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Couldn't delete {} - does not exist", (Object)path);
            return false;
        }
    }

    private boolean innerDelete(FileStatus status, boolean recursive) throws IOException {
        Path f = status.getPath();
        String p = f.toUri().getPath();
        if (p.equals("/")) {
            FileStatus[] statuses = this.listStatus(status.getPath());
            boolean isEmptyDir = statuses.length <= 0;
            return this.rejectRootDirectoryDelete(isEmptyDir, recursive);
        }
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            if (!recursive) {
                FileStatus[] statuses = this.listStatus(status.getPath());
                if (statuses.length > 0) {
                    throw new IOException("Cannot remove directory " + f + ": It is not empty!");
                }
                key = AliyunOSSUtils.maybeAddTrailingSlash(key);
                this.store.deleteObject(key);
            } else {
                this.store.deleteDirs(key);
            }
        } else {
            this.store.deleteObject(key);
        }
        this.createFakeDirectoryIfNecessary(f);
        return true;
    }

    private boolean rejectRootDirectoryDelete(boolean isEmptyDir, boolean recursive) throws IOException {
        LOG.info("oss delete the {} root directory of {}", (Object)this.bucket, (Object)recursive);
        if (isEmptyDir) {
            return true;
        }
        if (recursive) {
            return false;
        }
        throw new PathIOException(this.bucket, "Cannot delete root path");
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException {
        String key = this.pathToKey(f);
        if (StringUtils.isNotEmpty((String)key) && !this.exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.mkdir(this.pathToKey(f.getParent()));
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        Path qualifiedPath = path.makeQualified(this.uri, this.workingDir);
        String key = this.pathToKey(qualifiedPath);
        if (key.length() == 0) {
            return new FileStatus(0L, true, 1, 0L, 0L, qualifiedPath);
        }
        ObjectMetadata meta = this.store.getObjectMetadata(key);
        if (meta == null && !key.endsWith("/")) {
            key = key + "/";
            meta = this.store.getObjectMetadata(key);
        }
        if (meta == null) {
            ObjectListing listing = this.store.listObjects(key, 1, null, false);
            if (CollectionUtils.isNotEmpty((Collection)listing.getObjectSummaries()) || CollectionUtils.isNotEmpty((Collection)listing.getCommonPrefixes())) {
                return new FileStatus(0L, true, 1, 0L, 0L, qualifiedPath);
            }
            throw new FileNotFoundException(path + ": No such file or directory!");
        }
        if (AliyunOSSUtils.objectRepresentsDirectory(key, meta.getContentLength())) {
            return new FileStatus(0L, true, 1, 0L, meta.getLastModified().getTime(), qualifiedPath);
        }
        return new FileStatus(meta.getContentLength(), false, 1, this.getDefaultBlockSize(path), meta.getLastModified().getTime(), qualifiedPath);
    }

    public String getScheme() {
        return "oss";
    }

    public URI getUri() {
        return this.uri;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Deprecated
    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.oss.block.size", 0x4000000L);
    }

    public String getCanonicalServiceName() {
        return null;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.bucket = name.getHost();
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, null);
        this.store = new AliyunOSSFileSystemStore();
        this.store.initialize(name, conf, this.statistics);
        this.maxKeys = conf.getInt("fs.oss.paging.maximum", 1000);
        this.setConf(conf);
    }

    private String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        return path.toUri().getPath().substring(1);
    }

    private Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        String key = this.pathToKey(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("List status for path: " + path);
        }
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        FileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("listStatus: doing listObjects for directory " + key);
            }
            ObjectListing objects = this.store.listObjects(key, this.maxKeys, null, false);
            while (true) {
                this.statistics.incrementReadOps(1);
                for (OSSObjectSummary objectSummary : objects.getObjectSummaries()) {
                    String objKey = objectSummary.getKey();
                    if (objKey.equals(key + "/")) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring: " + objKey);
                        continue;
                    }
                    Path keyPath = this.keyToPath(objectSummary.getKey()).makeQualified(this.uri, this.workingDir);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding: fi: " + keyPath);
                    }
                    result.add(new FileStatus(objectSummary.getSize(), false, 1, this.getDefaultBlockSize(keyPath), objectSummary.getLastModified().getTime(), keyPath));
                }
                for (String prefix : objects.getCommonPrefixes()) {
                    if (prefix.equals(key + "/")) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring: " + prefix);
                        continue;
                    }
                    Path keyPath = this.keyToPath(prefix).makeQualified(this.uri, this.workingDir);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding: rd: " + keyPath);
                    }
                    result.add(this.getFileStatus(keyPath));
                }
                if (objects.isTruncated()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("listStatus: list truncated - getting next batch");
                    }
                    String nextMarker = objects.getNextMarker();
                    objects = this.store.listObjects(key, this.maxKeys, nextMarker, false);
                    this.statistics.incrementReadOps(1);
                    continue;
                }
                break;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding: rd (not a dir): " + path);
            }
            result.add(fileStatus);
        }
        return result.toArray(new FileStatus[result.size()]);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(final Path f, boolean recursive) throws IOException {
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        final FileStatus status = this.getFileStatus(qualifiedPath);
        PathFilter filter = new PathFilter(){

            public boolean accept(Path path) {
                return status.isFile() || !path.equals((Object)f);
            }
        };
        FileStatusAcceptor.AcceptFilesOnly acceptor = new FileStatusAcceptor.AcceptFilesOnly(qualifiedPath);
        return this.innerList(f, status, filter, acceptor, recursive);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        return this.listLocatedStatus(f, DEFAULT_FILTER);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws IOException {
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        FileStatus status = this.getFileStatus(qualifiedPath);
        FileStatusAcceptor.AcceptAllButSelf acceptor = new FileStatusAcceptor.AcceptAllButSelf(qualifiedPath);
        return this.innerList(f, status, filter, acceptor, false);
    }

    private RemoteIterator<LocatedFileStatus> innerList(Path f, FileStatus status, PathFilter filter, FileStatusAcceptor acceptor, boolean recursive) throws IOException {
        Path qualifiedPath = f.makeQualified(this.uri, this.workingDir);
        String key = this.pathToKey(qualifiedPath);
        if (status.isFile()) {
            LOG.debug("{} is a File", (Object)qualifiedPath);
            BlockLocation[] locations = this.getFileBlockLocations(status, 0L, status.getLen());
            return this.store.singleStatusRemoteIterator((FileStatus)(filter.accept(f) ? status : null), locations);
        }
        return this.store.createLocatedFileStatusIterator(key, this.maxKeys, this, filter, acceptor, recursive ? null : "/");
    }

    private boolean mkdir(String key) throws IOException {
        String dirName = key;
        if (StringUtils.isNotEmpty((String)key)) {
            if (!key.endsWith("/")) {
                dirName = dirName + "/";
            }
            this.store.storeEmptyFile(dirName);
        }
        return true;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(path);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + path);
        }
        catch (FileNotFoundException e) {
            this.validatePath(path);
            String key = this.pathToKey(path);
            return this.mkdir(key);
        }
    }

    private void validatePath(Path path) throws IOException {
        Path fPart = path.getParent();
        while (true) {
            try {
                FileStatus fileStatus = this.getFileStatus(fPart);
                if (!fileStatus.isDirectory()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s', it is a file.", fPart));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if ((fPart = fPart.getParent()) != null) continue;
            }
            break;
        }
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        FileStatus fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("Can't open " + path + " because it is a directory");
        }
        return new FSDataInputStream((InputStream)((Object)new AliyunOSSInputStream(this.getConf(), this.store, this.pathToKey(path), fileStatus.getLen(), this.statistics)));
    }

    public boolean rename(Path srcPath, Path dstPath) throws IOException {
        FileStatus dstStatus;
        Path parent;
        if (srcPath.isRoot()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot rename the root of a filesystem");
            }
            return false;
        }
        for (parent = dstPath.getParent(); parent != null && !srcPath.equals((Object)parent); parent = parent.getParent()) {
        }
        if (parent != null) {
            return false;
        }
        FileStatus srcStatus = this.getFileStatus(srcPath);
        try {
            dstStatus = this.getFileStatus(dstPath);
        }
        catch (FileNotFoundException fnde) {
            dstStatus = null;
        }
        if (dstStatus == null) {
            dstStatus = this.getFileStatus(dstPath.getParent());
            if (!dstStatus.isDirectory()) {
                throw new IOException(String.format("Failed to rename %s to %s, %s is a file", srcPath, dstPath, dstPath.getParent()));
            }
        } else {
            if (srcStatus.getPath().equals((Object)dstStatus.getPath())) {
                return !srcStatus.isDirectory();
            }
            if (dstStatus.isDirectory()) {
                FileStatus[] statuses;
                dstPath = new Path(dstPath, srcPath.getName());
                try {
                    statuses = this.listStatus(dstPath);
                }
                catch (FileNotFoundException fnde) {
                    statuses = null;
                }
                if (statuses != null && statuses.length > 0) {
                    throw new FileAlreadyExistsException(String.format("Failed to rename %s to %s, file already exists or not empty!", srcPath, dstPath));
                }
            } else {
                throw new FileAlreadyExistsException(String.format("Failed to rename %s to %s, file already exists!", srcPath, dstPath));
            }
        }
        if (srcStatus.isDirectory()) {
            this.copyDirectory(srcPath, dstPath);
        } else {
            this.copyFile(srcPath, dstPath);
        }
        return srcPath.equals((Object)dstPath) || this.delete(srcPath, true);
    }

    private boolean copyFile(Path srcPath, Path dstPath) {
        String srcKey = this.pathToKey(srcPath);
        String dstKey = this.pathToKey(dstPath);
        return this.store.copyFile(srcKey, dstKey);
    }

    private boolean copyDirectory(Path srcPath, Path dstPath) throws IOException {
        String srcKey = AliyunOSSUtils.maybeAddTrailingSlash(this.pathToKey(srcPath));
        String dstKey = AliyunOSSUtils.maybeAddTrailingSlash(this.pathToKey(dstPath));
        if (dstKey.startsWith(srcKey)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot rename a directory to a subdirectory of self");
            }
            return false;
        }
        this.store.storeEmptyFile(dstKey);
        ObjectListing objects = this.store.listObjects(srcKey, this.maxKeys, null, true);
        this.statistics.incrementReadOps(1);
        while (true) {
            for (OSSObjectSummary objectSummary : objects.getObjectSummaries()) {
                String newKey = dstKey.concat(objectSummary.getKey().substring(srcKey.length()));
                this.store.copyFile(objectSummary.getKey(), newKey);
            }
            if (!objects.isTruncated()) break;
            String nextMarker = objects.getNextMarker();
            objects = this.store.listObjects(srcKey, this.maxKeys, nextMarker, true);
            this.statistics.incrementReadOps(1);
        }
        return true;
    }

    public void setWorkingDirectory(Path dir) {
        this.workingDir = dir;
    }

    public AliyunOSSFileSystemStore getStore() {
        return this.store;
    }
}

