/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.geode.distributed.internal.tcpserver.ClusterSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.ConnectionWatcher;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;

public class ClusterSocketCreatorImpl
implements ClusterSocketCreator {
    private final TcpSocketCreatorImpl socketCreator;

    protected ClusterSocketCreatorImpl(TcpSocketCreatorImpl socketCreator) {
        this.socketCreator = socketCreator;
    }

    @Override
    public boolean useSSL() {
        return this.socketCreator.useSSL();
    }

    @Override
    public void handshakeIfSocketIsSSL(Socket socket, int timeout) throws IOException {
        if (this.useSSL()) {
            throw new IllegalStateException("Handshake on SSL connections is not supported");
        }
    }

    @Override
    public final ServerSocket createServerSocket(int nport, int backlog) throws IOException {
        return this.createServerSocket(nport, backlog, null, -1, this.useSSL());
    }

    @Override
    public final ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr) throws IOException {
        return this.createServerSocket(nport, backlog, bindAddr, -1, this.useSSL());
    }

    protected ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, int socketBufferSize, boolean sslConnection) throws IOException {
        if (sslConnection) {
            throw new UnsupportedOperationException();
        }
        ServerSocket result = new ServerSocket();
        result.setReuseAddress(true);
        if (socketBufferSize != -1) {
            result.setReceiveBufferSize(socketBufferSize);
        }
        try {
            result.bind(new InetSocketAddress(bindAddr, nport), backlog);
        }
        catch (BindException e) {
            BindException throwMe = new BindException(String.format("Failed to create server socket on %s[%s]", bindAddr == null ? InetAddress.getLocalHost().getHostAddress() : bindAddr, nport));
            throwMe.initCause(e);
            throw throwMe;
        }
        return result;
    }

    @Override
    public Socket connect(HostAndPort addr) throws IOException {
        return this.socketCreator.connect(addr, 0, null, false, -1);
    }

    @Override
    public final Socket connect(HostAndPort addr, int timeout, ConnectionWatcher optionalWatcher, TcpSocketFactory socketFactory) throws IOException {
        return this.socketCreator.advancedSocketCreator.connect(addr, timeout, optionalWatcher, false, -1, this.useSSL(), socketFactory);
    }
}

