/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 6148230381293590639L;
    private final int cacheSize;
    private final RemovalListener<K, V> removalListener;

    public LRUMap(int cacheSize) {
        this(cacheSize, null);
    }

    public LRUMap(int cacheSize, RemovalListener<K, V> removalListener) {
        super((int)Math.ceil((double)cacheSize / 0.75) + 1, 0.75f, true);
        this.cacheSize = cacheSize;
        this.removalListener = removalListener;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.cacheSize) {
            if (this.removalListener != null) {
                this.removalListener.onRemoval(eldest);
            }
            return true;
        }
        return false;
    }

    public static interface RemovalListener<K, V> {
        public void onRemoval(Map.Entry<K, V> var1);
    }
}

