/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.filesystem.PartitionCommitPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuccessFileCommitPolicy
implements PartitionCommitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SuccessFileCommitPolicy.class);
    private final String fileName;
    private final FileSystem fileSystem;

    public SuccessFileCommitPolicy(String fileName, FileSystem fileSystem) {
        this.fileName = fileName;
        this.fileSystem = fileSystem;
    }

    @Override
    public void commit(PartitionCommitPolicy.Context context) throws Exception {
        this.fileSystem.create(new Path(context.partitionPath(), this.fileName), FileSystem.WriteMode.OVERWRITE).close();
        LOG.info("Committed partition {} with success file", context.partitionSpec());
    }
}

