/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.transforms;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

public class LegacyDecimalTypeTransformation
implements TypeTransformation {
    public static final TypeTransformation INSTANCE = new LegacyDecimalTypeTransformation();

    @Override
    public DataType transform(DataType typeToTransform) {
        LogicalType logicalType = typeToTransform.getLogicalType();
        if (logicalType instanceof LegacyTypeInformationType && logicalType.getTypeRoot() == LogicalTypeRoot.DECIMAL) {
            DataType decimalType = (DataType)DataTypes.DECIMAL(38, 18).bridgedTo(typeToTransform.getConversionClass());
            return logicalType.isNullable() ? decimalType : (DataType)decimalType.notNull();
        }
        return typeToTransform;
    }
}

