/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.module.CoreModule;
import org.apache.flink.table.module.Module;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleManager.class);
    private LinkedHashMap<String, Module> modules = new LinkedHashMap();

    public ModuleManager() {
        this.modules.put("core", (Module)CoreModule.INSTANCE);
    }

    public void loadModule(String name, Module module) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)name) ? 1 : 0) != 0, (Object)"name cannot be null or empty string");
        Preconditions.checkNotNull((Object)module, (String)"module cannot be null");
        if (this.modules.containsKey(name)) {
            throw new ValidationException(String.format("A module with name %s already exists", name));
        }
        this.modules.put(name, module);
        LOG.info("Loaded module {} from class {}", (Object)name, (Object)module.getClass().getName());
    }

    public void unloadModule(String name) {
        if (!this.modules.containsKey(name)) {
            throw new ValidationException(String.format("No module with name %s exists", name));
        }
        this.modules.remove(name);
        LOG.info("Unloaded module {}", (Object)name);
    }

    public List<String> listModules() {
        return new ArrayList<String>(this.modules.keySet());
    }

    public Set<String> listFunctions() {
        return this.modules.values().stream().map(m -> m.listFunctions()).flatMap(n -> n.stream()).collect(Collectors.toSet());
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        Optional<Map.Entry> result = this.modules.entrySet().stream().filter(p -> ((Module)p.getValue()).listFunctions().stream().anyMatch(e -> e.equalsIgnoreCase(name))).findFirst();
        if (result.isPresent()) {
            LOG.debug("Got FunctionDefinition '{}' from '{}' module.", (Object)name, result.get().getKey());
            return ((Module)result.get().getValue()).getFunctionDefinition(name);
        }
        LOG.debug("Cannot find FunctionDefinition '{}' from any loaded modules.", (Object)name);
        return Optional.empty();
    }
}

