/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.GenericInMemoryCatalogValidator;
import org.apache.flink.table.factories.CatalogFactory;

public class GenericInMemoryCatalogFactory
implements CatalogFactory {
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("type", "generic_in_memory");
        context.put("property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("default-database");
        return properties;
    }

    public Catalog createCatalog(String name, Map<String, String> properties) {
        DescriptorProperties descriptorProperties = GenericInMemoryCatalogFactory.getValidatedProperties(properties);
        Optional defaultDatabase = descriptorProperties.getOptionalString("default-database");
        return new GenericInMemoryCatalog(name, defaultDatabase.orElse("default"));
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        new GenericInMemoryCatalogValidator().validate(descriptorProperties);
        return descriptorProperties;
    }
}

