/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.AbstractCatalogTable;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.descriptors.DescriptorProperties;

public class CatalogTableImpl
extends AbstractCatalogTable {
    public CatalogTableImpl(TableSchema tableSchema, Map<String, String> properties, String comment) {
        this(tableSchema, new ArrayList<String>(), properties, comment);
    }

    public CatalogTableImpl(TableSchema tableSchema, List<String> partitionKeys, Map<String, String> properties, String comment) {
        super(tableSchema, partitionKeys, properties, comment);
    }

    public CatalogBaseTable copy() {
        return new CatalogTableImpl(this.getSchema().copy(), new ArrayList<String>(this.getPartitionKeys()), new HashMap<String, String>(this.getProperties()), this.getComment());
    }

    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    public Optional<String> getDetailedDescription() {
        return Optional.of("This is a catalog table in an im-memory catalog");
    }

    public Map<String, String> toProperties() {
        DescriptorProperties descriptor = new DescriptorProperties();
        descriptor.putTableSchema("schema", this.getSchema());
        descriptor.putPartitionKeys(this.getPartitionKeys());
        HashMap<String, String> properties = new HashMap<String, String>(this.getProperties());
        properties.remove("is_generic");
        descriptor.putProperties(properties);
        return descriptor.asMap();
    }

    public CatalogTable copy(Map<String, String> options) {
        return new CatalogTableImpl(this.getSchema(), this.getPartitionKeys(), options, this.getComment());
    }

    public static CatalogTableImpl fromProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(properties);
        TableSchema tableSchema = descriptorProperties.getTableSchema("schema");
        List partitionKeys = descriptorProperties.getPartitionKeys();
        return new CatalogTableImpl(tableSchema, partitionKeys, CatalogTableImpl.removeRedundant(properties, tableSchema, partitionKeys), "");
    }

    public static Map<String, String> removeRedundant(Map<String, String> properties, TableSchema schema, List<String> partitionKeys) {
        HashMap<String, String> ret = new HashMap<String, String>(properties);
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putTableSchema("schema", schema);
        descriptorProperties.putPartitionKeys(partitionKeys);
        descriptorProperties.asMap().keySet().forEach(ret::remove);
        return ret;
    }
}

