/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.config;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.api.SqlDialect;

@PublicEvolving
public class TableConfigOptions {
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Boolean> TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED = ConfigOptions.key((String)"table.dynamic-table-options.enabled").booleanType().defaultValue((Object)false).withDescription("Enable or disable the OPTIONS hint used to specify table options dynamically, if disabled, an exception would be thrown if any OPTIONS hint is specified");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<String> TABLE_SQL_DIALECT = ConfigOptions.key((String)"table.sql-dialect").stringType().defaultValue((Object)SqlDialect.DEFAULT.name().toLowerCase()).withDescription("The SQL dialect defines how to parse a SQL query. A different SQL dialect may support different SQL grammar. Currently supported dialects are: default and hive");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<String> LOCAL_TIME_ZONE = ConfigOptions.key((String)"table.local-time-zone").stringType().defaultValue((Object)"default").withDescription("The local time zone defines current session time zone id. It is used when converting to/from <code>TIMESTAMP WITH LOCAL TIME ZONE</code>. Internally, timestamps with local time zone are always represented in the UTC time zone. However, when converting to data types that don't include a time zone (e.g. TIMESTAMP, TIME, or simply STRING), the session time zone is used during conversion. The input of option is either an abbreviation such as \"PST\", a full name such as \"America/Los_Angeles\", or a custom timezone id such as \"GMT-8:00\".");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Integer> MAX_LENGTH_GENERATED_CODE = ConfigOptions.key((String)"table.generated-code.max-length").intType().defaultValue((Object)64000).withDescription("Specifies a threshold where generated code will be split into sub-function calls. Java has a maximum method length of 64 KB. This setting allows for finer granularity if necessary.");

    private TableConfigOptions() {
    }
}

