/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchExecutionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BatchExecutionUtils.class);

    static void applyBatchExecutionSettings(int transformationId, TransformationTranslator.Context context, StreamConfig.InputRequirement ... inputRequirements) {
        StreamNode node = context.getStreamGraph().getStreamNode(transformationId);
        boolean sortInputs = (Boolean)context.getGraphGeneratorConfig().get(ExecutionOptions.SORT_INPUTS);
        boolean isInputSelectable = BatchExecutionUtils.isInputSelectable(node);
        BatchExecutionUtils.adjustChainingStrategy(node);
        Preconditions.checkState((!isInputSelectable || !sortInputs ? 1 : 0) != 0, (Object)"Batch state backend and sorting inputs are not supported in graphs with an InputSelectable operator.");
        if (sortInputs) {
            LOG.debug("Applying sorting/pass-through input requirements for operator {}.", (Object)node);
            for (int i = 0; i < inputRequirements.length; ++i) {
                node.addInputRequirement(i, inputRequirements[i]);
            }
            HashMap<ManagedMemoryUseCase, Integer> operatorScopeUseCaseWeights = new HashMap<ManagedMemoryUseCase, Integer>();
            operatorScopeUseCaseWeights.put(ManagedMemoryUseCase.OPERATOR, 1);
            node.setManagedMemoryUseCaseWeights(operatorScopeUseCaseWeights, Collections.emptySet());
        }
    }

    private static boolean isInputSelectable(StreamNode node) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<StreamOperator> operatorClass = node.getOperatorFactory().getStreamOperatorClass(classLoader);
        return InputSelectable.class.isAssignableFrom(operatorClass);
    }

    private static void adjustChainingStrategy(StreamNode node) {
        StreamOperatorFactory<?> operatorFactory = node.getOperatorFactory();
        ChainingStrategy currentChainingStrategy = operatorFactory.getChainingStrategy();
        switch (currentChainingStrategy) {
            case ALWAYS: 
            case HEAD_WITH_SOURCES: {
                LOG.debug("Setting chaining strategy to HEAD for operator {}, because of the BATCH execution mode.", (Object)node);
                operatorFactory.setChainingStrategy(ChainingStrategy.HEAD);
                break;
            }
        }
    }

    private BatchExecutionUtils() {
    }
}

