/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingCollectingBarriersUnaligned;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingWaitingForFirstBarrier;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.ChannelState;

final class AlternatingWaitingForFirstBarrierUnaligned
implements BarrierHandlerState {
    private final boolean alternating;
    private final ChannelState channelState;

    AlternatingWaitingForFirstBarrierUnaligned(boolean alternating, ChannelState channelState) {
        this.alternating = alternating;
        this.channelState = channelState;
    }

    @Override
    public BarrierHandlerState alignmentTimeout(BarrierHandlerState.Controller controller, CheckpointBarrier checkpointBarrier) {
        return this;
    }

    @Override
    public BarrierHandlerState announcementReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, int sequenceNumber) throws IOException {
        this.channelState.getInputs()[channelInfo.getGateIdx()].convertToPriorityEvent(channelInfo.getInputChannelIdx(), sequenceNumber);
        return this;
    }

    @Override
    public BarrierHandlerState barrierReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, CheckpointBarrier checkpointBarrier) throws CheckpointException, IOException {
        if (!checkpointBarrier.getCheckpointOptions().isUnalignedCheckpoint()) {
            this.channelState.blockChannel(channelInfo);
        }
        CheckpointBarrier unalignedBarrier = checkpointBarrier.asUnaligned();
        controller.initInputsCheckpoint(unalignedBarrier);
        for (CheckpointableInput input : this.channelState.getInputs()) {
            input.checkpointStarted(unalignedBarrier);
        }
        controller.triggerGlobalCheckpoint(unalignedBarrier);
        if (controller.allBarriersReceived()) {
            for (CheckpointableInput input : this.channelState.getInputs()) {
                input.checkpointStopped(unalignedBarrier.getId());
            }
            return this.stopCheckpoint();
        }
        return new AlternatingCollectingBarriersUnaligned(this.alternating, this.channelState);
    }

    @Override
    public BarrierHandlerState abort(long cancelledId) throws IOException {
        return this.stopCheckpoint();
    }

    private BarrierHandlerState stopCheckpoint() throws IOException {
        this.channelState.unblockAllChannels();
        if (this.alternating) {
            return new AlternatingWaitingForFirstBarrier(this.channelState.emptyState());
        }
        return new AlternatingWaitingForFirstBarrierUnaligned(false, this.channelState.emptyState());
    }
}

