/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.function.Consumer;
import org.apache.flink.api.connector.source.ExternallyInducedSourceReader;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.streaming.api.operators.SourceOperator;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamTaskSourceInput;

public class StreamTaskExternallyInducedSourceInput<T>
extends StreamTaskSourceInput<T> {
    private final Consumer<Long> checkpointTriggeringHook;
    private final ExternallyInducedSourceReader<T, ?> sourceReader;

    public StreamTaskExternallyInducedSourceInput(SourceOperator<T, ?> operator, Consumer<Long> checkpointTriggeringHook, int inputGateIndex, int inputIndex) {
        super(operator, inputGateIndex, inputIndex);
        this.checkpointTriggeringHook = checkpointTriggeringHook;
        this.sourceReader = (ExternallyInducedSourceReader)operator.getSourceReader();
    }

    @Override
    public InputStatus emitNext(PushingAsyncDataInput.DataOutput<T> output) throws Exception {
        InputStatus status = super.emitNext(output);
        if (status == InputStatus.NOTHING_AVAILABLE) {
            this.sourceReader.shouldTriggerCheckpoint().ifPresent(this.checkpointTriggeringHook);
        }
        return status;
    }
}

