/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.StateEntry;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.heap.NestedStateMapSnapshot;
import org.apache.flink.runtime.state.heap.StateMap;
import org.apache.flink.runtime.state.heap.StateMapSnapshot;
import org.apache.flink.runtime.state.internal.InternalKvState;

public class NestedStateMap<K, N, S>
extends StateMap<K, N, S> {
    private final Map<N, Map<K, S>> namespaceMap = new HashMap<N, Map<K, S>>();

    @Override
    public int size() {
        int count = 0;
        for (Map<K, S> keyMap : this.namespaceMap.values()) {
            if (null == keyMap) continue;
            count += keyMap.size();
        }
        return count;
    }

    @Override
    public S get(K key, N namespace) {
        Map<K, S> keyedMap = this.namespaceMap.get(namespace);
        if (keyedMap == null) {
            return null;
        }
        return keyedMap.get(key);
    }

    @Override
    public boolean containsKey(K key, N namespace) {
        Map<K, S> keyedMap = this.namespaceMap.get(namespace);
        return keyedMap != null && keyedMap.containsKey(key);
    }

    @Override
    public void put(K key, N namespace, S state) {
        this.putAndGetOld(key, namespace, state);
    }

    @Override
    public S putAndGetOld(K key, N namespace, S state) {
        Map keyedMap = this.namespaceMap.computeIfAbsent(namespace, k -> new HashMap());
        return keyedMap.put(key, state);
    }

    @Override
    public void remove(K key, N namespace) {
        this.removeAndGetOld(key, namespace);
    }

    @Override
    public S removeAndGetOld(K key, N namespace) {
        Map<K, S> keyedMap = this.namespaceMap.get(namespace);
        if (keyedMap == null) {
            return null;
        }
        S removed = keyedMap.remove(key);
        if (keyedMap.isEmpty()) {
            this.namespaceMap.remove(namespace);
        }
        return removed;
    }

    @Override
    public <T> void transform(K key, N namespace, T value, StateTransformationFunction<S, T> transformation) throws Exception {
        Map keyedMap = this.namespaceMap.computeIfAbsent(namespace, k -> new HashMap());
        keyedMap.put(key, transformation.apply(keyedMap.get(key), value));
    }

    @Override
    public Iterator<StateEntry<K, N, S>> iterator() {
        return new StateEntryIterator();
    }

    @Override
    public Stream<K> getKeys(N namespace) {
        return this.namespaceMap.getOrDefault(namespace, Collections.emptyMap()).keySet().stream();
    }

    @Override
    public InternalKvState.StateIncrementalVisitor<K, N, S> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        return new StateEntryVisitor();
    }

    @Override
    public int sizeOfNamespace(Object namespace) {
        Map<K, S> keyMap = this.namespaceMap.get(namespace);
        return keyMap != null ? keyMap.size() : 0;
    }

    @Override
    @Nonnull
    public StateMapSnapshot<K, N, S, ? extends StateMap<K, N, S>> stateSnapshot() {
        return new NestedStateMapSnapshot(this);
    }

    public Map<N, Map<K, S>> getNamespaceMap() {
        return this.namespaceMap;
    }

    class StateEntryVisitor
    implements InternalKvState.StateIncrementalVisitor<K, N, S>,
    Iterator<StateEntry<K, N, S>> {
        private Iterator<Map.Entry<N, Map<K, S>>> namespaceIterator;
        private Map.Entry<N, Map<K, S>> namespace;
        private Iterator<Map.Entry<K, S>> keyValueIterator;
        private StateEntry<K, N, S> nextEntry;
        private StateEntry<K, N, S> lastReturnedEntry;

        StateEntryVisitor() {
            this.namespaceIterator = new HashSet(NestedStateMap.this.namespaceMap.entrySet()).iterator();
            this.namespace = null;
            this.keyValueIterator = null;
            this.nextKeyIterator();
        }

        @Override
        public boolean hasNext() {
            this.nextKeyIterator();
            return this.keyIteratorHasNext();
        }

        @Override
        public Collection<StateEntry<K, N, S>> nextEntries() {
            Object nextEntry = this.next();
            return nextEntry == null ? Collections.emptyList() : Collections.singletonList(nextEntry);
        }

        @Override
        public StateEntry<K, N, S> next() {
            StateEntry next = null;
            if (this.hasNext()) {
                next = this.nextEntry;
            }
            this.nextEntry = null;
            this.lastReturnedEntry = next;
            return next;
        }

        private void nextKeyIterator() {
            while (!this.keyIteratorHasNext() && this.namespaceIteratorHasNext()) {
                this.namespace = this.namespaceIterator.next();
                this.keyValueIterator = new HashSet(this.namespace.getValue().entrySet()).iterator();
            }
        }

        private boolean keyIteratorHasNext() {
            while (this.nextEntry == null && this.keyValueIterator != null && this.keyValueIterator.hasNext()) {
                Map.Entry next = this.keyValueIterator.next();
                Map ns = NestedStateMap.this.namespaceMap.getOrDefault(this.namespace.getKey(), null);
                Object upToDateValue = ns == null ? null : ns.getOrDefault(next.getKey(), null);
                if (upToDateValue == null) continue;
                this.nextEntry = new StateEntry.SimpleStateEntry(next.getKey(), this.namespace.getKey(), upToDateValue);
            }
            return this.nextEntry != null;
        }

        private boolean namespaceIteratorHasNext() {
            return this.namespaceIterator.hasNext();
        }

        @Override
        public void remove() {
            this.remove((StateEntry<K, N, S>)this.lastReturnedEntry);
        }

        @Override
        public void remove(StateEntry<K, N, S> stateEntry) {
            ((Map)NestedStateMap.this.namespaceMap.get(stateEntry.getNamespace())).remove(stateEntry.getKey());
        }

        @Override
        public void update(StateEntry<K, N, S> stateEntry, S newValue) {
            ((Map)NestedStateMap.this.namespaceMap.get(stateEntry.getNamespace())).put(stateEntry.getKey(), newValue);
        }
    }

    class StateEntryIterator
    implements Iterator<StateEntry<K, N, S>> {
        private Iterator<Map.Entry<N, Map<K, S>>> namespaceIterator;
        private Map.Entry<N, Map<K, S>> namespace;
        private Iterator<Map.Entry<K, S>> keyValueIterator;

        StateEntryIterator() {
            this.namespaceIterator = NestedStateMap.this.namespaceMap.entrySet().iterator();
            this.namespace = null;
            this.keyValueIterator = Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.keyValueIterator.hasNext() || this.namespaceIterator.hasNext();
        }

        @Override
        public StateEntry<K, N, S> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.keyValueIterator.hasNext()) {
                this.namespace = this.namespaceIterator.next();
                this.keyValueIterator = this.namespace.getValue().entrySet().iterator();
            }
            Map.Entry entry = this.keyValueIterator.next();
            return new StateEntry.SimpleStateEntry(entry.getKey(), this.namespace.getKey(), entry.getValue());
        }
    }
}

