/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingSlotRequest;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotId;
import org.apache.flink.util.Preconditions;

public class PendingTaskManagerSlot {
    private final TaskManagerSlotId taskManagerSlotId = TaskManagerSlotId.generate();
    private final ResourceProfile resourceProfile;
    @Nullable
    private PendingSlotRequest pendingSlotRequest;

    public PendingTaskManagerSlot(ResourceProfile resourceProfile) {
        this.resourceProfile = resourceProfile;
    }

    public TaskManagerSlotId getTaskManagerSlotId() {
        return this.taskManagerSlotId;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public void assignPendingSlotRequest(@Nonnull PendingSlotRequest pendingSlotRequestToAssign) {
        Preconditions.checkState((this.pendingSlotRequest == null ? 1 : 0) != 0);
        this.pendingSlotRequest = pendingSlotRequestToAssign;
    }

    public void unassignPendingSlotRequest() {
        this.pendingSlotRequest = null;
    }

    @Nullable
    public PendingSlotRequest getAssignedPendingSlotRequest() {
        return this.pendingSlotRequest;
    }
}

